/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.heapwalk;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.netbeans.api.debugger.jpda.ClassVariable;
import org.netbeans.api.debugger.jpda.Field;
import org.netbeans.api.debugger.jpda.JPDAArrayType;
import org.netbeans.api.debugger.jpda.JPDAClassType;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.lib.profiler.heap.FieldValue;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.heap.ObjectFieldValue;
import org.netbeans.lib.profiler.heap.Value;
import org.netbeans.modules.debugger.jpda.heapwalk.ArrayItemValueImpl;
import org.netbeans.modules.debugger.jpda.heapwalk.FieldValueImpl;
import org.netbeans.modules.debugger.jpda.heapwalk.HeapImpl;
import org.netbeans.modules.debugger.jpda.heapwalk.JavaClassImpl;
import org.netbeans.modules.debugger.jpda.heapwalk.ObjectArrayInstanceImpl;
import org.netbeans.modules.debugger.jpda.heapwalk.ObjectFieldValueImpl;
import org.netbeans.modules.debugger.jpda.heapwalk.PrimitiveArrayInstanceImpl;
import org.openide.util.Exceptions;

public class InstanceImpl
implements Instance {
    private ObjectVariable var;
    private JavaClass varClass;
    protected HeapImpl heap;

    protected InstanceImpl(HeapImpl heap, ObjectVariable var) {
        this.var = var;
        this.heap = heap;
    }

    public static Instance createInstance(HeapImpl heap, ObjectVariable var) {
        InstanceImpl instance;
        JPDAClassType type = var.getClassType();
        if (type instanceof JPDAArrayType) {
            boolean isPrimitiveArray;
            boolean bl = isPrimitiveArray = !(((JPDAArrayType)type).getComponentType() instanceof JPDAClassType);
            instance = isPrimitiveArray ? new PrimitiveArrayInstanceImpl(heap, var) : new ObjectArrayInstanceImpl(heap, var);
        } else {
            instance = new InstanceImpl(heap, var);
        }
        instance.varClass = InstanceImpl.getJavaClass(heap, var);
        return instance;
    }

    private static JavaClass getJavaClass(HeapImpl heap, ObjectVariable var) {
        JPDAClassType type = var.getClassType();
        if (type != null) {
            return new JavaClassImpl(heap, type);
        }
        return new JavaClassImpl(var.getType());
    }

    public JavaClass getJavaClass() {
        return this.varClass;
    }

    public long getInstanceId() {
        return this.var.getUniqueID();
    }

    public int getInstanceNumber() {
        return (int)this.var.getUniqueID();
    }

    public long getSize() {
        return 0L;
    }

    public List<FieldValue> getFieldValues() {
        int fieldsCount = this.var.getFieldsCount();
        Field[] varFields = this.var.getFields(0, fieldsCount);
        ArrayList<FieldValue> fields = new ArrayList<FieldValue>(varFields.length);
        for (Field field : varFields) {
            if (field.isStatic()) continue;
            if (field instanceof ObjectVariable) {
                Instance instance = ((ObjectVariable)field).getUniqueID() == 0L ? null : InstanceImpl.createInstance(this.heap, (ObjectVariable)field);
                fields.add(new ObjectFieldValueImpl(this.heap, this, field, instance));
                continue;
            }
            fields.add(new FieldValueImpl(this.heap, this, field));
        }
        return fields;
    }

    public Object getValueOfField(String name) {
        Iterator<FieldValue> fIt = this.getFieldValues().iterator();
        FieldValue matchingFieldValue = null;
        while (fIt.hasNext()) {
            FieldValue fieldValue = fIt.next();
            if (!fieldValue.getField().getName().equals(name)) continue;
            matchingFieldValue = fieldValue;
        }
        if (matchingFieldValue == null) {
            return null;
        }
        if (matchingFieldValue instanceof ObjectFieldValue) {
            return ((ObjectFieldValue)matchingFieldValue).getInstance();
        }
        return matchingFieldValue.getValue();
    }

    public List<FieldValue> getStaticFieldValues() {
        return this.getJavaClass().getStaticFieldValues();
    }

    public List<Value> getReferences() {
        List references = this.var.getReferringObjects(0L);
        ArrayList<Value> values = new ArrayList<Value>(references.size());
        HashSet<Field> referencedFields = new HashSet<Field>();
        block6: for (ObjectVariable obj : references) {
            Field[] allFields;
            JPDAClassType type = obj.getClassType();
            if (type instanceof JPDAArrayType) {
                int length = obj.getFieldsCount();
                int CHUNK = 1000;
                for (int i = 0; i < length; i += CHUNK) {
                    int to = Math.min(i + CHUNK, length);
                    Field[] items = obj.getFields(i, to);
                    int j = i;
                    for (Field item : items) {
                        if (this.var.equals((Object)item)) {
                            Instance instance = InstanceImpl.createInstance(this.heap, obj);
                            values.add((Value)new ArrayItemValueImpl(instance, this, j));
                            break;
                        }
                        ++j;
                    }
                    if (j < to) continue block6;
                }
                continue;
            }
            if (obj instanceof ClassVariable) {
                try {
                    type = (JPDAClassType)obj.getClass().getMethod("getReflectedType", new Class[0]).invoke((Object)obj, new Object[0]);
                }
                catch (NoSuchMethodException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (SecurityException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (IllegalAccessException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (IllegalArgumentException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (InvocationTargetException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                allFields = type.staticFields().toArray(new Field[0]);
            } else {
                Field[] instanceFields = obj.getFields(0, Integer.MAX_VALUE);
                Field[] inheritedFields = obj.getInheritedFields(0, Integer.MAX_VALUE);
                Field[] staticFields = obj.getAllStaticFields(0, Integer.MAX_VALUE);
                allFields = new Field[instanceFields.length + inheritedFields.length + staticFields.length];
                System.arraycopy(instanceFields, 0, allFields, 0, instanceFields.length);
                System.arraycopy(inheritedFields, 0, allFields, instanceFields.length, inheritedFields.length);
                System.arraycopy(staticFields, 0, allFields, instanceFields.length + inheritedFields.length, staticFields.length);
            }
            for (Field field : allFields) {
                if (!(field instanceof ObjectVariable) || referencedFields.contains(field) || this.var.getUniqueID() != ((ObjectVariable)field).getUniqueID()) continue;
                referencedFields.add(field);
                Instance instance = InstanceImpl.createInstance(this.heap, obj);
                values.add((Value)new ObjectFieldValueImpl(this.heap, instance, field, this));
                continue block6;
            }
        }
        return values;
    }

    public boolean isGCRoot() {
        return false;
    }

    public long getRetainedSize() {
        return 0L;
    }

    public long getReachableSize() {
        return 0L;
    }

    public Instance getNearestGCRootPointer() {
        return null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof InstanceImpl)) {
            return false;
        }
        return this.var.getUniqueID() == ((InstanceImpl)obj).var.getUniqueID();
    }

    public int hashCode() {
        return (int)this.var.getUniqueID();
    }
}

