/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.dd.api.web;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.modules.j2ee.dd.api.common.CommonDDBean;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.dd.impl.common.DDUtils;
import org.netbeans.modules.j2ee.dd.impl.web.WebAppProxy;
import org.netbeans.modules.j2ee.dd.impl.web.WebParseUtils;
import org.netbeans.modules.schema2beans.BaseBean;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

@SuppressWarnings(value={"DMI_COLLECTION_OF_URLS"}, justification="File URLs only")
public final class DDProvider {
    private static DDProvider ddProvider;
    private final Map<URL, WeakReference<WebAppProxy>> ddMap = new HashMap<URL, WeakReference<WebAppProxy>>(5);
    private final Map<URL, WeakReference<WebApp>> baseBeanMap = new HashMap<URL, WeakReference<WebApp>>(5);
    private final Map<URL, SAXParseException> errorMap = new HashMap<URL, SAXParseException>(5);
    private final FCA fileChangeListener = new FCA();
    private static final Logger LOGGER;

    private DDProvider() {
    }

    public static synchronized DDProvider getDefault() {
        if (ddProvider == null) {
            ddProvider = new DDProvider();
        }
        return ddProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebApp getDDRoot(FileObject fo) throws IOException {
        Parameters.notNull((CharSequence)"fo", (Object)fo);
        WebAppProxy webApp = null;
        Map<URL, WeakReference<WebAppProxy>> map = this.ddMap;
        synchronized (map) {
            webApp = this.getFromCache(fo);
            if (webApp != null) {
                return webApp;
            }
        }
        fo.addFileChangeListener((FileChangeListener)this.fileChangeListener);
        String version = null;
        SAXParseException error = null;
        try {
            WebApp original = null;
            Map<URL, WeakReference<WebApp>> map2 = this.baseBeanMap;
            synchronized (map2) {
                original = this.getOriginalFromCache(fo);
                if (original == null) {
                    version = WebParseUtils.getVersion(fo);
                    if (version != null) {
                        error = this.parse(fo);
                        original = DDUtils.createWebApp(fo, version);
                        this.baseBeanMap.put(fo.toURL(), new WeakReference<WebApp>(original));
                        this.errorMap.put(fo.toURL(), error);
                    }
                } else {
                    version = original.getVersion();
                    error = this.errorMap.get(fo.toURL());
                }
            }
            if (version != null) {
                webApp = new WebAppProxy(original, version);
                if (original == null) {
                    webApp.setStatus(3);
                } else if (error != null) {
                    webApp.setStatus(1);
                    webApp.setError(error);
                }
            } else {
                webApp = new WebAppProxy(null, null);
                webApp.setStatus(2);
                webApp.setError(new SAXParseException(NbBundle.getMessage(DDProvider.class, (String)"MSG_cannotDetermineVersion"), null));
            }
        }
        catch (SAXException ex) {
            webApp = new WebAppProxy(null, version);
            webApp.setStatus(2);
            if (ex instanceof SAXParseException) {
                webApp.setError((SAXParseException)ex);
            } else if (ex.getException() instanceof SAXParseException) {
                webApp.setError((SAXParseException)ex.getException());
            }
        }
        catch (FileNotFoundException fnfe) {
            LOGGER.log(Level.INFO, "A file referenced from [" + FileUtil.getFileDisplayName((FileObject)fo) + "] could not be found", fnfe);
            webApp = new WebAppProxy(null, version);
            webApp.setStatus(2);
            webApp.setError(new SAXParseException(fnfe.getMessage(), null, fnfe));
        }
        Map<URL, WeakReference<WebAppProxy>> map3 = this.ddMap;
        synchronized (map3) {
            WebAppProxy cached = this.getFromCache(fo);
            if (cached != null) {
                return cached;
            }
            this.ddMap.put(fo.toURL(), new WeakReference<WebAppProxy>(webApp));
        }
        return webApp;
    }

    public WebApp getDDRoot(FileObject fo, boolean useCache) throws IOException {
        if (!useCache) {
            this.removeFromCache(fo);
        }
        return this.getDDRoot(fo);
    }

    public WebApp getDDRootCopy(FileObject fo) throws IOException {
        return (WebApp)this.getDDRoot(fo).clone();
    }

    private WebAppProxy getFromCache(FileObject fo) throws IOException {
        WeakReference<WebAppProxy> wr = this.ddMap.get(fo.toURL());
        if (wr == null) {
            return null;
        }
        WebAppProxy webApp = (WebAppProxy)wr.get();
        if (webApp == null) {
            this.ddMap.remove(fo.toURL());
        }
        return webApp;
    }

    private WebApp getOriginalFromCache(FileObject fo) throws IOException {
        WeakReference<WebApp> wr = this.baseBeanMap.get(fo.toURL());
        if (wr == null) {
            return null;
        }
        WebApp webApp = (WebApp)wr.get();
        if (webApp == null) {
            this.baseBeanMap.remove(fo.toURL());
            this.errorMap.remove(fo.toURL());
        }
        return webApp;
    }

    public WebApp getDDRoot(File f) throws IOException, SAXException {
        FileObject fileObject = FileUtil.toFileObject((File)f);
        if (fileObject == null) {
            throw new IOException(String.format("File: %s does not exist.", f.getAbsolutePath()));
        }
        return DDUtils.createWebApp(fileObject, WebParseUtils.getVersion(fileObject));
    }

    @Deprecated
    public BaseBean getBaseBean(CommonDDBean bean) {
        if (bean instanceof BaseBean) {
            return (BaseBean)bean;
        }
        if (bean instanceof WebAppProxy) {
            return (BaseBean)((WebAppProxy)bean).getOriginal();
        }
        return null;
    }

    public SAXParseException parse(FileObject fo) throws SAXException, IOException {
        return WebParseUtils.parse(fo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromCache(FileObject fo) {
        URL foUrl = fo.toURL();
        Map<URL, WeakReference<WebAppProxy>> map = this.ddMap;
        synchronized (map) {
            this.ddMap.remove(foUrl);
        }
        this.baseBeanMap.remove(foUrl);
        this.errorMap.remove(foUrl);
    }

    static {
        LOGGER = Logger.getLogger(DDProvider.class.getName());
    }

    private class FCA
    extends FileChangeAdapter {
        private FCA() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fileChanged(FileEvent evt) {
            FileObject fo = evt.getFile();
            try {
                Map map = DDProvider.this.ddMap;
                synchronized (map) {
                    Map map2 = DDProvider.this.baseBeanMap;
                    synchronized (map2) {
                        WebAppProxy webApp = DDProvider.this.getFromCache(fo);
                        WebApp orig = DDProvider.this.getOriginalFromCache(fo);
                        if (webApp != null) {
                            String version = null;
                            try {
                                version = WebParseUtils.getVersion(fo);
                                SAXParseException error = DDProvider.this.parse(fo);
                                if (error != null) {
                                    webApp.setError(error);
                                    webApp.setStatus(1);
                                } else {
                                    webApp.setError(null);
                                    webApp.setStatus(0);
                                }
                                WebApp original = DDUtils.createWebApp(fo, version);
                                if (original == null) {
                                    webApp.setStatus(3);
                                    webApp.setError(null);
                                }
                                DDProvider.this.baseBeanMap.put(fo.toURL(), new WeakReference<WebApp>(original));
                                DDProvider.this.errorMap.put(fo.toURL(), webApp.getError());
                                webApp.merge(original, 3);
                            }
                            catch (SAXException ex) {
                                if (ex instanceof SAXParseException) {
                                    webApp.setError((SAXParseException)ex);
                                } else if (ex.getException() instanceof SAXParseException) {
                                    webApp.setError((SAXParseException)ex.getException());
                                }
                                webApp.setStatus(2);
                                webApp.setOriginal(null);
                                webApp.setProxyVersion(version);
                            }
                        } else if (orig != null) {
                            String version = null;
                            try {
                                version = WebParseUtils.getVersion(fo);
                                WebApp original = DDUtils.createWebApp(fo, version);
                                if (original == null) {
                                    DDProvider.this.baseBeanMap.remove(fo.toURL());
                                } else if (original.getClass().equals(orig.getClass())) {
                                    orig.merge(original, 3);
                                } else {
                                    DDProvider.this.baseBeanMap.put(fo.toURL(), new WeakReference<WebApp>(original));
                                }
                            }
                            catch (SAXException ex) {
                                DDProvider.this.baseBeanMap.remove(fo.toURL());
                            }
                        }
                    }
                }
            }
            catch (IOException ex) {
                LOGGER.log(Level.INFO, "Merging of webApp graphs failed.", ex);
            }
        }

        public void fileDeleted(FileEvent fe) {
            DDProvider.this.removeFromCache(fe.getFile());
        }
    }
}

