/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.scenebuilder.options;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.PopupMenuListener;

public class GrowingComboBox
extends JPanel {
    private static final String SEPARATOR = "---";
    private String nullSelectionMessage = "<null>";
    private JComboBox combo;

    public GrowingComboBox() {
        this.initComponents();
        this.combo.setRenderer(new DefaultListCellRenderer(){
            private JSeparator separator = new JSeparator(0);

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (GrowingComboBox.SEPARATOR.equals(value)) {
                    return this.separator;
                }
                String s = "";
                s = value != null ? (value instanceof Action ? (String)((Action)value).getValue("Name") : value.toString()) : GrowingComboBox.this.nullSelectionMessage;
                return super.getListCellRendererComponent((JList<?>)list, s, index, isSelected, cellHasFocus);
            }
        });
        this.combo.setModel(new GrowingListModel());
    }

    private void initComponents() {
        this.combo = new JComboBox();
        this.combo.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.combo, 0, 155, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.combo, -2, -1, -2));
    }

    public void showPopup() {
        this.combo.showPopup();
    }

    public void setSelectedItem(Object anObject) {
        this.combo.setSelectedItem(anObject);
    }

    public void setSelectedIndex(int anIndex) {
        this.combo.setSelectedIndex(anIndex);
    }

    public void setPrototypeDisplayValue(Object prototypeDisplayValue) {
        this.combo.setPrototypeDisplayValue(prototypeDisplayValue);
    }

    public void setPopupVisible(boolean v) {
        this.combo.setPopupVisible(v);
    }

    public void setMaximumRowCount(int count) {
        this.combo.setMaximumRowCount(count);
    }

    public void setLightWeightPopupEnabled(boolean aFlag) {
        this.combo.setLightWeightPopupEnabled(aFlag);
    }

    public void setKeySelectionManager(JComboBox.KeySelectionManager aManager) {
        this.combo.setKeySelectionManager(aManager);
    }

    @Override
    public void setEnabled(boolean b) {
        this.combo.setEnabled(b);
    }

    public void setEditor(ComboBoxEditor anEditor) {
        this.combo.setEditor(anEditor);
    }

    public void setEditable(boolean aFlag) {
        this.combo.setEditable(aFlag);
    }

    public boolean selectWithKeyChar(char keyChar) {
        return this.combo.selectWithKeyChar(keyChar);
    }

    public void removePopupMenuListener(PopupMenuListener l) {
        this.combo.removePopupMenuListener(l);
    }

    public void removeItemListener(ItemListener aListener) {
        this.combo.removeItemListener(aListener);
    }

    public void removeActionListener(ActionListener l) {
        this.combo.removeActionListener(l);
    }

    @Override
    public void processKeyEvent(KeyEvent e) {
        this.combo.processKeyEvent(e);
    }

    public boolean isPopupVisible() {
        return this.combo.isPopupVisible();
    }

    public boolean isLightWeightPopupEnabled() {
        return this.combo.isLightWeightPopupEnabled();
    }

    public boolean isEditable() {
        return this.combo.isEditable();
    }

    public void hidePopup() {
        this.combo.hidePopup();
    }

    public Object[] getSelectedObjects() {
        return this.combo.getSelectedObjects();
    }

    public Object getSelectedItem() {
        return this.combo.getSelectedItem();
    }

    public int getSelectedIndex() {
        return this.combo.getSelectedIndex();
    }

    public Object getPrototypeDisplayValue() {
        return this.combo.getPrototypeDisplayValue();
    }

    public PopupMenuListener[] getPopupMenuListeners() {
        return this.combo.getPopupMenuListeners();
    }

    public int getMaximumRowCount() {
        return this.combo.getMaximumRowCount();
    }

    public JComboBox.KeySelectionManager getKeySelectionManager() {
        return this.combo.getKeySelectionManager();
    }

    public ItemListener[] getItemListeners() {
        return this.combo.getItemListeners();
    }

    public int getItemCount() {
        return this.combo.getItemCount();
    }

    public Object getItemAt(int index) {
        return this.combo.getItemAt(index);
    }

    public void firePopupMenuWillBecomeVisible() {
        this.combo.firePopupMenuWillBecomeVisible();
    }

    public void firePopupMenuWillBecomeInvisible() {
        this.combo.firePopupMenuWillBecomeInvisible();
    }

    public void firePopupMenuCanceled() {
        this.combo.firePopupMenuCanceled();
    }

    public void configureEditor(ComboBoxEditor anEditor, Object anItem) {
        this.combo.configureEditor(anEditor, anItem);
    }

    public void addPopupMenuListener(PopupMenuListener l) {
        this.combo.addPopupMenuListener(l);
    }

    public void addItemListener(ItemListener aListener) {
        this.combo.addItemListener(aListener);
    }

    public void addActionListener(ActionListener l) {
        this.combo.addActionListener(l);
    }

    public void actionPerformed(ActionEvent e) {
        this.combo.actionPerformed(e);
    }

    public <T> void setModel(GrowingListModel<T> model) {
        this.combo.setModel(model);
    }

    public <T> GrowingListModel<T> getModel() {
        return (GrowingListModel)this.combo.getModel();
    }

    public void setNullSelectionMessage(String msg) {
        this.nullSelectionMessage = msg;
        this.getModel().fireDataChanged();
    }

    public String getNullSelectionMessage() {
        return this.nullSelectionMessage;
    }

    public Action getGrowAction() {
        return this.getModel().getGrowAction();
    }

    public void setGrowAction(Action growAction) {
        this.getModel().setGrowAction(growAction);
    }

    public static final class GrowingListModel<T>
    implements ComboBoxModel<Object> {
        private final Set<ListDataListener> listeners = new CopyOnWriteArraySet<ListDataListener>();
        private final List<T> predefinedList = new ArrayList<T>();
        private final List<T> userList = new ArrayList<T>();
        private T selected = null;
        private Action growAction = new AbstractAction("Browse..."){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };

        void setGrowAction(Action ga) {
            this.growAction = ga;
            this.fireDataChanged();
        }

        Action getGrowAction() {
            return this.growAction;
        }

        @Override
        public final Object getSelectedItem() {
            return this.selected;
        }

        @Override
        public final void setSelectedItem(final Object anItem) {
            if (anItem != null) {
                if (anItem.equals(GrowingComboBox.SEPARATOR)) {
                    return;
                }
                if (anItem instanceof Action) {
                    SwingUtilities.invokeLater(new Runnable(){
                        final /* synthetic */ GrowingListModel this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        public void run() {
                            ((Action)anItem).actionPerformed(new ActionEvent(this, 0, "grow"));
                        }
                    });
                } else {
                    this.selected = anItem;
                }
            }
        }

        @Override
        public final void addListDataListener(ListDataListener l) {
            this.listeners.add(l);
        }

        @Override
        public final Object getElementAt(int index) {
            int sep1 = this.getSep1Pos();
            int sep2 = this.getSep2Pos();
            if (index < sep1) {
                return this.predefinedList.get(index);
            }
            if (index == sep1) {
                return GrowingComboBox.SEPARATOR;
            }
            if (index < sep2) {
                return this.userList.get(index - sep1 - 1);
            }
            if (index == sep2) {
                return GrowingComboBox.SEPARATOR;
            }
            if (index == this.getActionPos()) {
                return this.growAction;
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public final int getSize() {
            return this.getActionPos() + 1;
        }

        @Override
        public final void removeListDataListener(ListDataListener l) {
            this.listeners.remove(l);
        }

        public final List<T> getPredefined() {
            return Collections.unmodifiableList(this.predefinedList);
        }

        public final List<T> getUserDefined() {
            return Collections.unmodifiableList(this.userList);
        }

        public final void setPredefined(List<T> predefined) {
            int stop = this.getSep1Pos();
            this.predefinedList.clear();
            if (stop > 0) {
                this.fireDataRemoved(0, stop);
            }
            this.predefinedList.addAll(predefined);
            stop = this.getSep1Pos();
            if (this.selected == null && !this.predefinedList.isEmpty()) {
                this.selected = this.predefinedList.get(0);
            }
            this.fireDataAdded(0, stop > 0 ? stop : 0);
        }

        public final void setUserDefined(List<T> user) {
            int stop = this.getSep2Pos();
            this.userList.clear();
            if (stop > 0) {
                this.fireDataRemoved(this.getUserListStartPos(), stop);
            }
            this.userList.addAll(user);
            stop = this.getSep2Pos();
            if (this.selected == null && !this.userList.isEmpty()) {
                this.selected = this.userList.get(0);
            }
            this.fireDataAdded(this.getUserListStartPos(), stop);
        }

        public final void addPredefined(T ... predefined) {
            int stop1 = this.getSep1Pos();
            this.predefinedList.addAll(Arrays.asList(predefined));
            int stop2 = this.getSep1Pos();
            if (this.selected == null && !this.predefinedList.isEmpty()) {
                this.selected = this.predefinedList.get(0);
            }
            this.fireDataAdded(stop1 > -1 ? stop1 : 0, stop2);
        }

        public final void addUserDefined(T ... userdefined) {
            int stop1 = this.getSep2Pos();
            this.userList.addAll(Arrays.asList(userdefined));
            int stop2 = this.getSep2Pos();
            if (this.selected == null && !this.userList.isEmpty()) {
                this.selected = this.userList.get(0);
            }
            this.fireDataAdded(stop1 > -1 ? stop1 : 0, stop2);
        }

        private void fireDataAdded(int start, int stop) {
            if (stop <= start) {
                return;
            }
            for (ListDataListener l : this.listeners) {
                l.intervalAdded(new ListDataEvent(this, 1, start, stop));
            }
        }

        private void fireDataRemoved(int start, int stop) {
            for (ListDataListener l : this.listeners) {
                l.intervalRemoved(new ListDataEvent(this, 2, start, stop));
            }
        }

        private void fireDataChanged() {
            int stop = this.getSize() - 1;
            for (ListDataListener l : this.listeners) {
                l.contentsChanged(new ListDataEvent(this, 0, 0, stop));
            }
        }

        private int getUserListStartPos() {
            return this.getSep1Pos() + 1;
        }

        private int getActionPos() {
            return this.getSep2Pos() + 1;
        }

        private int getSep1Pos() {
            if (this.predefinedList.isEmpty()) {
                return -1;
            }
            return this.predefinedList.size();
        }

        private int getSep2Pos() {
            if (this.predefinedList.isEmpty() && this.userList.isEmpty()) {
                return -1;
            }
            if (this.predefinedList.isEmpty()) {
                return this.userList.size();
            }
            if (this.userList.isEmpty()) {
                return this.predefinedList.size();
            }
            return this.predefinedList.size() + this.userList.size() + 1;
        }
    }
}

