/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.build;

import java.awt.EventQueue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.web.clientproject.api.build.BuildTools;
import org.netbeans.modules.web.clientproject.build.AdvancedTask;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Parameters;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class AdvancedTasksStorage {
    private static final Logger LOGGER = Logger.getLogger(AdvancedTasksStorage.class.getName());
    private static final String NAMESPACE_URI = "http://www.netbeans.org/ns/build-tool-tasks/1";
    private static final String ELEMENT_TASKS = "%s-tasks";
    private static final String ELEMENT_WORKDIR = "workdir";
    private static final String ATTR_WORKDIR_PATH = "path";
    private static final String ATTR_WORKDIR_SHOW_SIMPLE_TASKS = "showSimpleTasks";
    private static final String ELEMENT_TASK = "task";
    private static final String ATTR_TASK_NAME = "name";
    private static final String ATTR_TASK_OPTIONS = "options";
    private static final String ATTR_TASK_TASKS = "tasks";
    private static final String ATTR_TASK_PARAMETERS = "parameters";
    private static final String ATTR_TASK_INDEX = "index";
    private final Project project;
    private final String ident;
    private final String workDir;

    private AdvancedTasksStorage(Project project, String ident, String workDir) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        Parameters.notEmpty((CharSequence)"ident", (CharSequence)ident);
        Parameters.notNull((CharSequence)"workDir", (Object)workDir);
        this.project = project;
        this.ident = ident.toLowerCase().replace(' ', '-');
        this.workDir = workDir;
    }

    public static AdvancedTasksStorage forBuildToolSupport(BuildTools.BuildToolSupport support) {
        Parameters.notNull((CharSequence)"support", (Object)support);
        FileObject workDir = support.getWorkDir();
        String relativePath = FileUtil.getRelativePath((FileObject)support.getProject().getProjectDirectory(), (FileObject)workDir);
        String workDirPath = relativePath != null ? relativePath : FileUtil.getFileDisplayName((FileObject)workDir);
        return new AdvancedTasksStorage(support.getProject(), support.getIdentifier(), workDirPath);
    }

    public Data loadTasks() {
        assert (!EventQueue.isDispatchThread());
        TreeMap<Integer, AdvancedTask> tasks = new TreeMap<Integer, AdvancedTask>();
        AtomicBoolean showSimpleTasks = new AtomicBoolean(true);
        AuxiliaryConfiguration config = ProjectUtils.getAuxiliaryConfiguration((Project)this.project);
        this.loadTasks(config, true, tasks, showSimpleTasks);
        boolean sharedShowSimpleTasks = showSimpleTasks.get();
        this.loadTasks(config, false, tasks, showSimpleTasks);
        boolean privateShowSimpleTasks = showSimpleTasks.get();
        assert (sharedShowSimpleTasks == privateShowSimpleTasks) : sharedShowSimpleTasks + " != " + privateShowSimpleTasks;
        return new Data().setTasks(new ArrayList<AdvancedTask>(tasks.values())).setShowSimpleTasks(showSimpleTasks.get());
    }

    public void storeTasks(Data data) throws IOException {
        assert (!EventQueue.isDispatchThread());
        assert (data != null);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        AuxiliaryConfiguration config = ProjectUtils.getAuxiliaryConfiguration((Project)this.project);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.storeTasks(data, config, true, builder);
            this.storeTasks(data, config, false, builder);
            ProjectManager.getDefault().saveProject(this.project);
        }
        catch (ParserConfigurationException pcex) {
            LOGGER.log(Level.SEVERE, "Unable to store tasks!", pcex);
        }
    }

    private void loadTasks(AuxiliaryConfiguration config, boolean shared, Map<Integer, AdvancedTask> tasks, AtomicBoolean showSimpleTasks) {
        Element tasksElement = config.getConfigurationFragment(this.getTasksElement(), NAMESPACE_URI, shared);
        if (tasksElement == null) {
            return;
        }
        NodeList workDirList = tasksElement.getElementsByTagName(ELEMENT_WORKDIR);
        for (int i = 0; i < workDirList.getLength(); ++i) {
            Element workDirElement = (Element)workDirList.item(i);
            if (!this.workDir.equals(workDirElement.getAttribute(ATTR_WORKDIR_PATH))) continue;
            showSimpleTasks.set(Boolean.parseBoolean(workDirElement.getAttribute(ATTR_WORKDIR_SHOW_SIMPLE_TASKS)));
            NodeList taskList = workDirElement.getElementsByTagName(ELEMENT_TASK);
            for (int j = 0; j < taskList.getLength(); ++j) {
                Element taskElement = (Element)taskList.item(j);
                AdvancedTask original = tasks.put(Integer.parseInt(taskElement.getAttribute(ATTR_TASK_INDEX)), new AdvancedTask().setName(taskElement.getAttribute(ATTR_TASK_NAME)).setOptions(taskElement.getAttribute(ATTR_TASK_OPTIONS)).setTasks(taskElement.getAttribute(ATTR_TASK_TASKS)).setParameters(taskElement.getAttribute(ATTR_TASK_PARAMETERS)).setShared(shared));
                assert (original == null) : "Task already exists: " + original;
            }
            break;
        }
    }

    private void storeTasks(Data data, AuxiliaryConfiguration config, boolean shared, DocumentBuilder builder) {
        Element tasksElement = config.getConfigurationFragment(this.getTasksElement(), NAMESPACE_URI, shared);
        if (tasksElement == null) {
            this.insertTasks(data, config, shared, builder);
            return;
        }
        NodeList workDirList = tasksElement.getElementsByTagName(ELEMENT_WORKDIR);
        Element existingWorkDirElement = null;
        for (int i = 0; i < workDirList.getLength(); ++i) {
            Element workDirElement = (Element)workDirList.item(i);
            if (!this.workDir.equals(workDirElement.getAttribute(ATTR_WORKDIR_PATH))) continue;
            existingWorkDirElement = workDirElement;
            break;
        }
        if (existingWorkDirElement != null) {
            tasksElement.removeChild(existingWorkDirElement);
        }
        this.insertWorkDir(data, config, shared, builder, tasksElement.getOwnerDocument(), tasksElement);
    }

    private void insertTasks(Data data, AuxiliaryConfiguration config, boolean shared, DocumentBuilder builder) {
        Document document = builder.newDocument();
        Element tasksElement = document.createElementNS(NAMESPACE_URI, this.getTasksElement());
        this.insertWorkDir(data, config, shared, builder, document, tasksElement);
    }

    private void insertWorkDir(Data data, AuxiliaryConfiguration config, boolean shared, DocumentBuilder builder, Document document, Element tasksElement) {
        Element workDirElement = document.createElementNS(NAMESPACE_URI, ELEMENT_WORKDIR);
        workDirElement.setAttribute(ATTR_WORKDIR_PATH, this.workDir);
        workDirElement.setAttribute(ATTR_WORKDIR_SHOW_SIMPLE_TASKS, Boolean.toString(data.isShowSimpleTasks()));
        tasksElement.appendChild(workDirElement);
        List<AdvancedTask> tasks = data.getTasks();
        for (int i = 0; i < tasks.size(); ++i) {
            AdvancedTask task = tasks.get(i);
            if (task.isShared() != shared) continue;
            Element taskElement = document.createElementNS(NAMESPACE_URI, ELEMENT_TASK);
            taskElement.setAttribute(ATTR_TASK_NAME, task.getName());
            taskElement.setAttribute(ATTR_TASK_OPTIONS, task.getOptions());
            taskElement.setAttribute(ATTR_TASK_TASKS, task.getTasks());
            taskElement.setAttribute(ATTR_TASK_PARAMETERS, task.getParameters());
            taskElement.setAttribute(ATTR_TASK_INDEX, String.valueOf(i));
            workDirElement.appendChild(taskElement);
        }
        config.putConfigurationFragment(tasksElement, shared);
    }

    private String getTasksElement() {
        return String.format(ELEMENT_TASKS, this.ident);
    }

    public static final class Data {
        private List<AdvancedTask> tasks;
        private boolean showSimpleTasks;

        public List<AdvancedTask> getTasks() {
            return Collections.unmodifiableList(this.tasks);
        }

        public Data setTasks(List<AdvancedTask> tasks) {
            assert (tasks != null);
            this.tasks = tasks;
            return this;
        }

        public boolean isShowSimpleTasks() {
            return this.showSimpleTasks;
        }

        public Data setShowSimpleTasks(boolean showSimpleTasks) {
            this.showSimpleTasks = showSimpleTasks;
            return this;
        }

        public String toString() {
            return "Data{tasks=" + this.tasks + ", showSimpleTasks=" + this.showSimpleTasks + '}';
        }
    }
}

