/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.symfony;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.base.input.InputProcessor;
import org.netbeans.api.extexecution.base.input.InputProcessors;
import org.netbeans.api.extexecution.base.input.LineProcessor;
import org.netbeans.modules.php.api.executable.InvalidPhpExecutableException;
import org.netbeans.modules.php.api.executable.PhpExecutable;
import org.netbeans.modules.php.api.executable.PhpExecutableValidator;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.api.util.UiUtils;
import org.netbeans.modules.php.spi.framework.commands.FrameworkCommand;
import org.netbeans.modules.php.symfony.Bundle;
import org.netbeans.modules.php.symfony.SymfonyPhpFrameworkProvider;
import org.netbeans.modules.php.symfony.commands.SymfonyCommand;
import org.netbeans.modules.php.symfony.commands.SymfonyCommandVO;
import org.netbeans.modules.php.symfony.commands.SymfonyCommandsXmlParser;
import org.netbeans.modules.php.symfony.ui.options.SymfonyOptions;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.windows.InputOutput;

public class SymfonyScript {
    private static final Logger LOGGER = Logger.getLogger(SymfonyScript.class.getName());
    public static final String SCRIPT_NAME = "symfony";
    public static final String SCRIPT_NAME_LONG = "symfony" + FileUtils.getScriptExtension((boolean)true);
    private static final String XML_CHARSET_NAME = "UTF-8";
    public static final String OPTIONS_ID = "Symfony";
    public static final String OPTIONS_SUB_PATH = "FrameworksAndTools/Symfony";
    private static final String DEFAULT_PARAM = "--color";
    private static final String INIT_PROJECT_COMMAND = "generate:project";
    private static final String CLEAR_CACHE_COMMAND = "cache:clear";
    private static final String INIT_APP_COMMAND = "generate:app";
    private static final String HELP_COMMAND = "help";
    private static final String LIST_COMMAND = "list";
    private static final List<String> LIST_XML_COMMAND = Arrays.asList("list", "--xml");
    private final String symfonyPath;

    private SymfonyScript(String symfonyPath) {
        this.symfonyPath = symfonyPath;
    }

    public static SymfonyScript getDefault() throws InvalidPhpExecutableException {
        String symfony = SymfonyOptions.getInstance().getSymfony();
        String error = SymfonyScript.validate(symfony);
        if (error != null) {
            throw new InvalidPhpExecutableException(error);
        }
        return new SymfonyScript(symfony);
    }

    public static SymfonyScript forPhpModule(PhpModule phpModule, boolean warn) throws InvalidPhpExecutableException {
        String symfony = new File(FileUtil.toFile((FileObject)phpModule.getSourceDirectory()), SCRIPT_NAME).getAbsolutePath();
        String error = SymfonyScript.validate(symfony);
        if (error != null) {
            if (warn) {
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(SymfonyScript.class, (String)"MSG_InvalidProjectSymfonyScript", (Object)error), 2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            }
            return SymfonyScript.getDefault();
        }
        return new SymfonyScript(symfony);
    }

    public static String validate(String command) {
        return PhpExecutableValidator.validateCommand((String)command, (String)Bundle.SymfonyScript_script_label());
    }

    public static String getOptionsPath() {
        return "org-netbeans-modules-php-project-ui-options-PHPOptionsCategory/FrameworksAndTools/" + SymfonyScript.getOptionsSubPath();
    }

    public static String getOptionsSubPath() {
        return OPTIONS_SUB_PATH;
    }

    public void runCommand(PhpModule phpModule, List<String> parameters, Runnable postExecution) {
        this.createPhpExecutable(phpModule).displayName(this.getDisplayName(phpModule)).additionalParameters(this.getAllParams(parameters)).run(this.getDescriptor(postExecution));
    }

    public void clearCache(PhpModule phpModule) {
        this.runCommand(phpModule, Collections.singletonList(CLEAR_CACHE_COMMAND), null);
    }

    public boolean initProject(PhpModule phpModule, String[] params) {
        String projectName = phpModule.getDisplayName();
        ArrayList<String> allParams = new ArrayList<String>();
        allParams.add(INIT_PROJECT_COMMAND);
        allParams.add(projectName);
        allParams.addAll(Arrays.asList(params));
        try {
            Future result = this.createPhpExecutable(phpModule).displayName(this.getDisplayName(phpModule)).additionalParameters(this.getAllParams(allParams)).warnUser(false).run(this.getDescriptor(null));
            if (result != null) {
                result.get();
            }
        }
        catch (CancellationException | ExecutionException result) {
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        return SymfonyPhpFrameworkProvider.getInstance().isInPhpModule(phpModule);
    }

    public void initApp(PhpModule phpModule, String app, String[] params) {
        assert (StringUtils.hasText((String)app));
        assert (params != null);
        ArrayList<String> allParams = new ArrayList<String>();
        allParams.add(INIT_APP_COMMAND);
        allParams.add(app);
        allParams.addAll(Arrays.asList(params));
        this.createPhpExecutable(phpModule).displayName(this.getDisplayName(phpModule)).additionalParameters(this.getAllParams(allParams)).warnUser(false).run(this.getDescriptor(null));
    }

    public String getHelp(PhpModule phpModule, String[] params) {
        assert (phpModule != null);
        ArrayList<String> allParams = new ArrayList<String>();
        allParams.add(HELP_COMMAND);
        allParams.addAll(Arrays.asList(params));
        HelpLineProcessor lineProcessor = new HelpLineProcessor();
        Future result = this.createPhpExecutable(phpModule).displayName(this.getDisplayName(phpModule)).additionalParameters(this.getAllParams(allParams)).run(this.getSilentDescriptor(), this.getOutProcessorFactory(lineProcessor));
        try {
            if (result != null) {
                result.get();
            }
        }
        catch (CancellationException cancellationException) {
        }
        catch (ExecutionException ex) {
            UiUtils.processExecutionException((ExecutionException)ex, (String)SymfonyScript.getOptionsSubPath());
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        return lineProcessor.getHelp();
    }

    public List<FrameworkCommand> getCommands(PhpModule phpModule) {
        List<FrameworkCommand> freshCommands = this.getFrameworkCommandsInternalXml(phpModule);
        if (freshCommands != null) {
            return freshCommands;
        }
        freshCommands = this.getFrameworkCommandsInternalConsole(phpModule);
        if (freshCommands != null) {
            return freshCommands;
        }
        this.runCommand(phpModule, Collections.singletonList(LIST_COMMAND), null);
        return null;
    }

    private PhpExecutable createPhpExecutable(PhpModule phpModule) {
        return new PhpExecutable(this.symfonyPath).workDir(FileUtil.toFile((FileObject)phpModule.getSourceDirectory()));
    }

    private List<String> getAllParams(List<String> params) {
        ArrayList<String> allParams = new ArrayList<String>();
        allParams.add(DEFAULT_PARAM);
        allParams.addAll(params);
        return allParams;
    }

    private String getDisplayName(PhpModule phpModule) {
        return Bundle.SymfonyScript_command_title(phpModule.getDisplayName());
    }

    private ExecutionDescriptor getDescriptor(Runnable postExecution) {
        ExecutionDescriptor executionDescriptor = PhpExecutable.DEFAULT_EXECUTION_DESCRIPTOR.optionsPath(OPTIONS_SUB_PATH);
        if (postExecution != null) {
            executionDescriptor = executionDescriptor.postExecution(postExecution);
        }
        return executionDescriptor;
    }

    private ExecutionDescriptor.InputProcessorFactory2 getOutProcessorFactory(final LineProcessor lineProcessor) {
        return new ExecutionDescriptor.InputProcessorFactory2(){
            final /* synthetic */ SymfonyScript this$0;
            {
                this.this$0 = this$0;
            }

            public InputProcessor newInputProcessor(InputProcessor defaultProcessor) {
                return InputProcessors.ansiStripping((InputProcessor)InputProcessors.bridge((LineProcessor)lineProcessor));
            }
        };
    }

    private ExecutionDescriptor getSilentDescriptor() {
        return new ExecutionDescriptor().inputOutput(InputOutput.NULL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<FrameworkCommand> getFrameworkCommandsInternalXml(PhpModule phpModule) {
        File tmpFile;
        try {
            tmpFile = Files.createTempFile("nb-symfony-commands-", ".xml", new FileAttribute[0]).toFile();
            tmpFile.deleteOnExit();
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, null, ex);
            return null;
        }
        Future result = this.createPhpExecutable(phpModule).fileOutput(tmpFile, XML_CHARSET_NAME, true).warnUser(false).additionalParameters(LIST_XML_COMMAND).run(this.getSilentDescriptor());
        try {
            if (result == null || (Integer)result.get() != 0) {
                return null;
            }
        }
        catch (CancellationException | ExecutionException ex) {
            return null;
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            return null;
        }
        ArrayList<SymfonyCommandVO> commandsVO = new ArrayList<SymfonyCommandVO>();
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(tmpFile), XML_CHARSET_NAME));
            SymfonyCommandsXmlParser.parse(reader, commandsVO);
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, null, ex);
        }
        finally {
            if (!tmpFile.delete()) {
                LOGGER.info("Cannot delete temporary file");
            }
        }
        if (commandsVO.isEmpty()) {
            return null;
        }
        ArrayList<FrameworkCommand> commands = new ArrayList<FrameworkCommand>(commandsVO.size());
        for (SymfonyCommandVO command : commandsVO) {
            commands.add(new SymfonyCommand(phpModule, command.getCommand(), command.getDescription(), command.getCommand()));
        }
        return commands;
    }

    private List<FrameworkCommand> getFrameworkCommandsInternalConsole(PhpModule phpModule) {
        CommandsLineProcessor lineProcessor = new CommandsLineProcessor(phpModule);
        Future task = this.createPhpExecutable(phpModule).workDir(FileUtil.toFile((FileObject)phpModule.getSourceDirectory())).additionalParameters(Collections.singletonList(LIST_COMMAND)).run(this.getSilentDescriptor(), this.getOutProcessorFactory(lineProcessor));
        try {
            List<FrameworkCommand> freshCommands;
            if (task != null && (Integer)task.get() == 0 && !(freshCommands = lineProcessor.getCommands()).isEmpty()) {
                return freshCommands;
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException ex) {
            LOGGER.log(Level.INFO, null, ex);
        }
        return null;
    }

    static final class HelpLineProcessor
    implements LineProcessor {
        private final StringBuilder buffer = new StringBuilder(500);

        HelpLineProcessor() {
        }

        public void processLine(String line) {
            this.buffer.append(line);
            this.buffer.append("\n");
        }

        public void reset() {
        }

        public void close() {
        }

        public String getHelp() {
            return this.buffer.toString().trim() + "\n";
        }
    }

    static final class CommandsLineProcessor
    implements LineProcessor {
        private static final Pattern COMMAND_PATTERN = Pattern.compile("^\\:(\\S+)\\s+(.+)$");
        private static final Pattern PREFIX_PATTERN = Pattern.compile("^(\\w+)$");
        private final List<FrameworkCommand> commands = new ArrayList<FrameworkCommand>();
        private final PhpModule phpModule;
        private String prefix;

        public CommandsLineProcessor(PhpModule phpModule) {
            this.phpModule = phpModule;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processLine(String line) {
            Matcher commandMatcher;
            if (!StringUtils.hasText((String)line)) {
                this.prefix = null;
                return;
            }
            String trimmed = line.trim();
            Matcher prefixMatcher = PREFIX_PATTERN.matcher(trimmed);
            if (prefixMatcher.matches()) {
                this.prefix = prefixMatcher.group(1);
            }
            if ((commandMatcher = COMMAND_PATTERN.matcher(trimmed)).matches()) {
                String command = commandMatcher.group(1);
                if (this.prefix != null) {
                    command = this.prefix + ":" + command;
                }
                String description = commandMatcher.group(2);
                List<FrameworkCommand> list = this.commands;
                synchronized (list) {
                    this.commands.add(new SymfonyCommand(this.phpModule, command, description, command));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<FrameworkCommand> getCommands() {
            ArrayList<FrameworkCommand> copy;
            List<FrameworkCommand> list = this.commands;
            synchronized (list) {
                copy = new ArrayList<FrameworkCommand>(this.commands);
            }
            return copy;
        }

        public void close() {
        }

        public void reset() {
        }
    }
}

