/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections.spi;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.keyring.Keyring;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.project.connections.ConfigManager;
import org.netbeans.modules.php.project.util.PhpProjectUtils;
import org.openide.util.NbBundle;

public abstract class RemoteConfiguration {
    protected static final Logger LOGGER = Logger.getLogger(RemoteConfiguration.class.getName());
    protected final ConfigManager.Configuration cfg;
    private final String displayName;
    private final String name;
    final String deprecatedPasswordKey;
    final String passwordKey;

    public RemoteConfiguration(ConfigManager.Configuration cfg) {
        if (cfg == null) {
            throw new NullPointerException("Configuration cannot be null");
        }
        this.cfg = cfg;
        this.name = cfg.getName();
        this.displayName = cfg.getDisplayName();
        this.deprecatedPasswordKey = this.getClass().getName() + "." + this.name + ".password";
        this.passwordKey = "php.remote." + this.name + ".password";
    }

    RemoteConfiguration(String name, String displayName) {
        assert (name != null);
        assert (displayName != null);
        this.name = name;
        this.displayName = displayName;
        this.cfg = null;
        this.deprecatedPasswordKey = null;
        this.passwordKey = null;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.getUrl("");
    }

    public abstract String getUrl(String var1);

    public abstract String getInitialDirectory();

    public boolean saveProperty(String key, String value) {
        return false;
    }

    public void notifyDeleted() {
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RemoteConfiguration other = (RemoteConfiguration)obj;
        return this.name == other.name || this.name != null && this.name.equals(other.name);
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + (this.name != null ? this.name.hashCode() : 0);
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(200);
        sb.append(this.getClass().getName());
        sb.append(" [displayName: ");
        sb.append(this.displayName);
        sb.append(", name: ");
        sb.append(this.name);
        sb.append("]");
        return sb.toString();
    }

    protected int readNumber(String key, int defaultValue) {
        String currentValue = this.cfg.getValue(key);
        if (StringUtils.hasText((String)currentValue)) {
            try {
                return Integer.parseInt(currentValue);
            }
            catch (NumberFormatException nfe) {
                LOGGER.log(Level.INFO, "Exception while parsing number of '" + key + "'", nfe);
            }
        }
        this.cfg.putValue(key, String.valueOf(defaultValue));
        return defaultValue;
    }

    protected boolean readBoolean(String key, boolean defaultValue) {
        String value = this.cfg.getValue(key);
        if (value != null) {
            return Boolean.valueOf(value);
        }
        this.cfg.putValue(key, String.valueOf(defaultValue));
        return defaultValue;
    }

    protected <T extends Enum<T>> T readEnum(Class<T> enumClass, String key, T defaultValue) {
        T value = PhpProjectUtils.resolveEnum(enumClass, this.cfg.getValue(key), defaultValue);
        this.cfg.putValue(key, ((Enum)value).name());
        return value;
    }

    protected String readPassword(String key) {
        if (this.cfg == null) {
            throw new IllegalStateException("Cannot read password, no configuration provided");
        }
        String oldPassword = this.cfg.getValue(key, true);
        if (oldPassword != null) {
            return oldPassword;
        }
        String password = this.readPasswordFromKeyring();
        if (password != null) {
            this.cfg.putValue(key, password, true);
        }
        return password;
    }

    private String readPasswordFromKeyring() {
        char[] newPassword = Keyring.read((String)this.passwordKey);
        if (newPassword != null) {
            return new String(newPassword);
        }
        newPassword = Keyring.read((String)this.deprecatedPasswordKey);
        if (newPassword != null) {
            return new String(newPassword);
        }
        return null;
    }

    protected void savePassword(String password, String type) {
        if (password == null) {
            return;
        }
        if (StringUtils.hasText((String)password)) {
            Keyring.save((String)this.passwordKey, (char[])password.toCharArray(), (String)NbBundle.getMessage(RemoteConfiguration.class, (String)"MSG_PasswordFor", (Object)this.getDisplayName(), (Object)type));
            Keyring.delete((String)this.deprecatedPasswordKey);
        } else {
            this.deletePassword();
        }
    }

    protected void deletePassword() {
        Keyring.delete((String)this.passwordKey);
        Keyring.delete((String)this.deprecatedPasswordKey);
    }

    public static final class Empty
    extends RemoteConfiguration {
        public Empty(String name, String displayName) {
            super(name, displayName);
        }

        @Override
        public String getUrl(String directory) {
            return "";
        }

        @Override
        public String getInitialDirectory() {
            return "/";
        }
    }
}

