/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.options;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.netbeans.core.windows.options.LafOptionsPanelController;
import org.openide.LifecycleManager;
import org.openide.awt.Mnemonics;
import org.openide.awt.Notification;
import org.openide.awt.NotificationDisplayer;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.windows.WindowManager;

public class LafPanel
extends JPanel {
    protected final LafOptionsPanelController controller;
    private final Preferences prefs = NbPreferences.forModule(LafPanel.class);
    private static final boolean NO_RESTART_ON_LAF_CHANGE = Boolean.getBoolean("nb.laf.norestart");
    private int defaultLookAndFeelIndex;
    private final List<UIManager.LookAndFeelInfo> lafs = new ArrayList<UIManager.LookAndFeelInfo>();
    private JCheckBox checkMaximizeNativeLaF;
    private JComboBox comboLaf;
    private JLabel lblRestart;
    private JPanel panelLaFCombo;
    private JCheckBox showAllLafs;
    private static Notification restartNotification;
    private static final String COLOR_MODEL_CLASS_NAME = "org.netbeans.modules.options.colors.ColorModel";

    protected LafPanel(LafOptionsPanelController controller) {
        this.controller = controller;
        this.initComponents();
        this.checkMaximizeNativeLaF.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                LafPanel.this.fireChanged();
            }
        });
        this.initLookAndFeels();
        this.lblRestart.setVisible(!NO_RESTART_ON_LAF_CHANGE);
        this.comboLaf.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                LafPanel.this.fireChanged();
            }
        });
    }

    private void fireChanged() {
        boolean isChanged = false;
        if (this.checkMaximizeNativeLaF.isSelected() != this.prefs.getBoolean("laf.maximize.native", false) || this.comboLaf.getSelectedIndex() != this.lafs.indexOf(this.isForcedLaF() ? this.getCurrentLaF() : this.getPreferredLaF())) {
            isChanged = true;
        }
        this.controller.changed(isChanged);
    }

    private void initComponents() {
        this.panelLaFCombo = new JPanel();
        this.checkMaximizeNativeLaF = new JCheckBox();
        this.lblRestart = new JLabel();
        this.comboLaf = new JComboBox();
        JLabel lblLaf = new JLabel();
        this.showAllLafs = new JCheckBox();
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.panelLaFCombo.setLayout(new BorderLayout(3, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.checkMaximizeNativeLaF, (String)NbBundle.getMessage(LafPanel.class, (String)"LafPanel.checkMaximizeNativeLaF.text"));
        this.checkMaximizeNativeLaF.setToolTipText(NbBundle.getMessage(LafPanel.class, (String)"LafPanel.checkMaximizeNativeLaF.toolTipText"));
        Mnemonics.setLocalizedText((JLabel)this.lblRestart, (String)NbBundle.getMessage(LafPanel.class, (String)"LafPanel.lblRestart.text"));
        lblLaf.setLabelFor(this.comboLaf);
        Mnemonics.setLocalizedText((JLabel)lblLaf, (String)NbBundle.getMessage(LafPanel.class, (String)"LafPanel.lblLaf.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.showAllLafs, (String)NbBundle.getMessage(LafPanel.class, (String)"LafPanel.showAllLafs.text"));
        this.showAllLafs.setToolTipText(NbBundle.getMessage(LafPanel.class, (String)"LafPanel.showAllLafs.toolTipText"));
        this.showAllLafs.addActionListener(this::showAllLafsActionPerformed);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.panelLaFCombo, -2, -1, -2).addGroup(layout.createSequentialGroup().addComponent(lblLaf).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboLaf, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblRestart)).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.showAllLafs).addComponent(this.checkMaximizeNativeLaF)))).addContainerGap(36, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.panelLaFCombo, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lblLaf).addComponent(this.comboLaf, -2, -1, -2).addComponent(this.lblRestart, -2, 23, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.showAllLafs).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkMaximizeNativeLaF).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void showAllLafsActionPerformed(ActionEvent evt) {
        this.initLookAndFeels();
        this.load();
    }

    protected void load() {
        this.checkMaximizeNativeLaF.setSelected(this.prefs.getBoolean("laf.maximize.native", false));
        boolean isForcedLaF = this.isForcedLaF();
        this.defaultLookAndFeelIndex = this.lafs.indexOf(isForcedLaF ? this.getCurrentLaF() : this.getPreferredLaF());
        this.comboLaf.setSelectedIndex(this.defaultLookAndFeelIndex);
        this.comboLaf.setEnabled(!isForcedLaF);
        if (isForcedLaF) {
            this.showAllLafs.setVisible(false);
        }
    }

    protected boolean store() {
        this.prefs.putBoolean("laf.maximize.native", this.checkMaximizeNativeLaF.isSelected());
        System.setProperty("nb.native.filechooser", this.checkMaximizeNativeLaF.isSelected() ? "true" : "false");
        int selLaFIndex = this.comboLaf.getSelectedIndex();
        if (selLaFIndex != this.defaultLookAndFeelIndex && !this.isForcedLaF()) {
            UIManager.LookAndFeelInfo li = this.lafs.get(this.comboLaf.getSelectedIndex());
            NbPreferences.root().node("laf").put("laf", li.getClassName());
            if (NO_RESTART_ON_LAF_CHANGE) {
                try {
                    UIManager.setLookAndFeel(li.getClassName());
                    WindowManager wmgr = (WindowManager)Lookup.getDefault().lookup(WindowManager.class);
                    wmgr.updateUI();
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
                    this.askForRestart();
                }
            } else {
                this.askForRestart();
            }
        }
        return false;
    }

    boolean valid() {
        return true;
    }

    private void initLookAndFeels() {
        this.lafs.clear();
        String lafExcludes = NbBundle.getMessage(LafPanel.class, (String)"LafPanel.excludes").trim();
        if (lafExcludes.isEmpty()) {
            this.showAllLafs.setVisible(false);
        } else {
            boolean showAllLafsOption = Boolean.parseBoolean(NbBundle.getMessage(LafPanel.class, (String)"LafPanel.showAllLafs.visible"));
            this.showAllLafs.setVisible(showAllLafsOption);
        }
        if (lafExcludes.isEmpty() || this.showAllLafs.isSelected()) {
            this.lafs.addAll(Arrays.asList(UIManager.getInstalledLookAndFeels()));
        } else {
            String cur = this.getCurrentLaF().getClassName();
            String pref = this.getPreferredLaF().getClassName();
            for (UIManager.LookAndFeelInfo li : UIManager.getInstalledLookAndFeels()) {
                String cls = li.getClassName();
                String name = cls.substring(cls.lastIndexOf(46) + 1, cls.length());
                if (!cls.equals(cur) && !cls.equals(pref) && lafExcludes.contains(name)) continue;
                this.lafs.add(li);
            }
        }
        Object lastSelection = this.comboLaf.getSelectedItem();
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        for (UIManager.LookAndFeelInfo info : this.lafs) {
            model.addElement(info.getName());
        }
        this.comboLaf.setModel(model);
        if (lastSelection != null) {
            this.comboLaf.setSelectedItem(lastSelection);
        }
    }

    private boolean isForcedLaF() {
        return null != System.getProperty("nb.laf.forced");
    }

    private UIManager.LookAndFeelInfo getCurrentLaF() {
        UIManager.LookAndFeelInfo currentLaf = null;
        LookAndFeel laf = UIManager.getLookAndFeel();
        String currentLAFClassName = laf.getClass().getName();
        boolean isAqua = "Aqua".equals(laf.getID());
        for (UIManager.LookAndFeelInfo li : UIManager.getInstalledLookAndFeels()) {
            if (!currentLAFClassName.equals(li.getClassName()) && (!isAqua || !li.getClassName().contains("com.apple.laf.AquaLookAndFeel"))) continue;
            currentLaf = li;
            break;
        }
        return currentLaf == null ? new UIManager.LookAndFeelInfo(laf.getName(), currentLAFClassName) : currentLaf;
    }

    private UIManager.LookAndFeelInfo getPreferredLaF() {
        String lafClassName = NbPreferences.root().node("laf").get("laf", null);
        if (null == lafClassName) {
            return this.getCurrentLaF();
        }
        UIManager.LookAndFeelInfo prefLaf = null;
        boolean isAqua = "Aqua".equals(UIManager.getLookAndFeel().getID());
        for (UIManager.LookAndFeelInfo li : UIManager.getInstalledLookAndFeels()) {
            if (!lafClassName.equals(li.getClassName()) && (!isAqua || !li.getClassName().contains("com.apple.laf.AquaLookAndFeel"))) continue;
            prefLaf = li;
            break;
        }
        return prefLaf == null ? this.getCurrentLaF() : prefLaf;
    }

    private void askForRestart() {
        if (null != restartNotification) {
            restartNotification.clear();
        }
        restartNotification = NotificationDisplayer.getDefault().notify(NbBundle.getMessage(LafPanel.class, (String)"Hint_RESTART_IDE"), (Icon)ImageUtilities.loadImageIcon((String)"org/netbeans/core/windows/resources/restart.png", (boolean)true), this.createRestartNotificationDetails(), this.createRestartNotificationDetails(), NotificationDisplayer.Priority.HIGH, NotificationDisplayer.Category.INFO);
    }

    void selectDarkLookAndFeel() {
        this.comboLaf.requestFocusInWindow();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LafPanel.this.comboLaf.setPopupVisible(true);
            }
        });
    }

    private boolean isChangeEditorColorsPossible() {
        String preferredProfile = this.getPreferredColorProfile();
        if (preferredProfile == null) {
            return false;
        }
        ClassLoader cl = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        if (null == cl) {
            cl = LafPanel.class.getClassLoader();
        }
        try {
            Class<?> klz = cl.loadClass(COLOR_MODEL_CLASS_NAME);
            Object colorModel = klz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Method m = klz.getDeclaredMethod("getCurrentProfile", new Class[0]);
            Object res = m.invoke(colorModel, new Object[0]);
            return res != null && !preferredProfile.equals(res);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void switchEditorColorsProfile() {
        if (!this.isChangeEditorColorsPossible()) {
            return;
        }
        String preferredProfile = this.getPreferredColorProfile();
        ClassLoader cl = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        if (null == cl) {
            cl = LafPanel.class.getClassLoader();
        }
        try {
            Class<?> klz = cl.loadClass(COLOR_MODEL_CLASS_NAME);
            Object colorModel = klz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Method m = klz.getDeclaredMethod("getAnnotations", String.class);
            Object annotations = m.invoke(colorModel, preferredProfile);
            m = klz.getDeclaredMethod("setAnnotations", String.class, Collection.class);
            m.invoke(colorModel, preferredProfile, annotations);
            m = klz.getDeclaredMethod("setCurrentProfile", String.class);
            m.invoke(colorModel, preferredProfile);
        }
        catch (Exception ex) {
            Logger.getLogger(LafPanel.class.getName()).log(Level.INFO, "Cannot change editor colors profile.", ex);
        }
    }

    private JComponent createRestartNotificationDetails() {
        JPanel res = new JPanel(new BorderLayout(10, 10));
        res.setOpaque(false);
        JLabel lbl = new JLabel(NbBundle.getMessage(LafPanel.class, (String)"Descr_Restart"));
        lbl.setCursor(Cursor.getPredefinedCursor(12));
        res.add((Component)lbl, "Center");
        final JCheckBox checkEditorColors = new JCheckBox(NbBundle.getMessage(LafPanel.class, (String)"Hint_ChangeEditorColors"));
        if (this.isChangeEditorColorsPossible()) {
            checkEditorColors.setSelected(true);
            checkEditorColors.setOpaque(false);
            res.add((Component)checkEditorColors, "South");
        }
        lbl.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ LafPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (null != restartNotification) {
                    restartNotification.clear();
                    restartNotification = null;
                }
                if (checkEditorColors.isSelected()) {
                    this.this$0.switchEditorColorsProfile();
                }
                LifecycleManager.getDefault().markForRestart();
                LifecycleManager.getDefault().exit();
            }
        });
        return res;
    }

    private String getPreferredColorProfile() {
        String className = NbPreferences.root().node("laf").get("laf", null);
        if (null == className) {
            return null;
        }
        ClassLoader loader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        if (null == loader) {
            loader = ClassLoader.getSystemClassLoader();
        }
        try {
            Class<?> klazz = loader.loadClass(className);
            LookAndFeel laf = (LookAndFeel)klazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return laf.getDefaults().getString("nb.preferred.color.profile");
        }
        catch (Exception exception) {
            return null;
        }
    }
}

