/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutsupport;

import java.awt.Container;
import java.awt.LayoutManager;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.modules.form.CreationFactory;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.layoutsupport.DefaultLayoutSupport;
import org.netbeans.modules.form.layoutsupport.LayoutSupportDelegate;
import org.netbeans.modules.form.palette.PaletteItem;
import org.netbeans.modules.form.palette.PaletteUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

public class LayoutSupportRegistry {
    private static Map<String, String> containerToLayoutDelegate;
    private static Map<String, String> layoutToLayoutDelegate;
    private static boolean needPaletteRescan;
    public static final String DEFAULT_SUPPORT = "<default>";
    private static FileChangeListener paletteListener;
    private static Map<FormModel, LayoutSupportRegistry> instanceMap;
    private Reference<FormModel> formModelRef;

    private LayoutSupportRegistry(FormModel formModel) {
        this.formModelRef = new WeakReference<FormModel>(formModel);
    }

    public static LayoutSupportRegistry getRegistry(FormModel formModel) {
        LayoutSupportRegistry reg;
        if (instanceMap == null) {
            instanceMap = new WeakHashMap<FormModel, LayoutSupportRegistry>();
            reg = null;
        } else {
            reg = instanceMap.get(formModel);
        }
        if (reg == null) {
            reg = new LayoutSupportRegistry(formModel);
            instanceMap.put(formModel, reg);
        }
        return reg;
    }

    public static void registerSupportForContainer(String containerClassName, String layoutDelegateClassName) {
        LayoutSupportRegistry.getContainersMap().put(containerClassName, layoutDelegateClassName);
    }

    public static void registerSupportForLayout(String layoutClassName, String layoutDelegateClassName) {
        LayoutSupportRegistry.getLayoutsMap().put(layoutClassName, layoutDelegateClassName);
    }

    public LayoutSupportDelegate createSupportForContainer(Class containerClass) throws ReflectiveOperationException {
        String delegateClassName = LayoutSupportRegistry.getContainersMap().get(containerClass.getName());
        if (delegateClassName == null) {
            return this.createLayoutSupportForSuperClass(LayoutSupportRegistry.getContainersMap(), containerClass);
        }
        return (LayoutSupportDelegate)this.loadClass(delegateClassName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public LayoutSupportDelegate createSupportForLayout(Class layoutClass) throws ReflectiveOperationException {
        String layoutClassName = layoutClass.getName();
        String delegateClassName = LayoutSupportRegistry.getLayoutsMap().get(layoutClassName);
        if (delegateClassName == null && needPaletteRescan) {
            delegateClassName = LayoutSupportRegistry.scanPalette(layoutClassName);
        }
        if (delegateClassName == null && !LayoutSupportRegistry.isUsableCustomLayoutClass(layoutClass)) {
            return this.createLayoutSupportForSuperClass(LayoutSupportRegistry.getLayoutsMap(), layoutClass);
        }
        if (DEFAULT_SUPPORT.equals(delegateClassName)) {
            return new DefaultLayoutSupport(layoutClass);
        }
        if (delegateClassName != null) {
            return (LayoutSupportDelegate)this.loadClass(delegateClassName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        return null;
    }

    public static LayoutSupportDelegate createSupportInstance(Class layoutDelegateClass) throws ReflectiveOperationException {
        return (LayoutSupportDelegate)layoutDelegateClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    private static boolean isUsableCustomLayoutClass(Class layoutClass) {
        if ((layoutClass.getModifiers() & 1) == 0) {
            return false;
        }
        try {
            if (layoutClass.getConstructor(new Class[0]) != null) {
                return true;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return CreationFactory.getDescriptor(layoutClass) != null;
    }

    private LayoutSupportDelegate createLayoutSupportForSuperClass(Map<String, String> map, Class subClass) throws ReflectiveOperationException {
        for (Map.Entry<String, String> en : map.entrySet()) {
            String regName = en.getKey();
            for (Class superClass = subClass.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
                if (!superClass.getName().equals(regName)) continue;
                String delegateClassName = en.getValue();
                if (DEFAULT_SUPPORT.equals(delegateClassName)) {
                    return new DefaultLayoutSupport(superClass);
                }
                return (LayoutSupportDelegate)this.loadClass(delegateClassName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        return null;
    }

    private static String scanPalette(String wantedClassName) {
        boolean newPaletteListener;
        FileObject paletteFolder = PaletteUtils.getPaletteFolder();
        boolean bl = newPaletteListener = paletteListener == null;
        if (newPaletteListener) {
            paletteListener = new FileChangeAdapter(){

                public void fileDataCreated(FileEvent fe) {
                    needPaletteRescan = true;
                }

                public void fileFolderCreated(FileEvent fe) {
                    needPaletteRescan = true;
                    fe.getFile().addFileChangeListener((FileChangeListener)this);
                }

                public void fileDeleted(FileEvent fe) {
                    fe.getFile().removeFileChangeListener((FileChangeListener)this);
                }
            };
            paletteFolder.addFileChangeListener(paletteListener);
        }
        String foundSupportClassName = null;
        FileObject[] paletteCategories = paletteFolder.getChildren();
        for (int i = 0; i < paletteCategories.length; ++i) {
            FileObject categoryFolder = paletteCategories[i];
            if (!categoryFolder.isFolder()) continue;
            if (newPaletteListener) {
                categoryFolder.addFileChangeListener(paletteListener);
            }
            FileObject[] paletteItems = categoryFolder.getChildren();
            for (int j = 0; j < paletteItems.length; ++j) {
                Map<String, String> map;
                Class supportedClass;
                Class delegateClass;
                block12: {
                    Class itemClass;
                    DataObject itemDO = null;
                    try {
                        itemDO = DataObject.find((FileObject)paletteItems[j]);
                    }
                    catch (DataObjectNotFoundException ex) {
                        continue;
                    }
                    PaletteItem item = (PaletteItem)itemDO.getCookie(PaletteItem.class);
                    if (item == null || !item.isLayout() || (itemClass = item.getComponentClass()) == null) continue;
                    delegateClass = null;
                    supportedClass = null;
                    if (LayoutSupportDelegate.class.isAssignableFrom(itemClass)) {
                        delegateClass = itemClass;
                        try {
                            LayoutSupportDelegate delegate = (LayoutSupportDelegate)delegateClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                            supportedClass = delegate.getSupportedClass();
                            break block12;
                        }
                        catch (Exception ex) {
                            ErrorManager.getDefault().notify(1, (Throwable)ex);
                            continue;
                        }
                    }
                    if (LayoutManager.class.isAssignableFrom(itemClass)) {
                        supportedClass = itemClass;
                    }
                }
                if (supportedClass == null) continue;
                if (Container.class.isAssignableFrom(supportedClass)) {
                    map = LayoutSupportRegistry.getContainersMap();
                } else {
                    if (!LayoutManager.class.isAssignableFrom(supportedClass)) continue;
                    map = LayoutSupportRegistry.getLayoutsMap();
                }
                String supportedClassName = supportedClass.getName();
                if (map.get(supportedClassName) != null) continue;
                String delegateClassName = delegateClass != null ? delegateClass.getName() : DEFAULT_SUPPORT;
                map.put(supportedClassName, delegateClassName);
                if (!supportedClassName.equals(wantedClassName)) continue;
                foundSupportClassName = delegateClassName;
            }
        }
        needPaletteRescan = false;
        return foundSupportClassName;
    }

    private Class loadClass(String className) throws ClassNotFoundException {
        return FormUtils.loadClass(className, this.formModelRef.get());
    }

    private static Map<String, String> getContainersMap() {
        if (containerToLayoutDelegate == null) {
            containerToLayoutDelegate = new HashMap<String, String>();
            containerToLayoutDelegate.put("javax.swing.JScrollPane", "org.netbeans.modules.form.layoutsupport.delegates.JScrollPaneSupport");
            containerToLayoutDelegate.put("java.awt.ScrollPane", "org.netbeans.modules.form.layoutsupport.delegates.ScrollPaneSupport");
            containerToLayoutDelegate.put("javax.swing.JSplitPane", "org.netbeans.modules.form.layoutsupport.delegates.JSplitPaneSupport");
            containerToLayoutDelegate.put("javax.swing.JTabbedPane", "org.netbeans.modules.form.layoutsupport.delegates.JTabbedPaneSupport");
            containerToLayoutDelegate.put("javax.swing.JToolBar", "org.netbeans.modules.form.layoutsupport.delegates.JToolBarSupport");
            containerToLayoutDelegate.put("javax.swing.JMenuBar", "org.netbeans.modules.form.layoutsupport.delegates.MenuFakeSupport");
            containerToLayoutDelegate.put("javax.swing.JMenu", "org.netbeans.modules.form.layoutsupport.delegates.MenuFakeSupport");
            containerToLayoutDelegate.put("javax.swing.JPopupMenu", "org.netbeans.modules.form.layoutsupport.delegates.MenuFakeSupport");
        }
        return containerToLayoutDelegate;
    }

    private static Map<String, String> getLayoutsMap() {
        if (layoutToLayoutDelegate == null) {
            layoutToLayoutDelegate = new HashMap<String, String>();
            layoutToLayoutDelegate.put("java.awt.BorderLayout", "org.netbeans.modules.form.layoutsupport.delegates.BorderLayoutSupport");
            layoutToLayoutDelegate.put("java.awt.FlowLayout", "org.netbeans.modules.form.layoutsupport.delegates.FlowLayoutSupport");
            layoutToLayoutDelegate.put("javax.swing.BoxLayout", "org.netbeans.modules.form.layoutsupport.delegates.BoxLayoutSupport");
            layoutToLayoutDelegate.put("javax.swing.OverlayLayout", "org.netbeans.modules.form.layoutsupport.delegates.OverlayLayoutSupport");
            layoutToLayoutDelegate.put("java.awt.GridBagLayout", "org.netbeans.modules.form.layoutsupport.delegates.GridBagLayoutSupport");
            layoutToLayoutDelegate.put("java.awt.GridLayout", "org.netbeans.modules.form.layoutsupport.delegates.GridLayoutSupport");
            layoutToLayoutDelegate.put("java.awt.CardLayout", "org.netbeans.modules.form.layoutsupport.delegates.CardLayoutSupport");
            layoutToLayoutDelegate.put("org.netbeans.lib.awtextra.AbsoluteLayout", "org.netbeans.modules.form.layoutsupport.delegates.AbsoluteLayoutSupport");
            layoutToLayoutDelegate.put("org.jdesktop.swingx.VerticalLayout", DEFAULT_SUPPORT);
            layoutToLayoutDelegate.put("org.jdesktop.swingx.HorizontalLayout", DEFAULT_SUPPORT);
        }
        return layoutToLayoutDelegate;
    }

    static {
        needPaletteRescan = true;
    }
}

