/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.osgi;

import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.core.osgi.Activator;
import org.netbeans.core.startup.layers.SessionManager;
import org.openide.LifecycleManager;
import org.openide.modules.ModuleInstall;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.launch.Framework;

class OSGiLifecycleManager
extends LifecycleManager {
    private static final Logger LOG = Logger.getLogger(OSGiLifecycleManager.class.getName());
    private final BundleContext context;
    private final AtomicBoolean exited = new AtomicBoolean();

    OSGiLifecycleManager(BundleContext context) {
        this.context = context;
    }

    public void saveAll() {
        for (LifecycleManager mgr : Lookup.getDefault().lookupAll(LifecycleManager.class)) {
            if (mgr instanceof OSGiLifecycleManager) continue;
            mgr.saveAll();
        }
    }

    public void exit() {
        String name;
        ClassLoader loader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        try {
            if (!((Boolean)loader.loadClass("org.netbeans.core.ExitDialog").getMethod("showDialog", new Class[0]).invoke(null, new Object[0])).booleanValue()) {
                return;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (Exception x) {
            LOG.log(Level.WARNING, "Could not prompt to save open files", x);
            this.saveAll();
        }
        for (Map.Entry<Bundle, ModuleInstall> entry : Activator.installers.entrySet()) {
            name = entry.getKey().getSymbolicName();
            LOG.log(Level.FINE, "closing: {0}", name);
            if (entry.getValue().closing()) continue;
            LOG.log(Level.FINE, "Will not close by request of {0}", name);
            return;
        }
        if (this.exited.getAndSet(true)) {
            return;
        }
        try {
            final Class<?> windowSystemClazz = loader.loadClass("org.netbeans.core.WindowSystem");
            final Object windowSystem = Lookup.getDefault().lookup(windowSystemClazz);
            if (windowSystem != null) {
                Mutex.EVENT.readAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){
                    final /* synthetic */ OSGiLifecycleManager this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public Void run() throws Exception {
                        windowSystemClazz.getMethod("hide", new Class[0]).invoke(windowSystem, new Object[0]);
                        windowSystemClazz.getMethod("save", new Class[0]).invoke(windowSystem, new Object[0]);
                        return null;
                    }
                });
            }
        }
        catch (ClassNotFoundException windowSystemClazz) {
        }
        catch (Exception x) {
            LOG.log(Level.WARNING, "Could not shut down window system", x);
        }
        for (Map.Entry<Bundle, ModuleInstall> entry : Activator.installers.entrySet()) {
            name = entry.getKey().getSymbolicName();
            LOG.log(Level.FINE, "close: {0}", name);
            entry.getValue().close();
        }
        SessionManager.getDefault().close();
        Bundle system = this.context.getBundle(0L);
        if (system instanceof Framework) {
            try {
                ((Framework)system).stop();
            }
            catch (BundleException x) {
                LOG.log(Level.WARNING, "Could not stop OSGi framework", x);
            }
        }
    }
}

