/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.oniguruma;

import java.nio.charset.StandardCharsets;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.core.TMException;
import org.eclipse.tm4e.core.internal.oniguruma.OnigResult;
import org.eclipse.tm4e.core.internal.oniguruma.OnigString;
import org.eclipse.tm4e.core.internal.utils.StringUtils;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.joni.Matcher;
import org.joni.Regex;
import org.joni.Region;
import org.joni.Syntax;
import org.joni.WarnCallback;
import org.joni.exception.SyntaxException;

public final class OnigRegExp {
    private static final System.Logger LOGGER = System.getLogger(OnigRegExp.class.getName());
    private static final WarnCallback LOGGER_WARN_CALLBACK = message -> LOGGER.log(System.Logger.Level.WARNING, message);
    private @Nullable OnigString lastSearchString;
    private int lastSearchPosition = -1;
    private @Nullable OnigResult lastSearchResult;
    private final String pattern;
    private final Regex regex;
    private final boolean hasGAnchor;

    public OnigRegExp(String pattern) {
        this(pattern, false);
    }

    public OnigRegExp(String pattern, boolean ignoreCase) {
        Regex regex;
        this.hasGAnchor = pattern.contains("\\G");
        try {
            regex = this.parsePattern(pattern, ignoreCase);
        }
        catch (SyntaxException ex) {
            try {
                regex = this.parsePattern(this.rewritePatternIfRequired(pattern), ignoreCase);
            }
            catch (SyntaxException unused) {
                throw new TMException("Parsing regex pattern \"" + pattern + "\" failed with " + String.valueOf((Object)ex), ex);
            }
        }
        this.pattern = pattern;
        this.regex = regex;
    }

    private Regex parsePattern(String pattern, boolean ignoreCase) throws SyntaxException {
        int options = 256;
        if (ignoreCase) {
            options |= 1;
        }
        byte[] patternBytes = pattern.getBytes(StandardCharsets.UTF_8);
        return new Regex(patternBytes, 0, patternBytes.length, options, (Encoding)UTF8Encoding.INSTANCE, Syntax.DEFAULT, LOGGER.isLoggable(System.Logger.Level.WARNING) ? LOGGER_WARN_CALLBACK : WarnCallback.NONE);
    }

    private String rewritePatternIfRequired(String pattern) {
        String lookbehind1 = "(?<!\\.\\s*)";
        if (pattern.startsWith("(?<!\\.\\s*)")) {
            return "(?<!\\.)\\s*" + pattern.substring("(?<!\\.\\s*)".length());
        }
        String lookbehind2 = "(?<=^\\s*)";
        if (pattern.startsWith("(?<=^\\s*)")) {
            return "(?<=^)\\s*" + pattern.substring("(?<=^\\s*)".length());
        }
        String lookbehind3 = "(?<=\\s*\\.)";
        if (pattern.startsWith("(?<=\\s*\\.)")) {
            return "\\s*\\." + pattern.substring("(?<=\\s*\\.)".length());
        }
        return pattern;
    }

    public @Nullable OnigResult search(OnigString str, int startPosition) {
        if (this.hasGAnchor) {
            return this.search(str.bytesUTF8, startPosition, str.bytesCount);
        }
        OnigResult lastSearchResult0 = this.lastSearchResult;
        if (this.lastSearchString == str && this.lastSearchPosition <= startPosition && (lastSearchResult0 == null || lastSearchResult0.locationAt(0) >= startPosition)) {
            return lastSearchResult0;
        }
        this.lastSearchString = str;
        this.lastSearchPosition = startPosition;
        this.lastSearchResult = this.search(str.bytesUTF8, startPosition, str.bytesCount);
        return this.lastSearchResult;
    }

    private @Nullable OnigResult search(byte[] data, int startPosition, int end) {
        Matcher matcher = this.regex.matcher(data);
        int status = matcher.search(startPosition, end, 0);
        if (status != -1) {
            Region region = matcher.getEagerRegion();
            return new OnigResult(region, -1);
        }
        return null;
    }

    public String pattern() {
        return this.pattern;
    }

    public String toString() {
        return StringUtils.toString(this, sb -> sb.append("pattern=").append(this.pattern));
    }
}

