/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javaee.wildfly.ide.ui;

import java.util.Map;
import java.util.Set;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;

class DomainComboModel
extends AbstractListModel
implements ComboBoxModel {
    private int current = -1;
    private String[][] domains = null;

    public void addDomain(String domain, String path) {
        String[][] newDomains = new String[this.domains.length + 1][2];
        for (int i = 0; i < this.domains.length; ++i) {
            newDomains[i][0] = this.domains[i][0];
            newDomains[i][1] = this.domains[i][1];
        }
        newDomains[i][0] = domain;
        newDomains[i][1] = path;
        this.domains = newDomains;
    }

    public DomainComboModel(Map domains) {
        this.setDomains(domains);
    }

    public void setDomains(Map domains) {
        this.current = -1;
        this.domains = null;
        int len = domains.size();
        this.domains = new String[len][2];
        Set en = domains.keySet();
        if (len > 0) {
            this.current = 0;
        }
        int i = 0;
        for (Object key : en) {
            this.domains[i][0] = (String)key;
            this.domains[i][1] = (String)domains.get(this.domains[i][0]);
            if (this.domains[i][0].equalsIgnoreCase("default")) {
                this.current = i;
            }
            ++i;
        }
    }

    @Override
    public Object getSelectedItem() {
        if (this.current == -1) {
            return "";
        }
        return this.domains[this.current][0];
    }

    @Override
    public void setSelectedItem(Object anItem) {
        for (int i = 0; i < this.getSize(); ++i) {
            if (!this.domains[i][0].equals(anItem)) continue;
            this.current = i;
            this.fireContentsChanged(this, -1, -1);
            return;
        }
        this.current = -1;
        this.fireContentsChanged(this, -1, -1);
    }

    @Override
    public Object getElementAt(int index) {
        return this.domains[index][0];
    }

    @Override
    public int getSize() {
        return this.domains.length;
    }

    public String getCurrentPath() {
        if (this.current == -1) {
            return "";
        }
        return this.domains[this.current][1];
    }

    public boolean hasDomain(String domain) {
        for (int i = 0; i < this.getSize(); ++i) {
            if (!this.domains[i][0].equals(domain)) continue;
            return true;
        }
        return false;
    }
}

