/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.database.model.DayOfWeek;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ScheduledOperationDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="dayOfWeek")
    private final DayOfWeek dayOfWeek;
    @JsonProperty(value="scheduledStartTime")
    private final String scheduledStartTime;
    @JsonProperty(value="scheduledStopTime")
    private final String scheduledStopTime;

    @Deprecated
    @ConstructorProperties(value={"dayOfWeek", "scheduledStartTime", "scheduledStopTime"})
    public ScheduledOperationDetails(DayOfWeek dayOfWeek, String scheduledStartTime, String scheduledStopTime) {
        this.dayOfWeek = dayOfWeek;
        this.scheduledStartTime = scheduledStartTime;
        this.scheduledStopTime = scheduledStopTime;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public DayOfWeek getDayOfWeek() {
        return this.dayOfWeek;
    }

    public String getScheduledStartTime() {
        return this.scheduledStartTime;
    }

    public String getScheduledStopTime() {
        return this.scheduledStopTime;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ScheduledOperationDetails(");
        sb.append("super=").append(super.toString());
        sb.append("dayOfWeek=").append(String.valueOf((Object)this.dayOfWeek));
        sb.append(", scheduledStartTime=").append(String.valueOf(this.scheduledStartTime));
        sb.append(", scheduledStopTime=").append(String.valueOf(this.scheduledStopTime));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ScheduledOperationDetails)) {
            return false;
        }
        ScheduledOperationDetails other = (ScheduledOperationDetails)((Object)o);
        return Objects.equals((Object)this.dayOfWeek, (Object)other.dayOfWeek) && Objects.equals(this.scheduledStartTime, other.scheduledStartTime) && Objects.equals(this.scheduledStopTime, other.scheduledStopTime) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.dayOfWeek == null ? 43 : this.dayOfWeek.hashCode());
        result = result * 59 + (this.scheduledStartTime == null ? 43 : this.scheduledStartTime.hashCode());
        result = result * 59 + (this.scheduledStopTime == null ? 43 : this.scheduledStopTime.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="dayOfWeek")
        private DayOfWeek dayOfWeek;
        @JsonProperty(value="scheduledStartTime")
        private String scheduledStartTime;
        @JsonProperty(value="scheduledStopTime")
        private String scheduledStopTime;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder dayOfWeek(DayOfWeek dayOfWeek) {
            this.dayOfWeek = dayOfWeek;
            this.__explicitlySet__.add("dayOfWeek");
            return this;
        }

        public Builder scheduledStartTime(String scheduledStartTime) {
            this.scheduledStartTime = scheduledStartTime;
            this.__explicitlySet__.add("scheduledStartTime");
            return this;
        }

        public Builder scheduledStopTime(String scheduledStopTime) {
            this.scheduledStopTime = scheduledStopTime;
            this.__explicitlySet__.add("scheduledStopTime");
            return this;
        }

        public ScheduledOperationDetails build() {
            ScheduledOperationDetails model = new ScheduledOperationDetails(this.dayOfWeek, this.scheduledStartTime, this.scheduledStopTime);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ScheduledOperationDetails model) {
            if (model.wasPropertyExplicitlySet("dayOfWeek")) {
                this.dayOfWeek(model.getDayOfWeek());
            }
            if (model.wasPropertyExplicitlySet("scheduledStartTime")) {
                this.scheduledStartTime(model.getScheduledStartTime());
            }
            if (model.wasPropertyExplicitlySet("scheduledStopTime")) {
                this.scheduledStopTime(model.getScheduledStopTime());
            }
            return this;
        }
    }
}

