/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.nette.tester.preferences;

import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.validation.ValidationResult;
import org.netbeans.modules.php.nette.tester.preferences.TesterPreferences;
import org.netbeans.modules.php.nette.tester.util.TesterUtils;

public final class TesterPreferencesValidator {
    private final ValidationResult result = new ValidationResult();

    public ValidationResult getResult() {
        return this.result;
    }

    public TesterPreferencesValidator validate(PhpModule phpModule) {
        this.validatePhpIni(TesterPreferences.isPhpIniEnabled(phpModule), TesterPreferences.getPhpIniPath(phpModule));
        this.validateTester(TesterPreferences.isTesterEnabled(phpModule), TesterPreferences.getTesterPath(phpModule));
        this.validateCoverageSourcePath(TesterPreferences.isCoverageSourcePathEnabled(phpModule), TesterPreferences.getCoverageSourcePath(phpModule));
        return this;
    }

    public TesterPreferencesValidator validatePhpIni(boolean phpIniEnabled, String phpIniPath) {
        String warning;
        if (phpIniEnabled && (warning = TesterUtils.validatePhpIniPath(phpIniPath)) != null) {
            this.result.addWarning(new ValidationResult.Message((Object)"php.ini.path", warning));
        }
        return this;
    }

    public TesterPreferencesValidator validateTester(boolean testerEnabled, String testerPath) {
        String warning;
        if (testerEnabled && (warning = TesterUtils.validateTesterPath(testerPath)) != null) {
            this.result.addWarning(new ValidationResult.Message((Object)"tester.path", warning));
        }
        return this;
    }

    public TesterPreferencesValidator validateCoverageSourcePath(boolean sourcePathEnabled, String sourcePath) {
        String warning;
        if (sourcePathEnabled && (warning = TesterUtils.validateCoverageSourcePath(sourcePath)) != null) {
            this.result.addWarning(new ValidationResult.Message((Object)"coverage.source.path", warning));
        }
        return this;
    }
}

