/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TypeMirrorHandle;
import org.netbeans.api.java.source.ui.ElementHeaders;
import org.netbeans.api.java.source.ui.ElementIcons;
import org.netbeans.modules.refactoring.java.api.ExtractInterfaceRefactoring;
import org.netbeans.modules.refactoring.java.ui.MoveMembersPanel;
import org.netbeans.modules.refactoring.java.ui.UIUtilities;
import org.netbeans.modules.refactoring.java.ui.elements.FiltersDescription;
import org.netbeans.modules.refactoring.java.ui.elements.FiltersManager;
import org.netbeans.modules.refactoring.java.ui.elements.JCheckBoxIcon;
import org.netbeans.modules.refactoring.java.ui.elements.TapPanel;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public final class ExtractInterfacePanel
extends JPanel
implements CustomRefactoringPanel {
    private static final String[] COLUMN_NAMES = new String[]{"LBL_Selected", "LBL_ExtractInterface_Member"};
    private static final Class[] COLUMN_CLASSES = new Class[]{Boolean.class, TreePathHandle.class};
    private final ExtractInterfaceRefactoring refactoring;
    private final TableModel tableModel;
    private Object[][] members = new Object[0][0];
    private TapPanel filtersPanel;
    private FiltersManager filtersManager;
    private JTable membersTable;
    private JPanel memberspanel;
    private JLabel nameLabel;
    private JPanel namePanel;
    private JTextField nameText;
    private JScrollPane scrollPane;

    public ExtractInterfacePanel(ExtractInterfaceRefactoring refactoring, final ChangeListener parent) {
        this.refactoring = refactoring;
        this.tableModel = new TableModel();
        this.initComponents();
        this.setPreferredSize(new Dimension(420, 380));
        String defaultName = "NewInterface";
        this.nameText.setText(defaultName);
        this.nameText.setSelectionStart(0);
        this.nameText.setSelectionEnd(defaultName.length());
        this.nameText.getDocument().addDocumentListener(new DocumentListener(){
            final /* synthetic */ ExtractInterfacePanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void changedUpdate(DocumentEvent event) {
                parent.stateChanged(null);
            }

            @Override
            public void insertUpdate(DocumentEvent event) {
                parent.stateChanged(null);
            }

            @Override
            public void removeUpdate(DocumentEvent event) {
                parent.stateChanged(null);
            }
        });
        this.filtersPanel = new TapPanel();
        this.filtersPanel.setOrientation(2);
        AbstractButton[] res = new AbstractButton[2];
        res[0] = new JButton(null, new JCheckBoxIcon(true, new Dimension(16, 16)));
        res[0].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtractInterfacePanel.this.selectAll(true);
            }
        });
        res[0].setToolTipText(NbBundle.getMessage(MoveMembersPanel.class, (String)"TIP_SelectAll"));
        res[1] = new JButton(null, new JCheckBoxIcon(false, new Dimension(16, 16)));
        res[1].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtractInterfacePanel.this.selectAll(false);
            }
        });
        res[1].setToolTipText(NbBundle.getMessage(MoveMembersPanel.class, (String)"TIP_DeselectAll"));
        FiltersDescription desc = new FiltersDescription();
        this.filtersManager = FiltersDescription.createManager(desc);
        JComponent buttons = this.filtersManager.getComponent(res);
        buttons.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 0));
        this.filtersPanel.add(buttons);
        if ("Aqua".equals(UIManager.getLookAndFeel().getID())) {
            this.filtersPanel.setBackground(UIManager.getColor("NbExplorerView.background"));
        }
        this.memberspanel.add((Component)this.filtersPanel, "South");
    }

    @Override
    public boolean requestFocusInWindow() {
        this.nameText.requestFocusInWindow();
        return true;
    }

    public void initialize() {
        this.membersTable.setDefaultRenderer(COLUMN_CLASSES[1], new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, this.extractText(value), isSelected, hasFocus, row, column);
                if (value instanceof ExtractInterfaceInfo) {
                    this.setIcon(((ExtractInterfaceInfo)value).icon);
                }
                return this;
            }

            protected String extractText(Object value) {
                String displayValue = value instanceof ExtractInterfaceInfo ? ((ExtractInterfaceInfo)value).htmlText : String.valueOf(value);
                return displayValue;
            }
        });
        this.scrollPane.setBackground(this.membersTable.getBackground());
        this.scrollPane.getViewport().setBackground(this.membersTable.getBackground());
        this.membersTable.setRowHeight(18);
        if (UIManager.getColor("control") != null) {
            this.membersTable.setGridColor(UIManager.getColor("control"));
        }
        UIUtilities.initColumnWidth(this.membersTable, 0, Boolean.TRUE, 4);
    }

    public void storeSettings() {
        ArrayList<ElementHandle<VariableElement>> fields = new ArrayList<ElementHandle<VariableElement>>();
        ArrayList<ElementHandle<ExecutableElement>> methods = new ArrayList<ElementHandle<ExecutableElement>>();
        ArrayList<TypeMirrorHandle<TypeMirror>> implementz = new ArrayList<TypeMirrorHandle<TypeMirror>>();
        block5: for (int i = 0; i < this.members.length; ++i) {
            if (!this.members[i][0].equals(Boolean.TRUE)) continue;
            ExtractInterfaceInfo info = (ExtractInterfaceInfo)this.members[i][1];
            switch (info.group.ordinal()) {
                case 2: {
                    fields.add((ElementHandle<VariableElement>)((ElementHandle)info.handle));
                    continue block5;
                }
                case 1: {
                    methods.add((ElementHandle<ExecutableElement>)((ElementHandle)info.handle));
                    continue block5;
                }
                case 0: {
                    implementz.add((TypeMirrorHandle<TypeMirror>)((TypeMirrorHandle)info.handle));
                }
            }
        }
        this.refactoring.setFields(fields);
        this.refactoring.setImplements(implementz);
        this.refactoring.setMethods(methods);
        this.refactoring.setInterfaceName(this.nameText.getText());
    }

    private void selectAll(boolean select) {
        for (Object[] row : this.members) {
            row[0] = select ? Boolean.TRUE : Boolean.FALSE;
        }
        this.tableModel.fireTableDataChanged();
    }

    private void initComponents() {
        this.namePanel = new JPanel();
        this.nameLabel = new JLabel();
        this.nameText = new JTextField();
        this.memberspanel = new JPanel();
        this.scrollPane = new JScrollPane();
        this.membersTable = new JTable();
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 11, 11));
        this.setLayout(new BorderLayout(0, 10));
        this.namePanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.namePanel.setLayout(new BorderLayout(12, 0));
        this.nameLabel.setLabelFor(this.nameText);
        Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)NbBundle.getMessage(ExtractInterfacePanel.class, (String)"LBL_ExtractInterface_Name"));
        this.namePanel.add((Component)this.nameLabel, "West");
        this.nameLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ExtractInterfacePanel.class, (String)"ACSD_InterfaceName"));
        this.nameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ExtractInterfacePanel.class, (String)"ACSD_InterfaceNameDescription"));
        this.namePanel.add((Component)this.nameText, "Center");
        this.add((Component)this.namePanel, "North");
        this.memberspanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(ExtractInterfacePanel.class, (String)"LBL_ExtractInterfaceLabel")));
        this.memberspanel.setLayout(new BorderLayout());
        this.scrollPane.setBorder(null);
        this.membersTable.setModel(this.tableModel);
        this.membersTable.setAutoResizeMode(1);
        this.scrollPane.setViewportView(this.membersTable);
        this.membersTable.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ExtractInterfacePanel.class, (String)"ACSD_MembersToExtract"));
        this.membersTable.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ExtractInterfacePanel.class, (String)"ACSD_MembersToExtractDescription"));
        this.memberspanel.add((Component)this.scrollPane, "Center");
        this.add((Component)this.memberspanel, "Center");
    }

    public Component getComponent() {
        return this;
    }

    private class TableModel
    extends AbstractTableModel {
        TableModel() {
            this.initialize();
        }

        @Override
        public int getColumnCount() {
            return COLUMN_NAMES.length;
        }

        @Override
        public String getColumnName(int column) {
            return UIUtilities.getColumnName(NbBundle.getMessage(ExtractInterfacePanel.class, (String)COLUMN_NAMES[column]));
        }

        public Class getColumnClass(int columnIndex) {
            return COLUMN_CLASSES[columnIndex];
        }

        @Override
        public int getRowCount() {
            return ExtractInterfacePanel.this.members.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return ExtractInterfacePanel.this.members[rowIndex][columnIndex];
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            ExtractInterfacePanel.this.members[rowIndex][columnIndex] = value;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        private void initialize() {
            final TreePathHandle sourceType = ExtractInterfacePanel.this.refactoring.getSourceType();
            if (sourceType == null) {
                return;
            }
            FileObject fo = sourceType.getFileObject();
            JavaSource js = JavaSource.forFileObject((FileObject)fo);
            try {
                js.runUserActionTask((Task)new CancellableTask<CompilationController>(){
                    final /* synthetic */ TableModel this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void cancel() {
                    }

                    public void run(CompilationController javac) throws Exception {
                        javac.toPhase(JavaSource.Phase.RESOLVED);
                        this.this$1.initializeInTransaction(javac, sourceType);
                    }
                }, true);
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
        }

        private void initializeInTransaction(CompilationController javac, TreePathHandle sourceType) {
            TreePath sourceTreePath = sourceType.resolve((CompilationInfo)javac);
            ClassTree sourceTree = (ClassTree)sourceTreePath.getLeaf();
            ArrayList<ExtractInterfaceInfo<Object>> result = new ArrayList<ExtractInterfaceInfo<Object>>();
            for (Tree tree : sourceTree.getImplementsClause()) {
                TreePath implPath = javac.getTrees().getPath(javac.getCompilationUnit(), tree);
                TypeMirror implMirror = javac.getTrees().getTypeMirror(implPath);
                result.add(new ExtractInterfaceInfo<TypeMirrorHandle>(TypeMirrorHandle.create((TypeMirror)implMirror), "implements " + tree.toString(), ElementIcons.getElementIcon((ElementKind)ElementKind.INTERFACE, null), tree.toString(), Group.IMPLEMENTS));
            }
            for (Tree tree : sourceTree.getMembers()) {
                Group group;
                Set<Modifier> mods;
                Element memberElm;
                TreePath memberTreePath = javac.getTrees().getPath(javac.getCompilationUnit(), tree);
                if (javac.getTreeUtilities().isSynthetic(memberTreePath) || (memberElm = javac.getTrees().getElement(memberTreePath)) == null || !(mods = memberElm.getModifiers()).contains((Object)Modifier.PUBLIC)) continue;
                Object format = "%name%";
                if (memberElm.getKind() == ElementKind.FIELD) {
                    if (!mods.contains((Object)Modifier.STATIC) || !mods.contains((Object)Modifier.FINAL) || ((VariableTree)tree).getInitializer() == null) continue;
                    group = Group.FIELD;
                    format = (String)format + " : %type%";
                } else {
                    if (memberElm.getKind() != ElementKind.METHOD || mods.contains((Object)Modifier.STATIC)) continue;
                    group = Group.METHOD;
                    format = (String)format + "%parameters% : %type%";
                }
                result.add(new ExtractInterfaceInfo<ElementHandle>(ElementHandle.create((Element)memberElm), ElementHeaders.getHeader((Element)memberElm, (CompilationInfo)javac, (String)format), ElementIcons.getElementIcon((ElementKind)memberElm.getKind(), mods), memberElm.getSimpleName().toString(), group));
            }
            result.sort(new Comparator(){

                public int compare(Object o1, Object o2) {
                    ExtractInterfaceInfo i1 = (ExtractInterfaceInfo)o1;
                    ExtractInterfaceInfo i2 = (ExtractInterfaceInfo)o2;
                    int result = i1.group.compareTo(i2.group);
                    if (result == 0) {
                        result = i1.name.compareTo(i2.name);
                    }
                    return result;
                }
            });
            ExtractInterfacePanel.this.members = new Object[result.size()][2];
            for (int i = 0; i < ExtractInterfacePanel.this.members.length; ++i) {
                ExtractInterfacePanel.this.members[i][0] = Boolean.FALSE;
                ExtractInterfacePanel.this.members[i][1] = result.get(i);
            }
            this.fireTableDataChanged();
        }
    }

    private static final class ExtractInterfaceInfo<H> {
        final H handle;
        final String htmlText;
        final Icon icon;
        final String name;
        final Group group;

        public ExtractInterfaceInfo(H handle, String htmlText, Icon icon, String name, Group group) {
            this.handle = handle;
            this.htmlText = htmlText;
            this.icon = icon;
            this.name = name;
            this.group = group;
        }
    }

    private static enum Group {
        IMPLEMENTS,
        METHOD,
        FIELD;

    }
}

