/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.uddi;

import com.sun.xml.registry.uddi.RegistryServiceImpl;
import com.sun.xml.registry.uddi.infomodel.RegistryObjectImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ResourceBundle;
import javax.xml.registry.BulkResponse;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.RegistryObject;

public class UDDIObjectCache {
    private Hashtable cache = new Hashtable();
    private LinkedList list = new LinkedList();
    Collection registryServices;
    private static final int MAX_CACHE_SIZE = 150;

    public UDDIObjectCache(RegistryServiceImpl service) {
        if (this.registryServices == null) {
            this.registryServices = new ArrayList();
        }
        this.addToRegistryServices(service);
    }

    void addObjectToCache(RegistryObjectImpl ro, String serviceId) throws JAXRException {
        if (ro.getServiceId() == null) {
            ro.setServiceId(serviceId);
        }
        this.add(ro);
    }

    void addObjectsToCache(Collection registryObjects, String serviceId) throws JAXRException {
        for (Object obj : registryObjects) {
            if (!(obj instanceof RegistryObjectImpl)) continue;
            RegistryObjectImpl ro = (RegistryObjectImpl)obj;
            if (ro.getServiceId() == null) {
                ro.setServiceId(serviceId);
            }
            if (ro.getServiceId() == null) {
                ro.setServiceId(serviceId);
            }
            this.add(ro);
        }
    }

    RegistryObject fetchObjectFromCache(String id) throws JAXRException {
        return (RegistryObject)this.cache.get(id);
    }

    public void fetchObject(RegistryObjectImpl registryObject, String serviceId) throws JAXRException {
        Object br = null;
        Object ro = null;
        if (registryObject != null) {
            RegistryServiceImpl service = (RegistryServiceImpl)registryObject.getRegistryService();
            if (service.getConnection().useCache() && registryObject.isLoaded()) {
                return;
            }
            service.getUDDIMapper().getRegistryObject(registryObject);
            if (service.getConnection().useCache()) {
                this.add(registryObject);
            }
            registryObject.setStatusFlags(true, true, false);
        }
        if (registryObject != null) {
            registryObject.setStatusFlags(true, true, false);
        }
    }

    void removeObjectFromCache(String id) {
        RegistryObjectImpl registryObject;
        if (this.list.size() > 0) {
            this.list.remove(id);
        }
        if ((registryObject = (RegistryObjectImpl)this.cache.remove(id)) != null) {
            registryObject.setIsDeleted(true);
        }
    }

    void removeObjectsFromCache(Collection keys) throws JAXRException {
        if (keys == null) {
            return;
        }
        Iterator i = keys.iterator();
        try {
            while (i.hasNext()) {
                String id = ((Key)i.next()).getId();
                this.removeObjectFromCache(id);
            }
        }
        catch (JAXRException je) {
            throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIObjectManager:Error_deleting_objects_from_Cache"), (Throwable)je);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(RegistryObjectImpl registryObject) throws JAXRException {
        String rid = registryObject.getKey().getId();
        Object object = this.list;
        synchronized (object) {
            this.list.remove(rid);
            this.list.addFirst(rid);
        }
        if (this.cache.size() >= 150) {
            String id = null;
            Serializable serializable = this.list;
            synchronized (serializable) {
                id = (String)this.list.removeLast();
            }
            serializable = (RegistryObjectImpl)this.cache.remove(id);
        }
        object = this;
        synchronized (object) {
            this.cache.put(rid, registryObject);
        }
    }

    public void fetchAssociations(RegistryObjectImpl registryObject, String serviceId) throws JAXRException {
        BulkResponse br = null;
        if (registryObject != null) {
            String id = registryObject.getKey().getId();
            if (id == null) {
                return;
            }
            if (registryObject.areAssociationsLoaded()) {
                return;
            }
            String regServiceId = registryObject.getServiceId();
            RegistryServiceImpl service = this.getService(regServiceId);
            br = service.getUDDIMapper().findAssociations(null, id, null, null);
        }
        if (br.getExceptions() == null) {
            Collection registryObjects = br.getCollection();
            for (RegistryObjectImpl ro : registryObjects) {
                this.add(ro);
                ro.setAssociationsLoaded(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushCache() {
        UDDIObjectCache uDDIObjectCache = this;
        synchronized (uDDIObjectCache) {
            this.cache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToRegistryServices(RegistryServiceImpl service) {
        Collection collection = this.registryServices;
        synchronized (collection) {
            if (!this.registryServices.contains(service)) {
                this.registryServices.add(service);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegistryServiceImpl getService(String id) {
        Collection collection = this.registryServices;
        synchronized (collection) {
            for (RegistryServiceImpl service : this.registryServices) {
                if (!service.getServiceId().equals(id)) continue;
                return service;
            }
        }
        return null;
    }
}

