/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.gmbal.impl;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.ReflectPermission;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.List;
import javax.management.MBeanException;
import javax.management.ReflectionException;
import org.glassfish.gmbal.impl.Exceptions;
import org.glassfish.gmbal.impl.ManagedObjectManagerInternal;
import org.glassfish.gmbal.impl.TypeConverter;
import org.glassfish.gmbal.impl.trace.TraceRuntime;
import org.glassfish.gmbal.typelib.EvaluatedAccessibleDeclaration;
import org.glassfish.gmbal.typelib.EvaluatedDeclaration;
import org.glassfish.gmbal.typelib.EvaluatedFieldDeclaration;
import org.glassfish.gmbal.typelib.EvaluatedMethodDeclaration;
import org.glassfish.gmbal.typelib.EvaluatedType;
import org.glassfish.pfl.basic.algorithm.DumpToString;
import org.glassfish.pfl.basic.contain.Pair;
import org.glassfish.pfl.basic.facet.FacetAccessor;

public class AttributeDescriptor {
    @DumpToString
    private EvaluatedAccessibleDeclaration _decl;
    private String _id;
    private String _description;
    private AttributeType _atype;
    @DumpToString
    private EvaluatedType _type;
    private TypeConverter _tc;
    private static final Permission accessControlPermission = new ReflectPermission("suppressAccessChecks");

    private AttributeDescriptor(ManagedObjectManagerInternal mom, final EvaluatedAccessibleDeclaration decl, String id, String description, AttributeType atype, EvaluatedType type) {
        this._decl = AccessController.doPrivileged(new PrivilegedAction<EvaluatedAccessibleDeclaration>(){

            @Override
            public EvaluatedAccessibleDeclaration run() {
                decl.accessible().setAccessible(true);
                return decl;
            }
        });
        this._id = id;
        this._description = description;
        this._atype = atype;
        this._type = type;
        this._tc = mom.getTypeConverter(type);
    }

    public final AccessibleObject accessible() {
        return this._decl.accessible();
    }

    public final String id() {
        return this._id;
    }

    public final String description() {
        return this._description;
    }

    public final AttributeType atype() {
        return this._atype;
    }

    public final EvaluatedType type() {
        return this._type;
    }

    public final TypeConverter tc() {
        return this._tc;
    }

    public boolean isApplicable(Object obj) {
        if (this._decl instanceof EvaluatedMethodDeclaration) {
            EvaluatedMethodDeclaration em = (EvaluatedMethodDeclaration)this._decl;
            return em.method().getDeclaringClass().isInstance(obj);
        }
        if (this._decl instanceof EvaluatedFieldDeclaration) {
            EvaluatedFieldDeclaration ef = (EvaluatedFieldDeclaration)this._decl;
            return ef.field().getDeclaringClass().isInstance(obj);
        }
        return false;
    }

    private void checkType(AttributeType at) {
        if (at != this._atype) {
            throw Exceptions.self.excForCheckType(at);
        }
    }

    @TraceRuntime
    public Object get(FacetAccessor fa) throws MBeanException, ReflectionException {
        this.checkType(AttributeType.GETTER);
        Object result = null;
        if (this._decl instanceof EvaluatedMethodDeclaration) {
            EvaluatedMethodDeclaration em = (EvaluatedMethodDeclaration)this._decl;
            result = this._tc.toManagedEntity(fa.invoke(em.method(), new Object[0]));
        } else if (this._decl instanceof EvaluatedFieldDeclaration) {
            EvaluatedFieldDeclaration ef = (EvaluatedFieldDeclaration)this._decl;
            result = this._tc.toManagedEntity(fa.get(ef.field()));
        } else {
            Exceptions.self.unknownDeclarationType(this._decl);
        }
        return result;
    }

    @TraceRuntime
    public void set(FacetAccessor target, Object value) throws MBeanException, ReflectionException {
        this.checkType(AttributeType.SETTER);
        if (this._decl instanceof EvaluatedMethodDeclaration) {
            EvaluatedMethodDeclaration em = (EvaluatedMethodDeclaration)this._decl;
            target.invoke(em.method(), this._tc.fromManagedEntity(value));
        } else if (this._decl instanceof EvaluatedFieldDeclaration) {
            EvaluatedFieldDeclaration ef = (EvaluatedFieldDeclaration)this._decl;
            target.set(ef.field(), this._tc.fromManagedEntity(value));
        } else {
            Exceptions.self.unknownDeclarationType(this._decl);
        }
    }

    private static boolean startsWithNotEquals(String str, String prefix) {
        return str.startsWith(prefix) && !str.equals(prefix);
    }

    private static String stripPrefix(String str, String prefix) {
        return str.substring(prefix.length());
    }

    private static String lowerInitialCharacter(String arg) {
        if (arg == null || arg.length() == 0) {
            return arg;
        }
        char initChar = Character.toLowerCase(arg.charAt(0));
        String rest = arg.substring(1);
        return initChar + rest;
    }

    private static String getDerivedId(String methodName, Pair<AttributeType, EvaluatedType> ainfo, ManagedObjectManagerInternal.AttributeDescriptorType adt) {
        boolean needLowerCase;
        String result = methodName;
        boolean bl = needLowerCase = adt == ManagedObjectManagerInternal.AttributeDescriptorType.COMPOSITE_DATA_ATTR;
        if (ainfo.first() == AttributeType.GETTER) {
            if (AttributeDescriptor.startsWithNotEquals(methodName, "get")) {
                result = AttributeDescriptor.stripPrefix(methodName, "get");
                if (needLowerCase) {
                    result = AttributeDescriptor.lowerInitialCharacter(result);
                }
            } else if (ainfo.second().equals(EvaluatedType.EBOOLEAN) && AttributeDescriptor.startsWithNotEquals(methodName, "is")) {
                result = AttributeDescriptor.stripPrefix(methodName, "is");
                if (needLowerCase) {
                    result = AttributeDescriptor.lowerInitialCharacter(result);
                }
            }
        } else if (AttributeDescriptor.startsWithNotEquals(methodName, "set")) {
            result = AttributeDescriptor.stripPrefix(methodName, "set");
            if (needLowerCase) {
                result = AttributeDescriptor.lowerInitialCharacter(result);
            }
        }
        return result;
    }

    private static Pair<AttributeType, EvaluatedType> getTypeInfo(EvaluatedDeclaration decl) {
        EvaluatedType evalType = null;
        AttributeType atype = null;
        if (decl instanceof EvaluatedMethodDeclaration) {
            EvaluatedMethodDeclaration method = (EvaluatedMethodDeclaration)decl;
            List<EvaluatedType> atypes = method.parameterTypes();
            if (method.returnType().equals(EvaluatedType.EVOID)) {
                if (atypes.size() != 1) {
                    return null;
                }
                atype = AttributeType.SETTER;
                evalType = atypes.get(0);
            } else {
                if (atypes.size() != 0) {
                    return null;
                }
                atype = AttributeType.GETTER;
                evalType = method.returnType();
            }
        } else if (decl instanceof EvaluatedFieldDeclaration) {
            EvaluatedFieldDeclaration field = (EvaluatedFieldDeclaration)decl;
            evalType = field.fieldType();
            atype = AttributeType.GETTER;
        } else {
            Exceptions.self.unknownDeclarationType(decl);
        }
        return new Pair<AttributeType, EvaluatedType>(atype, evalType);
    }

    private static boolean empty(String arg) {
        return arg == null || arg.length() == 0;
    }

    public static AttributeDescriptor makeFromInherited(ManagedObjectManagerInternal mom, EvaluatedMethodDeclaration method, String id, String methodName, String description, ManagedObjectManagerInternal.AttributeDescriptorType adt) {
        if (AttributeDescriptor.empty(methodName) && AttributeDescriptor.empty(id)) {
            throw Exceptions.self.excForMakeFromInherited();
        }
        Pair<AttributeType, EvaluatedType> ainfo = AttributeDescriptor.getTypeInfo(method);
        if (ainfo == null) {
            return null;
        }
        String derivedId = AttributeDescriptor.getDerivedId(method.name(), ainfo, adt);
        if (AttributeDescriptor.empty(methodName) ? !derivedId.equals(id) : !methodName.equals(method.name())) {
            return null;
        }
        String actualId = AttributeDescriptor.empty(id) ? derivedId : id;
        return new AttributeDescriptor(mom, method, actualId, description, ainfo.first(), ainfo.second());
    }

    public static AttributeDescriptor makeFromAnnotated(ManagedObjectManagerInternal mom, EvaluatedAccessibleDeclaration decl, String extId, String description, ManagedObjectManagerInternal.AttributeDescriptorType adt) {
        String actualId;
        Pair<AttributeType, EvaluatedType> ainfo = AttributeDescriptor.getTypeInfo(decl);
        if (ainfo == null) {
            throw Exceptions.self.excForMakeFromAnnotated(decl);
        }
        String string2 = actualId = AttributeDescriptor.empty(extId) ? AttributeDescriptor.getDerivedId(decl.name(), ainfo, adt) : extId;
        if (mom.isAMXAttributeName(actualId)) {
            throw Exceptions.self.duplicateAMXFieldName(actualId, decl.name(), decl.containingClass().name());
        }
        return new AttributeDescriptor(mom, decl, actualId, description, ainfo.first(), ainfo.second());
    }

    public static enum AttributeType {
        SETTER,
        GETTER;

    }
}

