/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.api.execute;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.gradle.ProjectTrust;
import org.netbeans.modules.gradle.actions.ActionToTaskUtils;
import org.netbeans.modules.gradle.api.GradleBaseProject;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.netbeans.modules.gradle.api.execute.ActionMapping;
import org.netbeans.modules.gradle.api.execute.Bundle;
import org.netbeans.modules.gradle.api.execute.GradleCommandLine;
import org.netbeans.modules.gradle.api.execute.GradleDistributionManager;
import org.netbeans.modules.gradle.api.execute.GradleExecConfiguration;
import org.netbeans.modules.gradle.api.execute.RunConfig;
import org.netbeans.modules.gradle.execute.ConfigurableActionProvider;
import org.netbeans.modules.gradle.execute.GradleDaemonExecutor;
import org.netbeans.modules.gradle.execute.GradleExecutor;
import org.netbeans.modules.gradle.execute.ProjectConfigurationSupport;
import org.netbeans.modules.gradle.execute.ProxyNonSelectableInputOutput;
import org.netbeans.modules.gradle.options.GradleExperimentalSettings;
import org.netbeans.modules.gradle.spi.GradleSettings;
import org.netbeans.modules.gradle.spi.actions.ProjectActionMappingProvider;
import org.netbeans.modules.gradle.spi.actions.ReplaceTokenProvider;
import org.netbeans.modules.gradle.spi.execute.GradleDistributionProvider;
import org.netbeans.modules.gradle.spi.execute.JavaRuntimeManager;
import org.netbeans.spi.project.AuxiliaryProperties;
import org.netbeans.spi.project.SingleMethod;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.LifecycleManager;
import org.openide.NotifyDescriptor;
import org.openide.execution.ExecutionEngine;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.BaseUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Pair;
import org.openide.windows.IOColorPrint;
import org.openide.windows.IOColors;
import org.openide.windows.InputOutput;

public final class RunUtils {
    private static final Logger LOG = Logger.getLogger(RunUtils.class.getName());
    public static final String PROP_JDK_PLATFORM = "jdkPlatform";
    public static final String PROP_COMPILE_ON_SAVE = "compile.on.save";
    public static final String PROP_AUGMENTED_BUILD = "augmented.build";
    public static final String PROP_INCLUDE_OPEN_PROJECTS = "include.open.projects";
    public static final String PROP_DEFAULT_CLI = "gradle.cli";
    private static final Map<RunConfig, GradleExecutor> GRADLE_TASKS = new WeakHashMap<RunConfig, GradleExecutor>();
    static Function<RunConfig, GradleExecutor> EXECUTOR_FACTORY = GradleDaemonExecutor::new;
    private static final String OPTION_MESSAGE_PREFIX = "TrustProjectPanel.";
    private static final String BRANDING_API_PREFIX = "org.netbeans.modules.gradle.api.execute.TrustProjectOption.";
    private static final List<String> TRUST_DIALOG_OPTION_IDS = Arrays.asList("TrustOnce", "PermanentTrust", "RunAlways");

    private RunUtils() {
    }

    public static FileObject extractFileObjectfromLookup(Lookup lookup) {
        FileObject[] fos = RunUtils.extractFileObjectsfromLookup(lookup);
        return fos.length > 0 ? fos[0] : null;
    }

    public static FileObject[] extractFileObjectsfromLookup(Lookup lookup) {
        ArrayList<FileObject> files = new ArrayList<FileObject>();
        for (DataObject d : lookup.lookupAll(DataObject.class)) {
            FileObject f = d.getPrimaryFile();
            files.add(f);
        }
        Collection methods = lookup.lookupAll(SingleMethod.class);
        if (methods.size() == 1) {
            SingleMethod method = (SingleMethod)methods.iterator().next();
            files.add(method.getFile());
        }
        if (files.isEmpty()) {
            files.addAll(lookup.lookupAll(FileObject.class));
        }
        return files.toArray(new FileObject[0]);
    }

    public static ExecutorTask executeGradle(RunConfig config, String initialOutput) {
        LifecycleManager.getDefault().saveAll();
        if (config.getExecConfig() == null) {
            config = new RunConfig(config.getProject(), config.getActionName(), config.getTaskDisplayName(), config.getExecFlags(), config.getCommandLine(), ProjectConfigurationSupport.getEffectiveConfiguration(config.getProject(), Lookup.EMPTY));
        }
        GradleExecutor exec = EXECUTOR_FACTORY.apply(config);
        ExecutorTask task = RunUtils.executeGradleImpl(config.getTaskDisplayName(), exec, initialOutput);
        GRADLE_TASKS.put(config, exec);
        return exec.createTask(task);
    }

    public static RunConfig createRunConfig(Project project, String action, String displayName, Set<RunConfig.ExecFlag> flags, String ... args) {
        return RunUtils.createRunConfig(project, action, displayName, Lookup.EMPTY, ProjectConfigurationSupport.getEffectiveConfiguration(project, Lookup.EMPTY), flags, args);
    }

    public static RunConfig createRunConfig(Project project, String action, String displayName, Lookup context, GradleExecConfiguration cfg, Set<RunConfig.ExecFlag> flags, String ... args) {
        if (cfg == null) {
            cfg = ProjectConfigurationSupport.getEffectiveConfiguration(project, context);
        }
        GradleBaseProject gbp = GradleBaseProject.get(project);
        GradleCommandLine syscmd = GradleCommandLine.getDefaultCommandLine();
        GradleCommandLine prjcmd = RunUtils.getDefaultCommandLine(project);
        GradleCommandLine basecmd = syscmd;
        if (prjcmd != null) {
            basecmd = GradleCommandLine.combine(syscmd, prjcmd);
        }
        if (RunUtils.isIncludeOpenProjectsEnabled(project)) {
            GradleCommandLine include = RunUtils.getIncludedOpenProjects(project);
            basecmd = GradleCommandLine.combine(basecmd, include);
        }
        RunUtils.validateExclude(basecmd, gbp, "test");
        RunUtils.validateExclude(basecmd, gbp, "check");
        GradleCommandLine cmd = GradleCommandLine.combine(basecmd, new GradleCommandLine(args));
        RunConfig ret = new RunConfig(project, action, displayName, flags, cmd, cfg);
        return ret;
    }

    public static ActionMapping findActionMapping(Project project, String action, GradleExecConfiguration cfg) {
        return ActionToTaskUtils.getActiveMapping(action, project, cfg);
    }

    public static RunConfig createRunConfigForAction(Project project, String action, String displayName, Lookup context, GradleExecConfiguration cfg, Set<RunConfig.ExecFlag> flags, boolean allowDisabled, String ... args) {
        NbGradleProject gp = NbGradleProject.get(project);
        GradleExecConfiguration execCfg = ProjectConfigurationSupport.getEffectiveConfiguration(project, context);
        return ProjectConfigurationSupport.executeWithConfiguration(project, execCfg, () -> {
            ActionMapping mapping = ActionToTaskUtils.getActiveMapping(action, project, execCfg);
            if (ActionMapping.isDisabled(mapping) && !allowDisabled) {
                return null;
            }
            if (!ActionToTaskUtils.isActionEnabled(action, mapping, project, context) && !allowDisabled) {
                return null;
            }
            String argLine = mapping.getArgs();
            StringWriter writer = new StringWriter();
            PrintWriter out = new PrintWriter(writer);
            String[] evalArgs = RunUtils.evaluateActionArgs(project, action, argLine, Lookup.EMPTY);
            return RunUtils.createRunConfig(project, action, displayName, Lookup.EMPTY, execCfg, flags, evalArgs);
        });
    }

    @Deprecated
    public static RunConfig createRunConfig(Project project, String action, String displayName, String[] args) {
        return RunUtils.createRunConfig(project, action, displayName, EnumSet.of(RunConfig.ExecFlag.REPEATABLE), args);
    }

    public static boolean cancelGradle(RunConfig config) {
        GradleExecutor exec = GRADLE_TASKS.get(config);
        return exec != null ? exec.cancel() : false;
    }

    public static GradleDistributionManager.GradleDistribution getCompatibleGradleDistribution(Project prj) {
        GradleDistributionProvider pvd = (GradleDistributionProvider)prj.getLookup().lookup(GradleDistributionProvider.class);
        GradleDistributionManager.GradleDistribution ret = pvd != null ? pvd.getGradleDistribution() : GradleDistributionManager.get().defaultDistribution();
        ret = ret != null ? ret : GradleDistributionManager.get().defaultDistribution();
        ret = ret.isCompatibleWithSystemJava() ? ret : GradleDistributionManager.get().defaultDistribution();
        return ret;
    }

    private static ExecutorTask executeGradleImpl(String runtimeName, GradleExecutor exec, String initialOutput) {
        InputOutput io = exec.getInputOutput();
        ExecutorTask task = ExecutionEngine.getDefault().execute(runtimeName, (Runnable)exec, (InputOutput)new ProxyNonSelectableInputOutput(io));
        if (initialOutput != null) {
            try {
                if (IOColorPrint.isSupported((InputOutput)io) && IOColors.isSupported((InputOutput)io)) {
                    IOColorPrint.print((InputOutput)io, (CharSequence)initialOutput, (Color)IOColors.getColor((InputOutput)io, (IOColors.OutputType)IOColors.OutputType.LOG_DEBUG));
                } else {
                    io.getOut().println(initialOutput);
                }
            }
            catch (IOException ex) {
                LOG.log(Level.WARNING, "Can't write initial output: " + initialOutput, ex);
            }
        }
        exec.setTask(task);
        return task;
    }

    @Deprecated
    public static boolean isCompileOnSaveEnabled(Project project) {
        return RunUtils.isOptionEnabled(project, PROP_COMPILE_ON_SAVE, false);
    }

    public static boolean isAugmentedBuildEnabled(Project project) {
        return RunUtils.isOptionEnabled(project, PROP_AUGMENTED_BUILD, true);
    }

    public static boolean isIncludeOpenProjectsEnabled(Project project) {
        return RunUtils.isOptionEnabled(project, PROP_INCLUDE_OPEN_PROJECTS, false);
    }

    public static boolean isProjectTrusted(Project project, boolean interactive) {
        boolean ret;
        boolean bl = ret = GradleSettings.getDefault().getGradleExecutionRule() == GradleSettings.GradleExecutionRule.ALWAYS || ProjectTrust.getDefault().isTrusted(project);
        if (!ret && interactive) {
            Boolean q = RunUtils.askToTrustProject(project);
            if (Boolean.FALSE == q) {
                return false;
            }
            ProjectTrust.getDefault().trustProject(project, Boolean.TRUE == q);
            ret = true;
        }
        return ret;
    }

    private static Boolean askToTrustProject(Project project) {
        ProjectInformation info = project != null ? (ProjectInformation)project.getLookup().lookup(ProjectInformation.class) : null;
        String permanentOption = Bundle.TrustProjectPanel_PermanentTrust();
        String runAlways = Bundle.TrustProjectPanel_RunAlways();
        String ok = Bundle.TrustProjectPanel_TrustOnce();
        String msg = info == null ? Bundle.TrustProjectPanel_INFO_UNKNOWN() : Bundle.TrustProjectPanel_INFO(info.getDisplayName());
        Pair<Object[], Object> opts = RunUtils.brandedOptions(info != null);
        Object[] options = (Object[])opts.first();
        Object defaultOption = opts.second();
        NotifyDescriptor dsc = new NotifyDescriptor((Object)msg, Bundle.ProjectTrustDlg_TITLE(), 2, 3, options, defaultOption);
        Object result = DialogDisplayer.getDefault().notify(dsc);
        if (result == runAlways) {
            GradleSettings.getDefault().setGradleExecutionRule(GradleSettings.GradleExecutionRule.ALWAYS);
            return null;
        }
        if (result == ok) {
            return null;
        }
        if (result == permanentOption) {
            return true;
        }
        return false;
    }

    private static Pair<Object[], Object> brandedOptions(boolean allowPermanent) {
        HashMap<String, Integer> options = new HashMap<String, Integer>();
        String def = null;
        for (String opt : TRUST_DIALOG_OPTION_IDS) {
            int pos;
            String m;
            block6: {
                if (opt == TRUST_DIALOG_OPTION_IDS.get(2) && !allowPermanent) continue;
                String key = BRANDING_API_PREFIX + opt;
                try {
                    m = NbBundle.getMessage(RunUtils.class, (String)(OPTION_MESSAGE_PREFIX + opt));
                    String v = NbBundle.getMessage(RunUtils.class, (String)key);
                    if ("".equals(v) || (pos = Integer.parseInt(v)) == 0) continue;
                    if (pos >= 0) break block6;
                    def = m;
                    pos = -pos;
                }
                catch (MissingResourceException ex) {
                    continue;
                }
                catch (IllegalArgumentException ex) {
                    continue;
                }
            }
            if (def == null) {
                def = m;
            }
            options.put(m, pos);
        }
        if (options.isEmpty()) {
            return Pair.of((Object)new Object[]{Bundle.TrustProjectPanel_TrustOnce(), Bundle.TrustProjectPanel_PermanentTrust(), DialogDescriptor.CANCEL_OPTION}, (Object)Bundle.TrustProjectPanel_TrustOnce());
        }
        ArrayList ordered = new ArrayList(options.keySet());
        ordered.sort((a, b) -> (Integer)options.get(a) - (Integer)options.get(b));
        ordered.add(DialogDescriptor.CANCEL_OPTION);
        return Pair.of((Object)ordered.toArray(new Object[0]), def);
    }

    public static GradleCommandLine getDefaultCommandLine(Project project) {
        String args = NbGradleProject.getPreferences(project, true).get(PROP_DEFAULT_CLI, null);
        return args != null ? new GradleCommandLine((CharSequence)args) : null;
    }

    @Deprecated
    public static File evaluateGradleDistribution(Project project, boolean forceCompatibility) {
        GradleDistributionManager.GradleDistribution dist;
        GradleDistributionProvider pvd = project != null ? (GradleDistributionProvider)project.getLookup().lookup(GradleDistributionProvider.class) : null;
        GradleDistributionManager.GradleDistribution gradleDistribution = dist = pvd != null ? pvd.getGradleDistribution() : null;
        if (dist != null && (dist.isCompatibleWithSystemJava() || !forceCompatibility)) {
            return dist.getDistributionDir();
        }
        GradleSettings settings = GradleSettings.getDefault();
        dist = GradleDistributionManager.get(dist != null ? dist.getGradleUserHome() : settings.getGradleUserHome()).defaultDistribution();
        return dist.getDistributionDir();
    }

    private static boolean isOptionEnabled(Project project, String option, boolean defaultValue) {
        Project root = ProjectUtils.rootOf((Project)project);
        GradleBaseProject gbp = GradleBaseProject.get(root);
        if (gbp != null) {
            String value = gbp.getNetBeansProperty(option);
            if (value != null) {
                return Boolean.valueOf(value);
            }
            return NbGradleProject.getPreferences(root, false).getBoolean(option, defaultValue);
        }
        return false;
    }

    public static String[] evaluateActionArgs(Project project, String action, String argLine, Lookup context) {
        ReplaceTokenProvider tokenProvider = (ReplaceTokenProvider)project.getLookup().lookup(ReplaceTokenProvider.class);
        String repLine = ReplaceTokenProvider.replaceTokens(argLine, tokenProvider.createReplacements(action, context));
        return BaseUtilities.parseParameters((String)repLine);
    }

    private static void validateExclude(GradleCommandLine cmd, GradleBaseProject gbp, String task) {
        boolean exclude = gbp.getTaskNames().contains(task) || gbp.isRoot() && !gbp.getSubProjects().isEmpty();
        if (exclude &= cmd.getExcludedTasks().contains(task) && !cmd.getTasks().contains(task)) {
            cmd.addParameter(GradleCommandLine.Parameter.EXCLUDE_TASK, task);
        } else {
            cmd.removeParameter(GradleCommandLine.Parameter.EXCLUDE_TASK, task);
        }
    }

    public static ReplaceTokenProvider simpleReplaceTokenProvider(final String token, final String value) {
        return new ReplaceTokenProvider(){

            @Override
            public Set<String> getSupportedTokens() {
                return Collections.singleton(token);
            }

            @Override
            public Map<String, String> createReplacements(String action, Lookup context) {
                return Collections.singletonMap(token, value);
            }
        };
    }

    public static ProjectActionMappingProvider findActionProvider(Project p, Lookup context) {
        ConfigurableActionProvider cap = (ConfigurableActionProvider)p.getLookup().lookup(ConfigurableActionProvider.class);
        if (cap == null) {
            return (ProjectActionMappingProvider)p.getLookup().lookup(ProjectActionMappingProvider.class);
        }
        GradleExecConfiguration cfg = ProjectConfigurationSupport.getEffectiveConfiguration(p, context);
        return cap.findActionProvider(cfg.getId());
    }

    @Deprecated
    public static Pair getActivePlatform(String activePlatformId) {
        return Pair.of((Object)activePlatformId, null);
    }

    @Deprecated
    public static Pair getActivePlatform(Project project) {
        return RunUtils.getActivePlatform("deprecated");
    }

    public static JavaRuntimeManager.JavaRuntime getActiveRuntime(Project project) {
        return (JavaRuntimeManager.JavaRuntime)ProjectManager.mutex().readAccess(() -> {
            GradleExperimentalSettings experimental = GradleExperimentalSettings.getDefault();
            Project root = ProjectUtils.rootOf((Project)project);
            AuxiliaryProperties aux = (AuxiliaryProperties)root.getLookup().lookup(AuxiliaryProperties.class);
            String id = aux.get("hint.jdkPlatform", true);
            if (id == null) {
                return experimental.getDefaultJavaRuntime();
            }
            JavaRuntimeManager mgr = (JavaRuntimeManager)Lookup.getDefault().lookup(JavaRuntimeManager.class);
            Map<String, JavaRuntimeManager.JavaRuntime> runtimes = mgr.getAvailableRuntimes();
            if (runtimes.containsKey(id)) {
                return runtimes.get(id);
            }
            return JavaRuntimeManager.createJavaRuntime(id, null);
        });
    }

    public static void setActiveRuntime(Project project, JavaRuntimeManager.JavaRuntime runtime) {
        ProjectManager.mutex().postWriteRequest(() -> {
            GradleExperimentalSettings experimental = GradleExperimentalSettings.getDefault();
            Project root = ProjectUtils.rootOf((Project)project);
            AuxiliaryProperties aux = (AuxiliaryProperties)root.getLookup().lookup(AuxiliaryProperties.class);
            String id = runtime != null && experimental.getDefaultJavaRuntime() != runtime ? runtime.getId() : null;
            aux.put("hint.jdkPlatform", id, true);
        });
    }

    static GradleCommandLine getIncludedOpenProjects(Project project) {
        GradleCommandLine ret = new GradleCommandLine(new String[0]);
        HashSet<File> openRoots = new HashSet<File>();
        for (Project openProject : OpenProjects.getDefault().getOpenProjects()) {
            GradleBaseProject gpb = GradleBaseProject.get(openProject);
            if (gpb == null) continue;
            openRoots.add(gpb.getRootDir());
        }
        GradleBaseProject gbp = GradleBaseProject.get(project);
        if (gbp != null) {
            openRoots.remove(gbp.getRootDir());
            openRoots.removeAll(gbp.getIncludedBuilds().values());
            Path projectPath = gbp.getProjectDir().toPath();
            for (File openRoot : openRoots) {
                Path root = openRoot.toPath();
                String ib = root.toString();
                try {
                    Path rel = projectPath.relativize(root);
                    if (rel.getNameCount() < root.getNameCount()) {
                        ib = rel.toString();
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                ret.addParameter(GradleCommandLine.Parameter.INCLUDE_BUILD, ib);
            }
        }
        return ret;
    }
}

