/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.execute;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.api.execute.GradleExecConfiguration;
import org.netbeans.spi.project.ProjectConfigurationProvider;
import org.openide.util.Lookup;

public final class ProjectConfigurationSupport {
    private static final ThreadLocal<Map<Project, GradleExecConfiguration>> selectedConfigs = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T executeWithConfiguration(Project project, GradleExecConfiguration c, Supplier<T> task) {
        ProjectConfigurationProvider pcp = (ProjectConfigurationProvider)project.getLookup().lookup(ProjectConfigurationProvider.class);
        if (pcp == null) {
            return task.get();
        }
        Map<Project, GradleExecConfiguration> m = selectedConfigs.get();
        try {
            HashMap<Project, GradleExecConfiguration> n = m == null ? new HashMap<Project, GradleExecConfiguration>() : new HashMap<Project, GradleExecConfiguration>(m);
            n.put(project, c);
            selectedConfigs.set(n);
            T t = task.get();
            return t;
        }
        finally {
            selectedConfigs.set(m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeWithConfiguration(Project project, GradleExecConfiguration c, Runnable task) {
        ProjectConfigurationProvider pcp = (ProjectConfigurationProvider)project.getLookup().lookup(ProjectConfigurationProvider.class);
        if (pcp == null) {
            task.run();
            return;
        }
        Map<Project, GradleExecConfiguration> m = selectedConfigs.get();
        try {
            HashMap<Project, GradleExecConfiguration> n = m == null ? new HashMap<Project, GradleExecConfiguration>() : new HashMap<Project, GradleExecConfiguration>(m);
            n.put(project, c);
            selectedConfigs.set(n);
            task.run();
        }
        finally {
            selectedConfigs.set(m);
        }
    }

    @CheckForNull
    public static GradleExecConfiguration getExplicitConfiguration(@NonNull Project p, @NullAllowed Lookup context) {
        Map<Project, GradleExecConfiguration> m = selectedConfigs.get();
        if (m == null) {
            return context != null ? (GradleExecConfiguration)context.lookup(GradleExecConfiguration.class) : null;
        }
        return m.get(p);
    }

    public static GradleExecConfiguration getEffectiveConfiguration(Project p, Lookup context) {
        GradleExecConfiguration c = ProjectConfigurationSupport.getExplicitConfiguration(p, context);
        if (c != null) {
            return c;
        }
        ProjectConfigurationProvider pcp = (ProjectConfigurationProvider)p.getLookup().lookup(ProjectConfigurationProvider.class);
        if (pcp == null) {
            return null;
        }
        return (GradleExecConfiguration)pcp.getActiveConfiguration();
    }
}

