/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JSeparator;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.libraries.LibrariesCustomizer;
import org.netbeans.modules.j2ee.persistence.provider.DefaultProvider;
import org.netbeans.modules.j2ee.persistence.provider.Provider;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.spi.provider.PersistenceProviderSupplier;
import org.netbeans.modules.j2ee.persistence.wizard.Util;
import org.netbeans.modules.j2ee.persistence.wizard.library.PersistenceLibraryCustomizer;
import org.netbeans.modules.j2ee.persistence.wizard.library.PersistenceLibrarySupport;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;

public final class PersistenceProviderComboboxHelper {
    private static final String SEPARATOR = "PersistenceProviderComboboxHelper.SEPARATOR";
    private static final String EMPTY = "PersistenceProviderComboboxHelper.EMPTY";
    private static final Provider preferredProvider = ProviderUtil.ECLIPSELINK_PROVIDER3_1;
    private final PersistenceProviderSupplier providerSupplier;
    private final Project project;

    public PersistenceProviderComboboxHelper(Project project) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        PersistenceProviderSupplier aProviderSupplier = (PersistenceProviderSupplier)project.getLookup().lookup(PersistenceProviderSupplier.class);
        if (aProviderSupplier == null) {
            aProviderSupplier = new DefaultPersistenceProviderSupplier(project);
        }
        this.project = project;
        this.providerSupplier = aProviderSupplier;
    }

    public void connect(final JComboBox providerCombo) {
        providerCombo.setEditable(false);
        this.initCombo(providerCombo);
        providerCombo.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ PersistenceProviderComboboxHelper this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void keyPressed(KeyEvent e) {
                Object selectedItem;
                int keyCode = e.getKeyCode();
                if (10 == keyCode && (selectedItem = providerCombo.getSelectedItem()) instanceof LibraryItem) {
                    providerCombo.hidePopup();
                    ((LibraryItem)selectedItem).performAction();
                    e.consume();
                    this.this$0.initCombo(providerCombo);
                }
            }
        });
        providerCombo.addActionListener(new ActionListener(){
            private Object currentItem;
            private int currentIndex;
            final /* synthetic */ PersistenceProviderComboboxHelper this$0;
            {
                this.this$0 = this$0;
                this.currentItem = providerCombo.getSelectedItem();
                this.currentIndex = providerCombo.getSelectedIndex();
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                Object selectedItem = providerCombo.getSelectedItem();
                if (PersistenceProviderComboboxHelper.SEPARATOR.equals(selectedItem)) {
                    int selectedIndex = providerCombo.getSelectedIndex();
                    if (selectedIndex > this.currentIndex) {
                        this.currentIndex = selectedIndex + 1;
                        this.currentItem = providerCombo.getItemAt(this.currentIndex);
                    } else {
                        this.currentIndex = selectedIndex - 1;
                        this.currentItem = providerCombo.getItemAt(this.currentIndex);
                    }
                    providerCombo.setSelectedItem(this.currentItem);
                } else if ((e.getModifiers() & 0x10) != 0) {
                    if (selectedItem instanceof LibraryItem) {
                        providerCombo.setPopupVisible(false);
                        ((LibraryItem)selectedItem).performAction();
                        this.this$0.initCombo(providerCombo);
                    }
                } else {
                    this.currentItem = selectedItem;
                    this.currentIndex = providerCombo.getSelectedIndex();
                }
            }
        });
    }

    private void initCombo(JComboBox providerCombo) {
        DefaultComboBoxModel<Object> providers = new DefaultComboBoxModel<Object>();
        for (Provider each : this.providerSupplier.getSupportedProviders()) {
            providers.addElement(each);
        }
        if (providers.getSize() == 0 && this.providerSupplier.supportsDefaultProvider()) {
            providers.addElement(ProviderUtil.DEFAULT_PROVIDER);
        }
        if (providers.getSize() == 0) {
            providers.addElement(EMPTY);
        }
        providerCombo.setModel(providers);
        providerCombo.addItem(SEPARATOR);
        providerCombo.addItem(new NewPersistenceLibraryItem());
        providerCombo.addItem(new ManageLibrariesItem());
        providerCombo.setRenderer(new PersistenceProviderCellRenderer(this.getDefaultProvider(providers)));
        int selectIndex = 0;
        if (providers.getSize() > 1 && providers.getElementAt(0) instanceof Provider) {
            boolean specialCase;
            String defProviderVersion = ProviderUtil.getVersion((Provider)providers.getElementAt(0));
            boolean bl = specialCase = !(!Util.isJPAVersionSupported(this.project, "2.0") && !Util.isJPAVersionSupported(this.project, "2.1") && !Util.isJPAVersionSupported(this.project, "2.2") && !Util.isJPAVersionSupported(this.project, "3.0") && !Util.isJPAVersionSupported(this.project, "3.1") && !Util.isJPAVersionSupported(this.project, "3.2") || defProviderVersion != null && !defProviderVersion.equals("1.0"));
            if (specialCase) {
                for (int i = 1; i < providers.getSize(); ++i) {
                    if (!preferredProvider.equals(providers.getElementAt(i))) continue;
                    selectIndex = i;
                    break;
                }
            }
        }
        providerCombo.setSelectedIndex(selectIndex);
    }

    private Provider getDefaultProvider(ComboBoxModel providers) {
        if (!this.providerSupplier.supportsDefaultProvider()) {
            return null;
        }
        if (providers.getElementAt(0) instanceof Provider) {
            return (Provider)providers.getElementAt(0);
        }
        return null;
    }

    private static class DefaultPersistenceProviderSupplier
    implements PersistenceProviderSupplier {
        private final Project project;

        public DefaultPersistenceProviderSupplier(Project project) {
            this.project = project;
        }

        @Override
        public List<Provider> getSupportedProviders() {
            ArrayList<Provider> providers = new ArrayList<Provider>();
            SourceGroup[] sourceGroups = ProjectUtils.getSources((Project)this.project).getSourceGroups("java");
            ArrayList<ClassPath> classPaths = new ArrayList<ClassPath>();
            if (sourceGroups != null) {
                for (SourceGroup sourceGroup : sourceGroups) {
                    ClassPath cp = ClassPath.getClassPath((FileObject)sourceGroup.getRootFolder(), (String)"classpath/compile");
                    classPaths.add(cp);
                }
            }
            ClassPath cp = ClassPathSupport.createProxyClassPath((ClassPath[])((ClassPath[])classPaths.toArray(ClassPath[]::new)));
            for (Provider p : ProviderUtil.getAllProviders()) {
                if (!p.isOnClassPath(cp) || providers.contains(p)) continue;
                providers.add(p);
            }
            for (Provider each : PersistenceLibrarySupport.getProvidersFromLibraries()) {
                if (providers.contains(each)) continue;
                providers.add(each);
            }
            return providers;
        }

        @Override
        public boolean supportsDefaultProvider() {
            return false;
        }
    }

    private static class NewPersistenceLibraryItem
    implements LibraryItem {
        private NewPersistenceLibraryItem() {
        }

        @Override
        public String getText() {
            return NbBundle.getMessage(PersistenceProviderComboboxHelper.class, (String)"LBL_NewPersistenceLibrary");
        }

        @Override
        public void performAction() {
            PersistenceLibraryCustomizer.showCustomizer();
        }
    }

    private static class ManageLibrariesItem
    implements LibraryItem {
        private ManageLibrariesItem() {
        }

        @Override
        public String getText() {
            return NbBundle.getMessage(PersistenceProviderComboboxHelper.class, (String)"LBL_ManageLibraries");
        }

        @Override
        public void performAction() {
            LibrariesCustomizer.showCustomizer(null);
        }
    }

    private static class PersistenceProviderCellRenderer
    extends DefaultListCellRenderer {
        Provider defaultProvider;

        PersistenceProviderCellRenderer(Provider defaultProvider) {
            this.defaultProvider = defaultProvider;
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            if (value instanceof Provider) {
                Provider provider = (Provider)value;
                String text = provider.getDisplayName();
                if (value.equals(this.defaultProvider) && !(value instanceof DefaultProvider)) {
                    text = text + NbBundle.getMessage(PersistenceProviderComboboxHelper.class, (String)"LBL_DEFAULT_PROVIDER");
                }
                this.setText(text);
            } else {
                if (PersistenceProviderComboboxHelper.SEPARATOR.equals(value)) {
                    JSeparator s = new JSeparator();
                    s.setPreferredSize(new Dimension(s.getWidth(), 1));
                    s.setForeground(Color.BLACK);
                    return s;
                }
                if (PersistenceProviderComboboxHelper.EMPTY.equals(value)) {
                    this.setText(" ");
                } else if (value instanceof LibraryItem) {
                    this.setText(((LibraryItem)value).getText());
                } else {
                    this.setText(value != null ? value.toString() : "");
                }
            }
            return this;
        }
    }

    public static interface LibraryItem {
        public String getText();

        public void performAction();
    }
}

