/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.wizard.unit;

import java.io.IOException;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.j2ee.core.api.support.wizard.Wizards;
import org.netbeans.modules.j2ee.persistence.dd.PersistenceUtils;
import org.netbeans.modules.j2ee.persistence.dd.persistence.model_3_2.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.provider.InvalidPersistenceXmlException;
import org.netbeans.modules.j2ee.persistence.provider.Provider;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.unit.PUDataObject;
import org.netbeans.modules.j2ee.persistence.wizard.Util;
import org.netbeans.modules.j2ee.persistence.wizard.library.PersistenceLibrarySupport;
import org.netbeans.modules.j2ee.persistence.wizard.unit.PersistenceUnitWizardDescriptor;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.util.NbBundle;

public class PersistenceUnitWizard
implements WizardDescriptor.ProgressInstantiatingIterator {
    private WizardDescriptor.Panel[] panels;
    private int index = 0;
    private Project project;
    private PersistenceUnitWizardDescriptor descriptor;
    private static final Logger LOG = Logger.getLogger(PersistenceUnitWizard.class.getName());

    public static PersistenceUnitWizard create() {
        return new PersistenceUnitWizard();
    }

    public String name() {
        return NbBundle.getMessage(PersistenceUnitWizard.class, (String)"LBL_WizardTitle");
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
    }

    public void removeChangeListener(ChangeListener l) {
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void uninitialize(WizardDescriptor wizard) {
    }

    public void initialize(WizardDescriptor wizard) {
        this.project = Templates.getProject((WizardDescriptor)wizard);
        this.descriptor = new PersistenceUnitWizardDescriptor(this.project);
        this.panels = new WizardDescriptor.Panel[]{this.descriptor};
        wizard.putProperty("NewFileWizard_Title", (Object)NbBundle.getMessage(PersistenceUnitWizard.class, (String)"Templates/Persistence/PersistenceUnit"));
        Wizards.mergeSteps((WizardDescriptor)wizard, (WizardDescriptor.Panel[])this.panels, null);
    }

    public Set instantiate() throws IOException {
        return null;
    }

    public Set instantiate(ProgressHandle handle) throws IOException {
        try {
            handle.start();
            Set set = this.instantiateWProgress(handle);
            return set;
        }
        finally {
            handle.finish();
        }
    }

    private Set instantiateWProgress(ProgressHandle handle) throws IOException {
        Library mLib;
        String provVersion;
        String version;
        org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit punit = null;
        PUDataObject pud = null;
        LOG.fine("Instantiating...");
        Library lib = null;
        boolean useModelgen = false;
        String modelGenLib = null;
        Provider selectedProvider = null;
        boolean libIsAdded = false;
        if (this.descriptor.isContainerManaged()) {
            selectedProvider = this.descriptor.getSelectedProvider();
            if (this.descriptor.isNonDefaultProviderEnabled() && (lib = PersistenceLibrarySupport.getLibrary(selectedProvider)) != null && !Util.isDefaultProvider(this.project, selectedProvider)) {
                handle.progress(NbBundle.getMessage(PersistenceUnitWizard.class, (String)"MSG_LoadLibs"));
                Util.addLibraryToProject(this.project, lib);
                modelGenLib = lib.getName() + "modelgen";
                selectedProvider = null;
                libIsAdded = true;
            }
            if (selectedProvider != null && selectedProvider.getAnnotationProcessor() != null) {
                if (lib == null) {
                    lib = PersistenceLibrarySupport.getLibrary(selectedProvider);
                }
                if (lib != null) {
                    Util.addLibraryToProject(this.project, lib, "classpath/processor");
                    modelGenLib = lib.getName() + "modelgen";
                }
            }
        } else {
            lib = PersistenceLibrarySupport.getLibrary(this.descriptor.getSelectedProvider());
            if (lib != null) {
                handle.progress(NbBundle.getMessage(PersistenceUnitWizard.class, (String)"MSG_LoadLibs"));
                Util.addLibraryToProject(this.project, lib);
                modelGenLib = lib.getName() + "modelgen";
                libIsAdded = true;
            }
            JDBCDriver[] driver = JDBCDriverManager.getDefault().getDrivers(this.descriptor.getPersistenceConnection().getDriverClass());
            PersistenceLibrarySupport.addDriver(this.project, driver[0]);
        }
        handle.progress(NbBundle.getMessage(PersistenceUnitWizard.class, (String)"MSG_CreatePU"));
        String string = version = lib != null && libIsAdded ? PersistenceUtils.getJPAVersion(lib) : PersistenceUtils.getJPAVersion(this.project);
        if (selectedProvider != null && version != null && (provVersion = ProviderUtil.getVersion(selectedProvider)) != null && Double.parseDouble(version) > Double.parseDouble(provVersion)) {
            version = provVersion;
        }
        if (version != null && this.descriptor.isContainerManaged()) {
            version = Util.getJPAVersionSupported(this.project, version);
        }
        try {
            LOG.fine("Retrieving PUDataObject");
            pud = ProviderUtil.getPUDataObject(this.project, version);
        }
        catch (InvalidPersistenceXmlException ipx) {
            LOG.log(Level.FINE, "Invalid persistence.xml: " + ipx.getPath(), ipx);
            return Collections.emptySet();
        }
        version = pud.getPersistence().getVersion();
        if (this.descriptor.isContainerManaged()) {
            LOG.fine("Creating a container managed PU");
            punit = "3.2".equals(version) ? new PersistenceUnit() : ("3.1".equals(version) ? new org.netbeans.modules.j2ee.persistence.dd.persistence.model_3_1.PersistenceUnit() : ("3.0".equals(version) ? new org.netbeans.modules.j2ee.persistence.dd.persistence.model_3_0.PersistenceUnit() : ("2.2".equals(version) ? new org.netbeans.modules.j2ee.persistence.dd.persistence.model_2_2.PersistenceUnit() : ("2.1".equals(version) ? new org.netbeans.modules.j2ee.persistence.dd.persistence.model_2_1.PersistenceUnit() : ("2.0".equals(version) ? new org.netbeans.modules.j2ee.persistence.dd.persistence.model_2_0.PersistenceUnit() : new org.netbeans.modules.j2ee.persistence.dd.persistence.model_1_0.PersistenceUnit())))));
            if (this.descriptor.getDatasource() != null && !"".equals(this.descriptor.getDatasource())) {
                if (this.descriptor.isJTA()) {
                    punit.setJtaDataSource(this.descriptor.getDatasource());
                } else {
                    punit.setNonJtaDataSource(this.descriptor.getDatasource());
                    punit.setTransactionType("RESOURCE_LOCAL");
                }
            }
            if (this.descriptor.isNonDefaultProviderEnabled()) {
                String providerClass = this.descriptor.getNonDefaultProvider();
                punit.setProvider(providerClass);
            }
        } else {
            LOG.fine("Creating an application managed PU");
            punit = ProviderUtil.buildPersistenceUnit(this.descriptor.getPersistenceUnitName(), this.descriptor.getSelectedProvider(), this.descriptor.getPersistenceConnection(), version);
            punit.setTransactionType("RESOURCE_LOCAL");
            if (!Util.isJavaSE(this.project)) {
                punit.setExcludeUnlistedClasses(false);
            }
        }
        boolean bl = useModelgen = !(punit instanceof org.netbeans.modules.j2ee.persistence.dd.persistence.model_1_0.PersistenceUnit);
        if (!Util.isJavaSE(this.project)) {
            punit.setExcludeUnlistedClasses(false);
        }
        punit.setName(this.descriptor.getPersistenceUnitName());
        ProviderUtil.setTableGeneration(punit, this.descriptor.getTableGeneration(), this.project);
        pud.addPersistenceUnit(punit);
        LOG.fine("Saving PUDataObject");
        pud.save();
        LOG.fine("Saved");
        if (useModelgen && modelGenLib != null && (mLib = LibraryManager.getDefault().getLibrary(modelGenLib)) != null) {
            Util.addLibraryToProject(this.project, mLib, "classpath/processor");
        }
        return Collections.singleton(pud.getPrimaryFile());
    }
}

