/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.tooling.admin;

import org.netbeans.modules.payara.tooling.admin.ProcessIOResult;
import org.netbeans.modules.payara.tooling.logging.Logger;
import org.netbeans.modules.payara.tooling.utils.LinkedList;
import org.netbeans.modules.payara.tooling.utils.StringPrefixTree;

public class ProcessIOContent {
    private static final Logger LOGGER = new Logger(ProcessIOContent.class);
    private final String prompt;
    private final LinkedList<Token> tokens;

    public ProcessIOContent(String prompt) {
        this.prompt = prompt;
        this.tokens = new LinkedList();
    }

    public ProcessIOContent() {
        this(null);
    }

    public String getPrompt() {
        return this.prompt;
    }

    public String getCurrentPrompt() {
        Token token = this.tokens.getCurrent();
        String tokenPrompt = token != null ? token.getPrompt() : null;
        return tokenPrompt != null ? tokenPrompt : this.prompt;
    }

    public void addOutput(String[] inputSuccess, String[] inputError) {
        this.tokens.addLast(new OutputToken(inputSuccess, inputError));
    }

    public void addOutput(String[] inputSuccess) {
        this.tokens.addLast(new OutputToken(inputSuccess, null));
    }

    public void addInput(String prompt, String[] input, String output) {
        this.tokens.addLast(new InputToken(prompt, input, output));
    }

    public void addInput(String prompt, String input, String output) {
        this.tokens.addLast(new InputToken(prompt, new String[]{input}, output));
    }

    public void addInput(String[] input, String output) {
        this.tokens.addLast(new InputToken(this.prompt, input, output));
    }

    public void addInput(String input, String output) {
        this.tokens.addLast(new InputToken(this.prompt, new String[]{input}, output));
    }

    public Token firstToken() {
        this.tokens.first();
        return this.tokens.getCurrent();
    }

    public Token nextToken() {
        return this.tokens.next() ? this.tokens.getCurrent() : null;
    }

    protected static abstract class Token {
        private final boolean[] matchSuccess;
        private final boolean[] matchError;
        private final StringPrefixTree<TreeNode> outputStrings;
        private final int maxLen;

        protected Token(String[] inputSuccess, String[] inputError) {
            short i;
            short lenSuccess = inputSuccess != null ? inputSuccess.length : (short)0;
            int lenError = inputError != null ? inputError.length : 0;
            int maxLenLocal = 0;
            this.matchSuccess = new boolean[lenSuccess];
            this.matchError = new boolean[lenError];
            this.outputStrings = new StringPrefixTree(false);
            for (i = 0; i < lenSuccess; i = (short)(i + 1)) {
                this.matchSuccess[i] = false;
                this.outputStrings.add(inputSuccess[i], new TreeNode(i, ProcessIOResult.SUCCESS));
                if (inputSuccess[i].length() <= maxLenLocal) continue;
                maxLenLocal = inputSuccess[i].length();
            }
            for (i = 0; i < lenError; i = (short)(i + 1)) {
                this.matchError[i] = false;
                this.outputStrings.add(inputError[i], new TreeNode(i, ProcessIOResult.ERROR));
                if (inputError[i].length() <= maxLenLocal) continue;
                maxLenLocal = inputError[i].length();
            }
            this.maxLen = maxLenLocal;
        }

        protected String getPrompt() {
            return null;
        }

        protected boolean isSuccess() {
            boolean success = true;
            for (int i = 0; i < this.matchSuccess.length; ++i) {
                success = success && this.matchSuccess[i];
            }
            return success;
        }

        protected boolean[] getMatchError() {
            return this.matchError;
        }

        protected StringPrefixTree<TreeNode> getOutputStrings() {
            return this.outputStrings;
        }

        protected int getMaxLen() {
            return this.maxLen;
        }

        protected ProcessIOResult match(CharSequence str, int offset) {
            TreeNode node = this.outputStrings.prefixMatch(str, offset);
            if (node != null) {
                switch (node.result) {
                    case SUCCESS: {
                        this.matchSuccess[((TreeNode)node).index.shortValue()] = true;
                        return this.isSuccess() ? ProcessIOResult.SUCCESS : ProcessIOResult.UNKNOWN;
                    }
                    case ERROR: {
                        this.matchError[((TreeNode)node).index.shortValue()] = true;
                        return ProcessIOResult.ERROR;
                    }
                }
            }
            return ProcessIOResult.UNKNOWN;
        }
    }

    protected static class OutputToken
    extends Token {
        protected OutputToken(String[] inputSuccess, String[] inputError) {
            super(inputSuccess, inputError);
        }
    }

    protected static class InputToken
    extends Token {
        private final String prompt;

        protected InputToken(String prompt, String[] input, String output) {
            super(input, null);
            this.prompt = prompt;
        }

        @Override
        protected String getPrompt() {
            return this.prompt;
        }
    }

    protected static class TreeNode {
        private final Short index;
        private final ProcessIOResult result;

        private TreeNode(Short index, ProcessIOResult result) {
            this.index = index;
            this.result = result;
        }
    }
}

