/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.assets.k8s;

import com.oracle.bmc.containerengine.ContainerEngineClient;
import com.oracle.bmc.containerengine.requests.CreateKubeconfigRequest;
import com.oracle.bmc.containerengine.responses.CreateKubeconfigResponse;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import org.netbeans.modules.cloud.oracle.OCIManager;
import org.netbeans.modules.cloud.oracle.OCIProfile;
import org.netbeans.modules.cloud.oracle.adm.URLProvider;
import org.netbeans.modules.cloud.oracle.items.OCID;
import org.netbeans.modules.cloud.oracle.items.OCIItem;
import org.openide.util.Exceptions;

public final class ClusterItem
extends OCIItem
implements URLProvider {
    private String config = null;
    private String namespace = "default";

    public ClusterItem(OCID id, String compartmentId, String name, String tenancyId, String regionCode) {
        super(id, compartmentId, name, tenancyId, regionCode);
    }

    public ClusterItem() {
    }

    public String getConfig() {
        return this.config;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        String oldNamespace = this.namespace;
        this.namespace = namespace;
        this.firePropertyChange("namespace", oldNamespace, namespace);
    }

    public void update() {
        OCIProfile profile = OCIManager.getDefault().getActiveProfile(this);
        ContainerEngineClient containerEngineClient = profile.newClient(ContainerEngineClient.class);
        CreateKubeconfigRequest request = CreateKubeconfigRequest.builder().clusterId(this.getKey().getValue()).build();
        CreateKubeconfigResponse response = containerEngineClient.createKubeconfig(request);
        try {
            this.setConfig(new String(response.getInputStream().readAllBytes(), Charset.defaultCharset()));
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    @Override
    public URL getURL() {
        if (this.getKey().getValue() != null && this.getRegion() != null) {
            try {
                URI uri = new URI(String.format("https://cloud.oracle.com/containers/clusters/%s?region=%s", this.getKey().getValue(), this.getRegion()));
                return uri.toURL();
            }
            catch (MalformedURLException | URISyntaxException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return null;
    }
}

