/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.developer;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.http.client.HttpClient;
import com.oracle.bmc.http.client.HttpRequest;
import com.oracle.bmc.http.client.HttpResponse;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.client.jersey.JerseyHttpProvider;
import com.oracle.bmc.http.signing.RequestSigningFilter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.netbeans.modules.cloud.oracle.OCIManager;
import org.netbeans.modules.cloud.oracle.OCIProfile;
import org.netbeans.modules.cloud.oracle.assets.TempFileGenerator;
import org.netbeans.spi.lsp.CommandProvider;
import org.openide.util.RequestProcessor;

public class BearerTokenCommand
implements CommandProvider {
    private static final String COMMAND_CREATE_BEARER_TOKEN = "nbls.cloud.assets.createBearerToken";
    private static final String API_VERSION = "20180419";
    private static String lastPath;
    private static Instant lastTaken;
    private static final RequestProcessor RP;
    private static final Set COMMANDS;

    public Set<String> getCommands() {
        return Collections.unmodifiableSet(COMMANDS);
    }

    public CompletableFuture<Object> runCommand(String command, List<Object> arguments) {
        if (arguments == null || arguments.isEmpty()) {
            return null;
        }
        JsonPrimitive s = (JsonPrimitive)arguments.get(0);
        String ocirServer = s.getAsString();
        CompletableFuture<Object> result = new CompletableFuture<Object>();
        RP.post(() -> {
            OCIProfile session = OCIManager.getDefault().getActiveProfile();
            try {
                result.complete(BearerTokenCommand.generateBearerToken(session, ocirServer));
            }
            catch (IOException | InterruptedException | URISyntaxException | ExecutionException e) {
                result.completeExceptionally(e);
            }
        });
        return result;
    }

    public static synchronized String generateBearerToken(OCIProfile provider, String ocirServer) throws URISyntaxException, IOException, ExecutionException, InterruptedException {
        if (Duration.between(lastTaken, Instant.now()).toMinutes() > 55L) {
            lastPath = BearerTokenCommand.generateNewToken(provider, ocirServer);
            lastTaken = Instant.now();
        }
        return lastPath;
    }

    private static String generateNewToken(OCIProfile provider, String ocirServer) throws URISyntaxException, IOException, InterruptedException, ExecutionException {
        String line;
        URI uri = new URI(String.format("https://%s/%s/docker/token", ocirServer, API_VERSION));
        RequestSigningFilter requestSigningFilter = RequestSigningFilter.fromAuthProvider((BasicAuthenticationDetailsProvider)provider.getAuthenticationProvider());
        HttpClient client = JerseyHttpProvider.getInstance().newBuilder().registerRequestInterceptor(1000, (RequestInterceptor)requestSigningFilter).baseUri(uri).build();
        HttpRequest request = client.createRequest(Method.GET).header("accepts", "application/json");
        HttpResponse response = (HttpResponse)request.execute().toCompletableFuture().get();
        InputStream responseBody = (InputStream)response.streamBody().toCompletableFuture().get();
        BufferedReader reader = new BufferedReader(new InputStreamReader(responseBody, StandardCharsets.UTF_8));
        StringBuilder jsonBody = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            jsonBody.append(line);
        }
        JsonObject jsonObject = JsonParser.parseString((String)jsonBody.toString()).getAsJsonObject();
        String token = jsonObject.get("token").getAsString();
        TempFileGenerator gen = new TempFileGenerator("token-", ".txt");
        Path tempFilePath = gen.writeTextFile(token);
        return tempFilePath.toAbsolutePath().toString();
    }

    static {
        lastTaken = Instant.MIN;
        RP = new RequestProcessor(BearerTokenCommand.class);
        COMMANDS = new HashSet<String>(Arrays.asList(COMMAND_CREATE_BEARER_TOKEN));
    }
}

