/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.developer;

import com.oracle.bmc.monitoring.MonitoringClient;
import com.oracle.bmc.monitoring.model.ListMetricsDetails;
import com.oracle.bmc.monitoring.requests.ListMetricsRequest;
import java.util.List;
import java.util.stream.Collectors;
import org.netbeans.modules.cloud.oracle.ChildrenProvider;
import org.netbeans.modules.cloud.oracle.NodeProvider;
import org.netbeans.modules.cloud.oracle.OCINode;
import org.netbeans.modules.cloud.oracle.compartment.CompartmentItem;
import org.netbeans.modules.cloud.oracle.developer.Bundle;
import org.netbeans.modules.cloud.oracle.developer.MetricsNamespaceItem;

public class MetricsNamespaceNode
extends OCINode {
    private static final String METRICS_NAMESPACE_ICON = "org/netbeans/modules/cloud/oracle/resources/metrics_namespace.svg";

    public MetricsNamespaceNode(MetricsNamespaceItem instance) {
        super(instance);
        this.setName(instance.getName());
        this.setDisplayName(instance.getName());
        this.setIconBaseWithExtension(METRICS_NAMESPACE_ICON);
        this.setShortDescription(Bundle.MetricsNamespaceDesc());
    }

    public static NodeProvider<MetricsNamespaceItem> createNode() {
        return MetricsNamespaceNode::new;
    }

    public static ChildrenProvider.SessionAware<CompartmentItem, MetricsNamespaceItem> getMetricNamespaces() {
        return (compartmentId, session) -> {
            MonitoringClient client = session.newClient(MonitoringClient.class);
            ListMetricsDetails listMetricsDetails = ListMetricsDetails.builder().groupBy(List.of("namespace")).build();
            ListMetricsRequest request = ListMetricsRequest.builder().compartmentId(compartmentId.getKey().getValue()).listMetricsDetails(listMetricsDetails).build();
            String tenancyId = session.getTenancy().isPresent() ? session.getTenancy().get().getKey().getValue() : null;
            return client.listMetrics(request).getItems().stream().map(d -> new MetricsNamespaceItem(compartmentId.getKey().getValue(), d.getNamespace(), tenancyId, session.getRegion().getRegionCode())).collect(Collectors.toList());
        };
    }
}

