/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.inspect.webkit.knockout;

import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.netbeans.modules.web.browser.api.Page;
import org.netbeans.modules.web.browser.api.PageInspector;
import org.netbeans.modules.web.inspect.webkit.WebKitPageModel;
import org.netbeans.modules.web.inspect.webkit.knockout.KnockoutTC;
import org.netbeans.modules.web.webkit.debugging.api.debugger.RemoteObject;
import org.openide.util.RequestProcessor;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.TopComponentGroup;
import org.openide.windows.WindowManager;
import org.openide.windows.WindowSystemEvent;
import org.openide.windows.WindowSystemListener;

public class KnockoutTCController
implements PropertyChangeListener {
    private static final KnockoutTCController DEFAULT = new KnockoutTCController();
    private static final RequestProcessor RP = new RequestProcessor(KnockoutTCController.class.getName(), 5);
    KnockoutChecker currentChecker;

    private KnockoutTCController() {
        PageInspector inspector = PageInspector.getDefault();
        inspector.addPropertyChangeListener((PropertyChangeListener)this);
    }

    public static KnockoutTCController getDefault() {
        return DEFAULT;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propName = evt.getPropertyName();
        if ("model".equals(propName)) {
            this.updateTC();
        }
    }

    private void updateTC() {
        if (EventQueue.isDispatchThread()) {
            this.updateTCInAWT();
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    KnockoutTCController.this.updateTCInAWT();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTCInAWT() {
        Page inspectedPage = PageInspector.getDefault().getPage();
        if (inspectedPage == null) {
            KnockoutTCController knockoutTCController = this;
            synchronized (knockoutTCController) {
                this.currentChecker = null;
            }
            KnockoutTCController.getKnockoutTCGroup().close();
        } else {
            KnockoutTCController knockoutTCController = this;
            synchronized (knockoutTCController) {
                this.currentChecker = new KnockoutChecker((WebKitPageModel)inspectedPage);
                this.currentChecker.startCheck();
            }
        }
    }

    static TopComponentGroup getKnockoutTCGroup() {
        return WindowManager.getDefault().findTopComponentGroup("Knockout");
    }

    static KnockoutTC getKnockoutTC() {
        return (KnockoutTC)WindowManager.getDefault().findTopComponent("KnockoutTC");
    }

    public static boolean isKnockoutUsed() {
        return KnockoutTCController.getKnockoutTC().isKnockoutUsed();
    }

    public static void showKnockoutContext() {
        KnockoutTCController.getKnockoutTCGroup().open();
        KnockoutTC tc = KnockoutTCController.getKnockoutTC();
        tc.open();
        tc.requestActive();
        tc.showKnockoutContext();
    }

    final class KnockoutChecker
    implements Runnable,
    PropertyChangeListener {
        private static final int initialDelay = 1;
        private int currentDelay = 1;
        private final WebKitPageModel pageModel;
        private ScheduledFuture currentTask;

        KnockoutChecker(WebKitPageModel pageModel) {
            this.pageModel = pageModel;
        }

        void startCheck() {
            this.scheduleKnockoutCheck(true);
            this.pageModel.addPropertyChangeListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean koFound;
            KnockoutTCController knockoutTCController = KnockoutTCController.this;
            synchronized (knockoutTCController) {
                if (KnockoutTCController.this.currentChecker != this) {
                    return;
                }
            }
            String expression = "window.NetBeans ? NetBeans.getKnockoutVersion() : null";
            RemoteObject object = this.pageModel.getWebKit().getRuntime().evaluate(expression);
            boolean bl = koFound = object != null && object.getType() == RemoteObject.Type.STRING;
            if (koFound) {
                KnockoutChecker knockoutChecker = this;
                synchronized (knockoutChecker) {
                    this.currentTask = null;
                }
                this.openKnockoutTCGroup(object.getValueAsString());
            } else {
                this.scheduleKnockoutCheck(false);
            }
        }

        private synchronized void scheduleKnockoutCheck(boolean initial) {
            this.currentDelay = initial ? 1 : (this.currentDelay *= 2);
            this.currentTask = RP.schedule((Runnable)this, (long)this.currentDelay, TimeUnit.SECONDS);
        }

        private void openKnockoutTCGroup(final String koVersion) {
            EventQueue.invokeLater(new Runnable(){
                final /* synthetic */ KnockoutChecker this$1;
                {
                    this.this$1 = this$1;
                }

                @Override
                public void run() {
                    TopComponentGroup group = KnockoutTCController.getKnockoutTCGroup();
                    KnockoutTC knockoutTC = KnockoutTCController.getKnockoutTC();
                    knockoutTC.knockoutUsed(this.this$1.pageModel, koVersion);
                    Mode mode = WindowManager.getDefault().findMode((TopComponent)knockoutTC);
                    TopComponent selectedTC = mode.getSelectedTopComponent();
                    group.open();
                    if (selectedTC != null) {
                        selectedTC.requestVisible();
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("document".equals(evt.getPropertyName())) {
                KnockoutChecker knockoutChecker = this;
                synchronized (knockoutChecker) {
                    if (this.currentTask != null) {
                        this.currentTask.cancel(false);
                    }
                    this.scheduleKnockoutCheck(true);
                }
            }
        }
    }

    public static class ShutdownHook
    implements Callable<Boolean>,
    WindowSystemListener {
        private boolean listenerInstalled;

        @Override
        public Boolean call() throws Exception {
            if (!this.listenerInstalled) {
                this.listenerInstalled = true;
                WindowManager.getDefault().addWindowSystemListener((WindowSystemListener)this);
            }
            return Boolean.TRUE;
        }

        public void beforeLoad(WindowSystemEvent event) {
        }

        public void afterLoad(WindowSystemEvent event) {
        }

        public void beforeSave(WindowSystemEvent event) {
            KnockoutTCController.getKnockoutTCGroup().close();
        }

        public void afterSave(WindowSystemEvent event) {
        }
    }
}

