/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.nodejs.util;

import java.awt.EventQueue;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.project.Project;
import org.netbeans.modules.javascript.nodejs.util.Bundle;
import org.netbeans.modules.javascript.nodejs.util.NodeJsUtils;
import org.netbeans.modules.javascript.nodejs.util.StringUtils;
import org.netbeans.modules.web.clientproject.api.network.NetworkException;
import org.netbeans.modules.web.clientproject.api.network.NetworkSupport;
import org.netbeans.modules.web.common.api.Version;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.util.Mutex;
import org.openide.util.Parameters;
import org.openide.util.Utilities;

public final class FileUtils {
    static final Logger LOGGER = Logger.getLogger(FileUtils.class.getName());
    public static final File TMP_DIR = new File(System.getProperty("java.io.tmpdir"));
    private static final boolean IS_WINDOWS = Utilities.isWindows();
    private static final String JAVASCRIPT_MIME_TYPE = "text/javascript";
    public static final String TS_MIME_TYPE = "application/x-typescript";
    private static final String NODEJS_SOURCES_URL = "https://nodejs.org/dist/v%1$s/node-v%1$s.tar.gz";
    private static final String IOJS_SOURCES_URL = "https://iojs.org/dist/v%1$s/iojs-v%1$s.tar.gz";

    private FileUtils() {
    }

    public static boolean isJavaScriptFile(FileObject file) {
        assert (file != null);
        return FileUtil.getMIMEType((FileObject)file, (String[])new String[]{JAVASCRIPT_MIME_TYPE, TS_MIME_TYPE, null}) != null;
    }

    public static boolean isJavaScriptFile(File file) {
        return FileUtils.isJavaScriptFile(FileUtil.toFileObject((File)file));
    }

    public static String relativizePath(Project project, String filePath) {
        if (!StringUtils.hasText(filePath)) {
            return "";
        }
        File file = new File(filePath);
        String path = PropertyUtils.relativizeFile((File)FileUtil.toFile((FileObject)project.getProjectDirectory()), (File)file);
        if (path == null || path.startsWith("../")) {
            path = file.getAbsolutePath();
        }
        return path;
    }

    public static String resolvePath(Project project, String filePath) {
        if (!StringUtils.hasText(filePath)) {
            return null;
        }
        return PropertyUtils.resolveFile((File)FileUtil.toFile((FileObject)project.getProjectDirectory()), (String)filePath).getAbsolutePath();
    }

    public static List<File> sortFiles(Collection<File> files) {
        final Collator collator = Collator.getInstance();
        ArrayList<File> sortedFiles = new ArrayList<File>(files);
        sortedFiles.sort(new Comparator<File>(){

            @Override
            public int compare(File file1, File file2) {
                return collator.compare(file1.getName(), file2.getName());
            }
        });
        return sortedFiles;
    }

    public static List<String> findFileOnUsersPath(String filename) {
        Parameters.notNull((CharSequence)"filename", (Object)filename);
        return FileUtils.findFileOnUsersPath(new String[]{filename});
    }

    public static List<String> findFileOnUsersPath(String ... filenames) {
        Parameters.notNull((CharSequence)"filenames", (Object)filenames);
        String path = System.getenv("PATH");
        LOGGER.log(Level.FINE, "PATH: [{0}]", path);
        if (path == null) {
            return Collections.emptyList();
        }
        LinkedHashSet<String> dirs = new LinkedHashSet<String>(Arrays.asList(path.split(File.pathSeparator)));
        LOGGER.log(Level.FINE, "PATH dirs: {0}", dirs);
        ArrayList<String> found = new ArrayList<String>(dirs.size() * filenames.length);
        for (String filename : filenames) {
            Parameters.notNull((CharSequence)"filename", (Object)filename);
            for (String dir : dirs) {
                File file = new File(dir, filename);
                if (!file.isFile()) continue;
                String absolutePath = FileUtil.normalizeFile((File)file).getAbsolutePath();
                LOGGER.log(Level.FINE, "File ''{0}'' found", absolutePath);
                if (found.contains(absolutePath)) continue;
                LOGGER.log(Level.FINE, "File ''{0}'' added to found files", absolutePath);
                found.add(absolutePath);
            }
        }
        LOGGER.log(Level.FINE, "Found files: {0}", found);
        return found;
    }

    @CheckForNull
    public static String validateFile(String filePath, boolean writable) {
        return FileUtils.validateFile(Bundle.FileUtils_validateFile_file(), filePath, writable);
    }

    @CheckForNull
    public static String validateFile(String source, String filePath, boolean writable) {
        if (!StringUtils.hasText(filePath)) {
            return Bundle.FileUtils_validateFile_missing(source);
        }
        File file = new File(filePath);
        if (!file.isAbsolute()) {
            return Bundle.FileUtils_validateFile_notAbsolute(source);
        }
        if (!file.isFile()) {
            return Bundle.FileUtils_validateFile_notFile(source);
        }
        if (!file.canRead()) {
            return Bundle.FileUtils_validateFile_notReadable(source);
        }
        if (writable && !file.canWrite()) {
            return Bundle.FileUtils_validateFile_notWritable(source);
        }
        return null;
    }

    public static String getScriptExtension(boolean withDot, boolean cmdInsteadBatOnWin) {
        StringBuilder sb = new StringBuilder(4);
        if (withDot) {
            sb.append(".");
        }
        if (IS_WINDOWS) {
            sb.append(cmdInsteadBatOnWin ? "cmd" : "bat");
        } else {
            sb.append("sh");
        }
        return sb.toString();
    }

    public static void openFile(File file, int line) {
        DataObject dataObject;
        assert (file != null);
        FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
        if (fileObject == null) {
            LOGGER.log(Level.INFO, "FileObject not found for {0}", file);
            return;
        }
        try {
            dataObject = DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException ex) {
            LOGGER.log(Level.INFO, "DataObject not found for {0}", file);
            return;
        }
        if (line == -1) {
            EditorCookie ec = (EditorCookie)dataObject.getLookup().lookup(EditorCookie.class);
            ec.open();
            return;
        }
        LineCookie lineCookie = (LineCookie)dataObject.getLookup().lookup(LineCookie.class);
        if (lineCookie == null) {
            LOGGER.log(Level.INFO, "LineCookie not found for {0}", file);
            return;
        }
        Line.Set lineSet = lineCookie.getLineSet();
        try {
            final Line currentLine = lineSet.getCurrent(line - 1);
            Mutex.EVENT.readAccess(new Runnable(){

                @Override
                public void run() {
                    currentLine.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS);
                }
            });
        }
        catch (IndexOutOfBoundsException exc) {
            LOGGER.log(Level.FINE, null, exc);
        }
    }

    public static boolean downloadNodeSources(Version version, boolean iojs) throws NetworkException, IOException {
        assert (!EventQueue.isDispatchThread());
        assert (version != null);
        FileUtils.deleteExistingNodeSources(version);
        File nodeSources = NodeJsUtils.getNodeSources();
        String nodeVersion = version.toString();
        File archive = new File(nodeSources, (iojs ? "iojs" : "nodejs") + "-" + nodeVersion + ".tar.gz");
        if (!FileUtils.downloadNodeSources(archive, nodeVersion, iojs)) {
            return false;
        }
        boolean success = false;
        try {
            String foldername = FileUtils.decompressTarGz(archive, nodeSources, false);
            assert (foldername != null) : version;
            success = new File(nodeSources, foldername).renameTo(new File(nodeSources, nodeVersion));
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, archive.getAbsolutePath(), ex);
            throw ex;
        }
        if (!archive.delete()) {
            archive.deleteOnExit();
        }
        return success;
    }

    private static void deleteExistingNodeSources(Version version) throws IOException {
        assert (version != null);
        if (NodeJsUtils.hasNodeSources(version)) {
            final FileObject fo = FileUtil.toFileObject((File)NodeJsUtils.getNodeSources(version));
            assert (fo != null) : version;
            FileUtil.runAtomicAction((FileSystem.AtomicAction)new FileSystem.AtomicAction(){

                public void run() throws IOException {
                    fo.delete();
                }
            });
        }
    }

    private static boolean downloadNodeSources(File archive, String nodeVersion, boolean iojs) throws IOException {
        assert (archive != null);
        assert (nodeVersion != null);
        String url = String.format(iojs ? IOJS_SOURCES_URL : NODEJS_SOURCES_URL, nodeVersion);
        try {
            String msg = iojs ? Bundle.FileUtils_sources_downloading_iojs(nodeVersion) : Bundle.FileUtils_sources_downloading_nodejs(nodeVersion);
            NetworkSupport.downloadWithProgress((String)url, (File)archive, (String)msg);
            return true;
        }
        catch (InterruptedException ex) {
            LOGGER.log(Level.FINE, "Download cancelled for {0}", url);
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, url, ex);
            throw ex;
        }
        return false;
    }

    @CheckForNull
    public static String decompressTarGz(File archive, File destination, boolean skipArchiveRoot) throws IOException {
        String archiveRoot = null;
        try (TarArchiveInputStream tarInputStream = new TarArchiveInputStream((InputStream)new GZIPInputStream(new FileInputStream(archive)));){
            int archiveRootLength = -1;
            TarArchiveEntry tarEntry = tarInputStream.getNextTarEntry();
            if (tarEntry != null) {
                archiveRoot = tarEntry.getName();
                if (skipArchiveRoot) {
                    archiveRootLength = archiveRoot.length();
                    tarEntry = tarInputStream.getNextTarEntry();
                }
            }
            while (tarEntry != null) {
                String name = tarEntry.getName();
                if (skipArchiveRoot) {
                    name = name.substring(archiveRootLength);
                }
                File destPath = new File(destination, name);
                if (tarEntry.isDirectory()) {
                    if (!destPath.isDirectory() && !destPath.mkdirs()) {
                        throw new IOException("Cannot create directory " + destPath);
                    }
                } else {
                    if (!destPath.isFile() && !destPath.createNewFile()) {
                        throw new IOException("Cannot create new file " + destPath);
                    }
                    try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(destPath));){
                        FileUtil.copy((InputStream)tarInputStream, (OutputStream)outputStream);
                    }
                }
                tarEntry = tarInputStream.getNextTarEntry();
            }
        }
        return archiveRoot;
    }

    public static boolean isSubdirectoryOf(File folder, File child) {
        String chp;
        String fp;
        if (!folder.isDirectory()) {
            return false;
        }
        try {
            fp = folder.getCanonicalPath();
        }
        catch (IOException ioex) {
            fp = folder.getAbsolutePath();
        }
        try {
            chp = child.getCanonicalPath();
        }
        catch (IOException ioex) {
            chp = child.getAbsolutePath();
        }
        if (!chp.startsWith(fp)) {
            return false;
        }
        int fl = fp.length();
        if (chp.length() == fl) {
            return true;
        }
        char separ = chp.charAt(fl);
        return File.separatorChar == separ;
    }
}

