/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.jaxws.actions;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.javaee.specs.support.api.JaxWsPoliciesSupport;
import org.netbeans.modules.websvc.api.jaxws.project.config.Client;
import org.netbeans.modules.websvc.core.jaxws.actions.PoliciesVisualPanel;
import org.netbeans.modules.websvc.core.jaxws.policies.JaxWsPoliciesCodeGenerator;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class PolicyManager {
    static final String SECURITY_FEATURE = "securityFeature";
    private Set<String> policyIds;
    private final String wsdlUrl;
    private final FileObject wsdl;
    private final Project project;
    private Client client;
    private JaxWsPoliciesSupport support;
    private String chosenId;
    private String optionalCode;
    private Collection<String> importFqns;
    private JaxWsPoliciesCodeGenerator generator;

    PolicyManager(String wsdlUrl, FileObject wsdl, Project project) {
        this.wsdlUrl = wsdlUrl;
        this.wsdl = wsdl;
        this.project = project;
        this.init();
    }

    String getWsdlUrl() {
        return this.wsdlUrl;
    }

    void init(Client client) {
        this.client = client;
    }

    void chosePolicy() {
        if (this.support == null) {
            return;
        }
        Collection generators = Lookup.getDefault().lookupAll(JaxWsPoliciesCodeGenerator.class);
        JaxWsPoliciesCodeGenerator policyGenerator = null;
        for (JaxWsPoliciesCodeGenerator gen : generators) {
            if (!gen.isApplicable(this.policyIds, this.support.getPlatform(), this.getLocalWsdl())) continue;
            policyGenerator = gen;
            break;
        }
        if (policyGenerator == null) {
            return;
        }
        List clientPolicyIds = this.support.getClientPolicyIds();
        StringBuilder builder = new StringBuilder();
        String clientPolicyId = null;
        if (this.policyIds.isEmpty()) {
            clientPolicyId = this.choosePolicyId(clientPolicyIds);
            if (clientPolicyId == null) {
                return;
            }
            this.policyIds = Collections.singleton(clientPolicyId);
        }
        this.generator = policyGenerator;
        this.importFqns = policyGenerator.getRequiredClasses(this.chosenId);
        this.support.extendsProjectClasspath(this.getPorject(), this.importFqns);
        this.chosenId = policyGenerator.generatePolicyAccessCode(this.policyIds, this.client, builder);
        this.optionalCode = builder.toString();
    }

    Collection<String> getImports() {
        return this.importFqns == null ? Collections.emptyList() : this.importFqns;
    }

    String getOptionalCode() {
        return this.optionalCode == null ? "" : this.optionalCode;
    }

    void modifyPortCallInitArguments(Object[] args) {
        this.modifyArguments(args);
    }

    void modifyPortInvocationInitArguments(Object[] args) {
        this.modifyArguments(args);
    }

    boolean isSupported() {
        return this.generator != null && !this.policyIds.isEmpty();
    }

    Tree createSecurityFeatureType(WorkingCopy workingCopy, TreeMaker make) {
        return this.generator.createSecurityFeatureType(workingCopy, make);
    }

    ExpressionTree createSecurityFeatureInitializer(WorkingCopy workingCopy, TreeMaker make) {
        return this.generator.createSecurityFeatureInitializer(workingCopy, make, this.chosenId);
    }

    void modifySecurityFeatureAttribute(VariableTree var, WorkingCopy workingCopy, TreeMaker make) {
        this.generator.modifySecurityFeatureAttribute(var, workingCopy, make, this.chosenId, this.policyIds);
    }

    private Object[] modifyArguments(Object[] args) {
        if (this.support == null) {
            return args;
        }
        args[3] = args[3] == null || args[3].toString().trim().length() == 0 ? this.getOptionalCode() : args[3].toString() + this.getOptionalCode();
        args[9] = SECURITY_FEATURE;
        return args;
    }

    private String choosePolicyId(List<String> ids) {
        PoliciesVisualPanel policies = new PoliciesVisualPanel(ids);
        DialogDescriptor desc = new DialogDescriptor((Object)policies, NbBundle.getMessage(PolicyManager.class, (String)"LBL_ChoosePolicy"));
        if (DialogDescriptor.OK_OPTION == DialogDisplayer.getDefault().notify((NotifyDescriptor)desc)) {
            return policies.getId();
        }
        return null;
    }

    private FileObject getLocalWsdl() {
        return this.wsdl;
    }

    private void init() {
        J2eeModuleProvider moduleProvider = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
        if (moduleProvider != null) {
            String id = moduleProvider.getServerInstanceID();
            this.support = this.findPolicySupport(id);
            if (this.support != null && !this.hasServicePolicies(this.wsdl, Collections.singletonList(this.support.getLookup(this.wsdl)))) {
                this.support = null;
            }
        } else {
            String[] serverInstanceIds = Deployment.getDefault().getServerInstanceIDs();
            ArrayList<JaxWsPoliciesSupport> supports = new ArrayList<JaxWsPoliciesSupport>(serverInstanceIds.length);
            ArrayList<Lookup> supportsLookup = new ArrayList<Lookup>(serverInstanceIds.length);
            for (String id : serverInstanceIds) {
                JaxWsPoliciesSupport foundSupport = this.findPolicySupport(id);
                if (foundSupport == null) continue;
                supports.add(foundSupport);
                supportsLookup.add(foundSupport.getLookup(this.wsdl));
            }
            if (supports.isEmpty()) {
                return;
            }
            if (this.hasServicePolicies(this.wsdl, supportsLookup)) {
                int i = 0;
                for (JaxWsPoliciesSupport sup : supports) {
                    if (sup.supports(this.wsdl, (Lookup)supportsLookup.get(i))) {
                        this.support = sup;
                        return;
                    }
                    ++i;
                }
            }
        }
    }

    private JaxWsPoliciesSupport findPolicySupport(String serverInstanceId) {
        try {
            J2eePlatform j2eePlatform = Deployment.getDefault().getServerInstance(serverInstanceId).getJ2eePlatform();
            return JaxWsPoliciesSupport.getInstance((J2eePlatform)j2eePlatform);
        }
        catch (InstanceRemovedException e) {
            Logger.getLogger(PolicyManager.class.getName()).log(Level.INFO, null, e);
            return null;
        }
    }

    private Project getPorject() {
        return this.project;
    }

    private boolean hasServicePolicies(FileObject wsdl, Collection<Lookup> supportLokups) {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser saxParser = factory.newSAXParser();
            WsdlPolicyHandler handler = new WsdlPolicyHandler(wsdl, supportLokups);
            saxParser.parse(FileUtil.toFile((FileObject)wsdl), (DefaultHandler)handler);
            this.policyIds = handler.getPolicyIds();
            return handler.hasPolicy();
        }
        catch (ParserConfigurationException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, null, e);
        }
        catch (SAXException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, null, e);
        }
        catch (IOException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, null, e);
        }
        return false;
    }

    private static final class WsdlPolicyHandler
    extends DefaultHandler {
        private static final String POLICY = "Policy";
        private static final String ID = "Id";
        private static final String COLON_ID = ":Id";
        private static final String COLON_POLICY = ":Policy";
        private boolean hasPolicy;
        private Set<String> policies = new HashSet<String>();
        private Collection<DefaultHandler> delegates;

        WsdlPolicyHandler(FileObject wsdl, Collection<Lookup> supportLookups) {
            this.delegates = new ArrayList<DefaultHandler>(supportLookups.size());
            for (Lookup lookup : supportLookups) {
                DefaultHandler handler = (DefaultHandler)lookup.lookup(DefaultHandler.class);
                this.delegates.add(handler);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            super.endElement(uri, localName, qName);
            for (DefaultHandler delegate : this.delegates) {
                delegate.endElement(uri, localName, qName);
            }
        }

        @Override
        public void endDocument() throws SAXException {
            super.endDocument();
            for (DefaultHandler delegate : this.delegates) {
                delegate.endDocument();
            }
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
            super.endPrefixMapping(prefix);
            for (DefaultHandler delegate : this.delegates) {
                delegate.endPrefixMapping(prefix);
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            super.characters(ch, start, length);
            for (DefaultHandler delegate : this.delegates) {
                delegate.characters(ch, start, length);
            }
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            super.ignorableWhitespace(ch, start, length);
            for (DefaultHandler delegate : this.delegates) {
                delegate.ignorableWhitespace(ch, start, length);
            }
        }

        @Override
        public void notationDecl(String name, String publicId, String systemId) throws SAXException {
            super.notationDecl(name, publicId, systemId);
            for (DefaultHandler delegate : this.delegates) {
                delegate.notationDecl(name, publicId, systemId);
            }
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
            super.processingInstruction(target, data);
            for (DefaultHandler delegate : this.delegates) {
                delegate.processingInstruction(target, data);
            }
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
            super.skippedEntity(name);
            for (DefaultHandler delegate : this.delegates) {
                delegate.skippedEntity(name);
            }
        }

        @Override
        public void startDocument() throws SAXException {
            super.startDocument();
            for (DefaultHandler delegate : this.delegates) {
                delegate.startDocument();
            }
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            super.startPrefixMapping(prefix, uri);
            for (DefaultHandler delegate : this.delegates) {
                delegate.startPrefixMapping(prefix, uri);
            }
        }

        @Override
        public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
            super.unparsedEntityDecl(name, publicId, systemId, notationName);
            for (DefaultHandler delegate : this.delegates) {
                delegate.unparsedEntityDecl(name, publicId, systemId, notationName);
            }
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            super.startElement(uri, localName, qName, attributes);
            for (DefaultHandler delegate : this.delegates) {
                delegate.startElement(uri, localName, qName, attributes);
            }
            boolean policy = false;
            if (localName != null && localName.equals(POLICY)) {
                policy = true;
            }
            if (qName != null && qName.endsWith(COLON_POLICY)) {
                policy = true;
            }
            if (!policy) {
                return;
            }
            this.hasPolicy = true;
            int count = attributes.getLength();
            for (int i = 0; i < count; ++i) {
                String value = attributes.getValue(i);
                String attrLocalName = attributes.getLocalName(i);
                String attrQName = attributes.getQName(i);
                if ((attrLocalName == null || !attrLocalName.equals(ID)) && (attrLocalName == null || !attrQName.endsWith(COLON_ID))) continue;
                this.policies.add(attributes.getValue(i));
            }
        }

        boolean hasPolicy() {
            return this.hasPolicy;
        }

        Set<String> getPolicyIds() {
            return this.policies;
        }
    }
}

