/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.javascript.debugger.breakpoints.ui;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeListener;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.web.javascript.debugger.breakpoints.EventsBreakpoint;
import org.netbeans.modules.web.javascript.debugger.breakpoints.ui.ControllerProvider;
import org.netbeans.spi.debugger.ui.Controller;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class EventsBreakpointCustomizer
extends JPanel
implements ControllerProvider,
HelpCtx.Provider {
    private final EventsBreakpoint eb;
    private boolean createBreakpoint;
    private final CustomizerController controller;
    private final int checkBoxWidth;
    private JLabel actionLabel;
    private JList actionList;
    private JLabel categoryLabel;
    private JList categoryList;

    private static EventsBreakpoint createEventsBreakpoint(boolean[] createCheckPtr) {
        Breakpoint[] breakpoints;
        for (Breakpoint b : breakpoints = DebuggerManager.getDebuggerManager().getBreakpoints()) {
            if (!(b instanceof EventsBreakpoint)) continue;
            return (EventsBreakpoint)b;
        }
        createCheckPtr[0] = true;
        return new EventsBreakpoint();
    }

    public EventsBreakpointCustomizer() {
        this(new boolean[1]);
    }

    private EventsBreakpointCustomizer(boolean[] createCheckPtr) {
        this(EventsBreakpointCustomizer.createEventsBreakpoint(createCheckPtr));
        this.createBreakpoint = createCheckPtr[0];
    }

    public EventsBreakpointCustomizer(EventsBreakpoint eb) {
        this.checkBoxWidth = new JCheckBox().getPreferredSize().width;
        this.eb = eb;
        this.initComponents();
        this.initLists();
        this.fillCategoryEvents();
        this.selectFirst();
        this.controller = new CustomizerController();
    }

    private void initLists() {
        this.categoryList.setCellRenderer(new CategoryCheckBoxCellRenderer());
        this.categoryList.addListSelectionListener(new CategorySelectionListener());
        this.categoryList.setSelectionMode(0);
        this.categoryList.addMouseListener(new CheckBoxMouseListener(true));
        this.actionList.setCellRenderer(new EventsCheckBoxCellRenderer());
        this.actionList.addMouseListener(new CheckBoxMouseListener(false));
    }

    private void fillCategoryEvents() {
        Set<String> allEventCategories = EventsBreakpoint.getAllEventCategories();
        DefaultListModel<String> categoryModel = new DefaultListModel<String>();
        for (String category : allEventCategories) {
            categoryModel.addElement(category);
        }
        this.categoryList.setModel(categoryModel);
    }

    private void fillEvents(String category) {
        DefaultListModel<String> eventsModel = new DefaultListModel<String>();
        Set<String> allEvents = EventsBreakpoint.getAllEvents(category);
        for (String event : allEvents) {
            eventsModel.addElement(event);
        }
        this.actionList.setModel(eventsModel);
    }

    private void selectFirst() {
        Set<String> events = this.eb.getEvents();
        if (events.isEmpty()) {
            this.categoryList.setSelectedIndex(0);
            return;
        }
        Set<String> allEventCategories = EventsBreakpoint.getAllEventCategories();
        for (String category : allEventCategories) {
            for (String event : EventsBreakpoint.getAllEvents(category)) {
                if (!events.contains(event)) continue;
                this.categoryList.setSelectedValue(category, true);
                return;
            }
        }
    }

    private void initComponents() {
        this.categoryLabel = new JLabel();
        this.categoryList = new JList();
        this.actionLabel = new JLabel();
        this.actionList = new JList();
        Mnemonics.setLocalizedText((JLabel)this.categoryLabel, (String)NbBundle.getMessage(EventsBreakpointCustomizer.class, (String)"EventsBreakpointCustomizer.categoryLabel.text"));
        this.categoryList.setBorder(BorderFactory.createEtchedBorder());
        Mnemonics.setLocalizedText((JLabel)this.actionLabel, (String)NbBundle.getMessage(EventsBreakpointCustomizer.class, (String)"EventsBreakpointCustomizer.actionLabel.text"));
        this.actionList.setBorder(BorderFactory.createEtchedBorder());
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.categoryList, -1, 179, Short.MAX_VALUE).addComponent(this.categoryLabel)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.actionLabel).addComponent(this.actionList, -1, 179, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.categoryLabel).addComponent(this.actionLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.categoryList, -1, 255, Short.MAX_VALUE).addComponent(this.actionList, -1, -1, Short.MAX_VALUE)).addContainerGap()));
    }

    @Override
    public Controller getController() {
        return this.controller;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NetbeansDebuggerEventsBreakpointJavaScript");
    }

    private static JCheckBox createCheckBoxToRender() {
        JCheckBox chb = new JCheckBox();
        chb.setBorderPaintedFlat(true);
        return chb;
    }

    private static void setupCheckBoxToRender(JCheckBox chb, JList list, boolean isSelected, boolean cellHasFocus) {
        if (isSelected) {
            chb.setBackground(list.getSelectionBackground());
            chb.setForeground(list.getSelectionForeground());
        } else {
            chb.setBackground(list.getBackground());
            chb.setForeground(list.getForeground());
        }
    }

    static /* synthetic */ JCheckBox access$200() {
        return EventsBreakpointCustomizer.createCheckBoxToRender();
    }

    private class CustomizerController
    implements Controller {
        private CustomizerController() {
        }

        public boolean ok() {
            if (EventsBreakpointCustomizer.this.createBreakpoint) {
                DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)EventsBreakpointCustomizer.this.eb);
            }
            return true;
        }

        public boolean cancel() {
            return true;
        }

        public boolean isValid() {
            return true;
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
        }
    }

    private class CategoryCheckBoxCellRenderer
    implements ListCellRenderer {
        private JCheckBox chb = EventsBreakpointCustomizer.access$200();

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            EventsBreakpointCustomizer.setupCheckBoxToRender(this.chb, list, isSelected, cellHasFocus);
            String category = (String)value;
            this.chb.setText(category);
            Set<String> allCategoryEvents = EventsBreakpoint.getAllEvents(category);
            boolean containsSome = false;
            boolean containsAll = true;
            for (String event : allCategoryEvents) {
                if (EventsBreakpointCustomizer.this.eb.hasEvent(event)) {
                    containsSome = true;
                    continue;
                }
                containsAll = false;
            }
            boolean mixed = containsSome && !containsAll;
            this.chb.getModel().setArmed(mixed);
            this.chb.getModel().setPressed(mixed);
            this.chb.setSelected(containsAll);
            return this.chb;
        }
    }

    private class CategorySelectionListener
    implements ListSelectionListener {
        private CategorySelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int index = EventsBreakpointCustomizer.this.categoryList.getSelectedIndex();
            if (index >= 0) {
                String category = (String)EventsBreakpointCustomizer.this.categoryList.getModel().getElementAt(index);
                EventsBreakpointCustomizer.this.fillEvents(category);
            } else {
                EventsBreakpointCustomizer.this.actionList.setModel(new DefaultListModel());
            }
        }
    }

    private class CheckBoxMouseListener
    implements MouseListener {
        private boolean isCategory;

        CheckBoxMouseListener(boolean isCategory) {
            this.isCategory = isCategory;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (this.isCategory) {
                String category = this.getSelectedText(EventsBreakpointCustomizer.this.categoryList, e);
                if (category == null) {
                    return;
                }
                Set<String> allCategoryEvents = EventsBreakpoint.getAllEvents(category);
                boolean containsAll = true;
                for (String event : allCategoryEvents) {
                    if (EventsBreakpointCustomizer.this.eb.hasEvent(event)) continue;
                    containsAll = false;
                }
                if (!containsAll) {
                    for (String event : allCategoryEvents) {
                        EventsBreakpointCustomizer.this.eb.addEvent(event);
                    }
                } else {
                    for (String event : allCategoryEvents) {
                        EventsBreakpointCustomizer.this.eb.removeEvent(event);
                    }
                }
            } else {
                String event = this.getSelectedText(EventsBreakpointCustomizer.this.actionList, e);
                if (event == null) {
                    return;
                }
                if (EventsBreakpointCustomizer.this.eb.hasEvent(event)) {
                    EventsBreakpointCustomizer.this.eb.removeEvent(event);
                } else {
                    EventsBreakpointCustomizer.this.eb.addEvent(event);
                }
            }
            EventsBreakpointCustomizer.this.categoryList.repaint();
            EventsBreakpointCustomizer.this.actionList.repaint();
        }

        private String getSelectedText(JList list, MouseEvent e) {
            int x;
            int index = list.locationToIndex(e.getPoint());
            if (index >= 0 && (x = e.getX()) < EventsBreakpointCustomizer.this.checkBoxWidth) {
                return (String)list.getModel().getElementAt(index);
            }
            return null;
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }

    private class EventsCheckBoxCellRenderer
    implements ListCellRenderer {
        private JCheckBox chb = EventsBreakpointCustomizer.access$200();

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            EventsBreakpointCustomizer.setupCheckBoxToRender(this.chb, list, false, cellHasFocus);
            String event = (String)value;
            this.chb.setText(event);
            this.chb.setSelected(EventsBreakpointCustomizer.this.eb.hasEvent(event));
            return this.chb;
        }
    }
}

