/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.v2.ui;

import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import org.netbeans.lib.profiler.ui.components.LazyComboBox;
import org.netbeans.modules.profiler.api.ProjectUtilities;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.v2.ui.Bundle;
import org.openide.util.Lookup;

public class ProjectSelector
extends LazyComboBox<Lookup.Provider> {
    public static final Lookup.Provider EXTERNAL_PROCESS = new Lookup.Provider(){

        public Lookup getLookup() {
            return Lookup.EMPTY;
        }
    };

    public ProjectSelector(Populator populator) {
        super((LazyComboBox.Populator)populator);
        this.setRenderer(new ProjectNameRenderer());
    }

    public final Lookup.Provider getProject() {
        Lookup.Provider project = (Lookup.Provider)this.getSelectedItem();
        return project == EXTERNAL_PROCESS ? null : project;
    }

    public final void setProject(Lookup.Provider project) {
        this.setSelectedItem(project == null ? EXTERNAL_PROCESS : project);
    }

    public void resetProject(Lookup.Provider project) {
        if (this.getProject() == project) {
            this.resetModel();
        }
    }

    private static final class ProjectNameRenderer
    extends DefaultListCellRenderer {
        private Font _plainFont;
        private Font _boldFont;
        private Renderer _renderer;

        private ProjectNameRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel renderer = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (this._renderer == null) {
                this._renderer = new Renderer();
            }
            this._renderer.setComponentOrientation(renderer.getComponentOrientation());
            this._renderer.setOpaque(renderer.isOpaque());
            this._renderer.setForeground(renderer.getForeground());
            this._renderer.setBackground(renderer.getBackground());
            this._renderer.setEnabled(renderer.isEnabled());
            this._renderer.setBorder(renderer.getBorder());
            if (value != EXTERNAL_PROCESS) {
                Lookup.Provider p = (Lookup.Provider)value;
                this._renderer.setText(ProjectUtilities.getDisplayName((Lookup.Provider)p));
                this._renderer.setIcon(ProjectUtilities.getIcon((Lookup.Provider)p));
                boolean main = ProjectUtilities.getMainProject() == value;
                this._renderer.setFontEx(main ? this.boldFont(renderer) : this.plainFont(renderer));
            } else {
                this._renderer.setText(Bundle.ProjectSelector_ExternalProcess());
                this._renderer.setIcon(Icons.getIcon((String)"GeneralIcons.JavaProcess"));
                this._renderer.setFontEx(this.plainFont(renderer));
            }
            return this._renderer;
        }

        private Font plainFont(JLabel renderer) {
            if (this._plainFont == null) {
                this._plainFont = renderer.getFont().deriveFont(0);
            }
            return this._plainFont;
        }

        private Font boldFont(JLabel renderer) {
            if (this._boldFont == null) {
                this._boldFont = renderer.getFont().deriveFont(1);
            }
            return this._boldFont;
        }

        private static class Renderer
        extends DefaultListCellRenderer {
            private Renderer() {
            }

            @Override
            public void setFont(Font font) {
            }

            public void setFontEx(Font font) {
                super.setFont(font);
            }
        }
    }

    public static class Populator
    extends LazyComboBox.Populator<Lookup.Provider> {
        protected Lookup.Provider initialProject() {
            return null;
        }

        protected Collection<Lookup.Provider> additionalProjects() {
            return Collections.EMPTY_SET;
        }

        protected final Lookup.Provider initial() {
            Lookup.Provider initial = this.initialProject();
            return initial == null ? EXTERNAL_PROCESS : initial;
        }

        protected final Lookup.Provider[] populate() {
            HashSet<Lookup.Provider> s = new HashSet<Lookup.Provider>();
            s.addAll(Arrays.asList(ProjectUtilities.getOpenedProjects()));
            s.addAll(this.additionalProjects());
            ArrayList<Lookup.Provider> l = new ArrayList<Lookup.Provider>();
            Lookup.Provider[] pa = s.toArray(new Lookup.Provider[0]);
            l.add(EXTERNAL_PROCESS);
            l.addAll(Arrays.asList(ProjectUtilities.getSortedProjects((Lookup.Provider[])pa)));
            return l.toArray(new Lookup.Provider[0]);
        }
    }
}

