/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.zend2.ui.wizards;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.php.api.executable.InvalidPhpExecutableException;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.api.util.UiUtils;
import org.netbeans.modules.php.composer.api.Composer;
import org.netbeans.modules.php.spi.framework.PhpModuleExtender;
import org.netbeans.modules.php.zend2.options.Zend2Options;
import org.netbeans.modules.php.zend2.ui.wizards.Bundle;
import org.netbeans.modules.php.zend2.ui.wizards.NewProjectConfigurationPanel;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;

public class Zend2PhpModuleExtender
extends PhpModuleExtender {
    private static final Logger LOGGER = Logger.getLogger(Zend2PhpModuleExtender.class.getName());
    static final String SKELETON_ZIP_ENTRY_PREFIX = "ZendSkeletonApplication-master/";
    private NewProjectConfigurationPanel panel = null;

    public void addChangeListener(ChangeListener listener) {
        this.getPanel().addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.getPanel().removeChangeListener(listener);
    }

    public JComponent getComponent() {
        return this.getPanel();
    }

    public HelpCtx getHelp() {
        return null;
    }

    public boolean isValid() {
        return this.getErrorMessage() == null;
    }

    public String getErrorMessage() {
        String error = this.getPanel().getErrorMessage();
        if (error != null) {
            return error;
        }
        try {
            Composer.getDefault();
        }
        catch (InvalidPhpExecutableException ex) {
            return ex.getLocalizedMessage();
        }
        return null;
    }

    public String getWarningMessage() {
        return this.getPanel().getWarningMessage();
    }

    public Set<FileObject> extend(PhpModule phpModule) throws PhpModuleExtender.ExtendingException {
        try {
            this.unpackSkeleton(phpModule);
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, "Cannot unpack Zend Application Skeleton.", ex);
            throw new PhpModuleExtender.ExtendingException(Bundle.Zend2PhpModuleExtender_not_extended(), (Throwable)ex);
        }
        try {
            Composer.getDefault().install(phpModule).get();
        }
        catch (InvalidPhpExecutableException ex) {
            assert (false) : "Should not happen since Composer is validated in the wizard panel";
            LOGGER.log(Level.INFO, "Composer is not valid so no install cannot be done.", ex);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException ex) {
            UiUtils.processExecutionException((ExecutionException)ex, (String)"FrameworksAndTools/Zend2");
        }
        return this.getInitialFiles(phpModule);
    }

    private void unpackSkeleton(PhpModule phpModule) throws IOException {
        String skeleton = Zend2Options.getInstance().getSkeleton();
        File sourceDir = FileUtil.toFile((FileObject)phpModule.getSourceDirectory());
        FileUtils.unzip((String)skeleton, (File)sourceDir, (FileUtils.ZipEntryFilter)new FileUtils.ZipEntryFilter(){

            public boolean accept(ZipEntry zipEntry) {
                return !Zend2PhpModuleExtender.SKELETON_ZIP_ENTRY_PREFIX.equals(zipEntry.getName());
            }

            public String getName(ZipEntry zipEntry) {
                String entryName = zipEntry.getName();
                if (entryName.startsWith(Zend2PhpModuleExtender.SKELETON_ZIP_ENTRY_PREFIX)) {
                    entryName = entryName.replaceFirst(Zend2PhpModuleExtender.SKELETON_ZIP_ENTRY_PREFIX, "");
                }
                return entryName;
            }
        });
    }

    private Set<FileObject> getInitialFiles(PhpModule phpModule) {
        HashSet<FileObject> files = new HashSet<FileObject>();
        this.addSourceFile(files, phpModule, "config/application.config.php");
        this.addSourceFile(files, phpModule, "module/Application/src/Application/Controller/IndexController.php");
        this.addSourceFile(files, phpModule, "module/Application/view/application/index/index.phtml");
        return files;
    }

    private void addSourceFile(Set<FileObject> files, PhpModule phpModule, String relativePath) {
        FileObject sourceDirectory = phpModule.getSourceDirectory();
        if (sourceDirectory == null) {
            assert (false) : "Module extender for no sources of: " + phpModule.getName();
            return;
        }
        FileObject fileObject = sourceDirectory.getFileObject(relativePath);
        if (fileObject != null) {
            files.add(fileObject);
        }
    }

    private synchronized NewProjectConfigurationPanel getPanel() {
        assert (Thread.holdsLock((Object)this));
        if (this.panel == null) {
            this.panel = new NewProjectConfigurationPanel();
        }
        return this.panel;
    }
}

