/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.micronaut.db;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.swing.event.ChangeListener;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TypeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.templates.CreateDescriptor;
import org.netbeans.api.templates.CreateFromTemplateHandler;
import org.netbeans.modules.j2ee.core.api.support.SourceGroups;
import org.netbeans.modules.j2ee.core.api.support.java.GenerationUtils;
import org.netbeans.modules.j2ee.core.api.support.wizard.Wizards;
import org.netbeans.modules.micronaut.db.Bundle;
import org.netbeans.modules.micronaut.db.ClassesSelectorPanel;
import org.netbeans.modules.micronaut.db.Utils;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class MicronautRepository
implements TemplateWizard.Iterator {
    private WizardDescriptor.Panel panel;
    private WizardDescriptor wizardDescriptor;
    private FileObject targetFolder;
    private boolean jpaSupported;
    private static final String CRUD_REPOSITORY = "io.micronaut.data.repository.CrudRepository";
    private static final String PAGEABLE_REPOSITORY = "io.micronaut.data.repository.PageableRepository";

    public static TemplateWizard.Iterator create() {
        return new MicronautRepository();
    }

    public static CreateFromTemplateHandler handler() {
        return new CreateFromTemplateHandler(){

            protected boolean accept(CreateDescriptor desc) {
                return true;
            }

            protected List<FileObject> createFromTemplate(CreateDescriptor desc) throws IOException {
                try {
                    FileObject folder = desc.getTarget();
                    Project project = FileOwnerQuery.getOwner((FileObject)folder);
                    if (project == null) {
                        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.MSG_NoProject(folder.getPath()), 0));
                        return Collections.emptyList();
                    }
                    SourceGroup sourceGroup = SourceGroups.getFolderSourceGroup((SourceGroup[])ProjectUtils.getSources((Project)project).getSourceGroups("java"), (FileObject)folder);
                    if (sourceGroup == null) {
                        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.MSG_NoSourceGroup(folder.getPath()), 0));
                        return Collections.emptyList();
                    }
                    if (!Utils.isDBSupported(sourceGroup) && !Utils.isJPASupported(sourceGroup)) {
                        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.MSG_NoDdSupport(folder.getPath()), 0));
                        return Collections.emptyList();
                    }
                    DatabaseConnection connection = ConnectionManager.getDefault().getPreferredConnection(true);
                    if (connection == null) {
                        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.MSG_NoDbConn(), 0));
                        return Collections.emptyList();
                    }
                    boolean jpaSupported = Utils.isJPASupported(sourceGroup);
                    Map entity2idTypes = MicronautRepository.getEntityClasses(sourceGroup, jpaSupported);
                    ArrayList<NotifyDescriptor.QuickPick.Item> entities = new ArrayList<NotifyDescriptor.QuickPick.Item>();
                    for (String entityFQN : entity2idTypes.keySet()) {
                        int idx = entityFQN.lastIndexOf(46);
                        if (idx < 0) {
                            entities.add(new NotifyDescriptor.QuickPick.Item(entityFQN, null));
                            continue;
                        }
                        entities.add(new NotifyDescriptor.QuickPick.Item(entityFQN.substring(idx + 1), entityFQN.substring(0, idx)));
                    }
                    if (entities.isEmpty()) {
                        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.MSG_NoEntities(sourceGroup.getRootFolder().getPath()), 0));
                        return Collections.emptyList();
                    }
                    ArrayList<NotifyDescriptor.QuickPick.Item> repoType = new ArrayList<NotifyDescriptor.QuickPick.Item>();
                    NotifyDescriptor.QuickPick.Item pageableItem = new NotifyDescriptor.QuickPick.Item(Bundle.MSG_PageableRepository(), null);
                    repoType.add(new NotifyDescriptor.QuickPick.Item(Bundle.MSG_CrudRepository(), null));
                    repoType.add(pageableItem);
                    NotifyDescriptor.QuickPick qpt = new NotifyDescriptor.QuickPick(Bundle.MSG_Repository_Type(), Bundle.MSG_Repository_Type(), repoType, false);
                    if (DialogDescriptor.OK_OPTION != DialogDisplayer.getDefault().notify((NotifyDescriptor)qpt)) {
                        return Collections.emptyList();
                    }
                    NotifyDescriptor.QuickPick qp = new NotifyDescriptor.QuickPick(Bundle.MSG_SelectEntities(), Bundle.MSG_SelectEntities(), entities, true);
                    if (DialogDescriptor.OK_OPTION == DialogDisplayer.getDefault().notify((NotifyDescriptor)qp)) {
                        String dialect = MicronautRepository.getDialect(jpaSupported);
                        ArrayList<FileObject> generated = new ArrayList<FileObject>();
                        for (NotifyDescriptor.QuickPick.Item item : qp.getItems()) {
                            if (!item.isSelected()) continue;
                            String fqn = item.getDescription() != null ? item.getDescription() + '.' + item.getLabel() : item.getLabel();
                            String entityIdType = (String)entity2idTypes.get(fqn);
                            FileObject fo = MicronautRepository.generate(folder, item.getLabel(), fqn, entityIdType, dialect, pageableItem.isSelected());
                            if (fo == null) continue;
                            generated.add(fo);
                        }
                        return generated;
                    }
                }
                catch (Exception ex) {
                    DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)ex.getMessage(), 0));
                }
                return Collections.emptyList();
            }
        };
    }

    public Set<DataObject> instantiate(TemplateWizard wiz) throws IOException {
        String dialect = MicronautRepository.getDialect(this.jpaSupported);
        HashSet<DataObject> generated = new HashSet<DataObject>();
        Map selectedEntities = (Map)wiz.getProperty("wizard-selected-classes");
        for (Map.Entry entry : selectedEntities.entrySet()) {
            String fqn = (String)entry.getKey();
            int idx = fqn.lastIndexOf(46);
            String label = idx < 0 ? fqn : fqn.substring(idx + 1);
            FileObject fo = MicronautRepository.generate(this.targetFolder, label, fqn, (String)entry.getValue(), dialect, false);
            if (fo == null) continue;
            generated.add(DataObject.find((FileObject)fo));
        }
        return generated;
    }

    public void initialize(TemplateWizard wiz) {
        this.wizardDescriptor = wiz;
        this.panel = new ClassesSelectorPanel.WizardPanel(NbBundle.getMessage(MicronautRepository.class, (String)"Templates/Micronaut/Repository"), "Entities", selectedEntities -> selectedEntities.isEmpty() ? NbBundle.getMessage(MicronautRepository.class, (String)"ERR_SelectEntities") : null);
        Wizards.mergeSteps((WizardDescriptor)this.wizardDescriptor, (WizardDescriptor.Panel[])new WizardDescriptor.Panel[]{this.panel}, (String[])new String[]{NbBundle.getMessage(MicronautRepository.class, (String)"LBL_Entities")});
        this.targetFolder = Templates.getTargetFolder((WizardDescriptor)this.wizardDescriptor);
        Project project = Templates.getProject((WizardDescriptor)wiz);
        SourceGroup sourceGroup = SourceGroups.getFolderSourceGroup((SourceGroup[])ProjectUtils.getSources((Project)project).getSourceGroups("java"), (FileObject)this.targetFolder);
        if (sourceGroup != null) {
            this.jpaSupported = Utils.isJPASupported(sourceGroup);
            Map<String, String> entities = MicronautRepository.getEntityClasses(sourceGroup, this.jpaSupported);
            wiz.putProperty("wizard-classes", entities);
        }
    }

    public void uninitialize(TemplateWizard wiz) {
    }

    public WizardDescriptor.Panel<WizardDescriptor> current() {
        return this.panel;
    }

    public String name() {
        return null;
    }

    public boolean hasNext() {
        return false;
    }

    public boolean hasPrevious() {
        return false;
    }

    public void nextPanel() {
        throw new NoSuchElementException();
    }

    public void previousPanel() {
        throw new NoSuchElementException();
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }

    private static Map<String, String> getEntityClasses(SourceGroup sg, boolean jpaSupported) {
        HashMap<String, String> entities = new HashMap<String, String>();
        JavaSource js = JavaSource.create((ClasspathInfo)ClasspathInfo.create((FileObject)sg.getRootFolder()), (FileObject[])new FileObject[0]);
        if (js != null) {
            try {
                js.runWhenScanFinished(cc -> {
                    TypeElement typeElement = cc.getElements().getTypeElement(jpaSupported ? "javax.persistence.Entity" : "io.micronaut.data.annotation.MappedEntity");
                    if (typeElement != null) {
                        TypeElement[] idTypeElements = new TypeElement[]{cc.getElements().getTypeElement(jpaSupported ? "javax.persistence.Id" : "io.micronaut.data.annotation.Id"), cc.getElements().getTypeElement(jpaSupported ? "javax.persistence.EmbeddedId" : "io.micronaut.data.annotation.EmbeddedId")};
                        Set elementHandles = cc.getClasspathInfo().getClassIndex().getElements(ElementHandle.create((Element)typeElement), EnumSet.of(ClassIndex.SearchKind.TYPE_REFERENCES), EnumSet.of(ClassIndex.SearchScope.SOURCE));
                        for (ElementHandle elementHandle : elementHandles) {
                            TypeElement type = (TypeElement)elementHandle.resolve((CompilationInfo)cc);
                            if (type == null) continue;
                            String fqn = null;
                            String idType = null;
                            for (AnnotationMirror annotationMirror : type.getAnnotationMirrors()) {
                                if (fqn != null || typeElement != annotationMirror.getAnnotationType().asElement()) continue;
                                fqn = type.getQualifiedName().toString();
                            }
                            if (fqn == null) continue;
                            for (TypeElement idTypeElement : idTypeElements) {
                                if (idTypeElement == null) continue;
                                for (VariableElement field : ElementFilter.fieldsIn(type.getEnclosedElements())) {
                                    if (idType != null) continue;
                                    for (AnnotationMirror annotationMirror : field.getAnnotationMirrors()) {
                                        if (idType != null || idTypeElement != annotationMirror.getAnnotationType().asElement()) continue;
                                        idType = cc.getTypeUtilities().getTypeName(field.asType(), new TypeUtilities.TypeNameOptions[]{TypeUtilities.TypeNameOptions.PRINT_FQN}).toString();
                                    }
                                }
                            }
                            if (idType == null) {
                                idType = "java.lang.Object";
                            }
                            entities.put(fqn, idType);
                        }
                    }
                }, true);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return entities;
    }

    private static String getDialect(boolean jpaSupported) {
        if (!jpaSupported) {
            DatabaseConnection connection = ConnectionManager.getDefault().getPreferredConnection(true);
            if (connection != null) {
                try {
                    ConnectionManager.getDefault().connect(connection);
                    Connection conn = connection.getJDBCConnection();
                    String name = conn.getMetaData().getDatabaseProductName();
                    if (name.matches("(?i).*h2.*")) {
                        return "H2";
                    }
                    if (name.matches("(?i).*mysql.*")) {
                        return "MYSQL";
                    }
                    if (name.matches("(?i).*oracle.*")) {
                        return "ORACLE";
                    }
                    if (name.matches("(?i).*postgresql.*")) {
                        return "POSTGRES";
                    }
                    if (name.matches("(?i).*microsoft.*")) {
                        return "SQL_SERVER";
                    }
                }
                catch (SQLException | DatabaseException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return "";
        }
        return null;
    }

    private static FileObject generate(FileObject folder, String entityName, String entityFQN, String entityIdType, String dialect, boolean pageable) {
        try {
            JavaSource js;
            String name = entityName + "Repository";
            FileObject fo = GenerationUtils.createInterface((FileObject)folder, (String)name, (String)Bundle.MSG_Repository_Interface(name));
            if (fo != null && (js = JavaSource.forFileObject((FileObject)fo)) != null) {
                js.runModificationTask(copy -> {
                    copy.toPhase(JavaSource.Phase.RESOLVED);
                    Tree origTree = copy.getCompilationUnit().getTypeDecls().get(0);
                    if (origTree.getKind() == Tree.Kind.INTERFACE) {
                        GenerationUtils gu = GenerationUtils.newInstance((WorkingCopy)copy);
                        TreeMaker tm = copy.getTreeMaker();
                        TypeMirror entityIdTM = copy.getTreeUtilities().parseType(entityIdType, (TypeElement)copy.getTrees().getElement(new TreePath(new TreePath(copy.getCompilationUnit()), origTree)));
                        List<ExpressionTree> args = Arrays.asList(tm.QualIdent(entityFQN), entityIdTM != null && entityIdTM.getKind().isPrimitive() ? tm.QualIdent((Element)copy.getTypes().boxedClass((PrimitiveType)entityIdTM)) : tm.QualIdent(entityIdType));
                        String repoFaq = pageable ? PAGEABLE_REPOSITORY : CRUD_REPOSITORY;
                        ParameterizedTypeTree type = tm.ParameterizedType((Tree)tm.QualIdent(repoFaq), args);
                        ClassTree cls = tm.addClassImplementsClause((ClassTree)origTree, (Tree)type);
                        if (dialect == null) {
                            cls = gu.addAnnotation(cls, gu.createAnnotation("io.micronaut.data.annotation.Repository"));
                        } else if (dialect.isEmpty()) {
                            cls = gu.addAnnotation(cls, gu.createAnnotation("io.micronaut.data.jdbc.annotation.JdbcRepository"));
                        } else {
                            List<ExpressionTree> annArgs = Collections.singletonList(gu.createAnnotationArgument("dialect", "io.micronaut.data.model.query.builder.sql.Dialect", dialect));
                            cls = gu.addAnnotation(cls, gu.createAnnotation("io.micronaut.data.jdbc.annotation.JdbcRepository", annArgs));
                        }
                        copy.rewrite(origTree, (Tree)cls);
                    }
                }).commit();
            }
            return fo;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }
}

