/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.queries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.spi.java.queries.CompilerOptionsQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.util.ChangeSupport;
import org.openide.util.Parameters;

public final class PomCompilerOptionsQueryImpl
implements CompilerOptionsQueryImplementation {
    private final AtomicReference<ResultImpl> result;
    private final NbMavenProjectImpl proj;

    public PomCompilerOptionsQueryImpl(NbMavenProjectImpl proj) {
        Parameters.notNull((CharSequence)"proj", (Object)proj);
        this.proj = proj;
        this.result = new AtomicReference();
    }

    @CheckForNull
    public CompilerOptionsQueryImplementation.Result getOptions(@NonNull FileObject file) {
        ResultImpl res = this.result.get();
        if (res == null) {
            res = new ResultImpl(this.proj);
            if (!this.result.compareAndSet(null, res)) {
                res = this.result.get();
            }
            assert (res != null);
        }
        return res;
    }

    private static final class ResultImpl
    extends CompilerOptionsQueryImplementation.Result
    implements PropertyChangeListener {
        private static final List<String> EMPTY = Collections.EMPTY_LIST;
        private static final String ARG_PARAMETERS = "-parameters";
        private final ChangeSupport cs;
        private List<String> cache;
        private final NbMavenProjectImpl proj;

        ResultImpl(NbMavenProjectImpl proj) {
            this.proj = proj;
            proj.getProjectWatcher().addPropertyChangeListener(this);
            this.cs = new ChangeSupport((Object)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<? extends String> getArguments() {
            List<String> args;
            ResultImpl resultImpl = this;
            synchronized (resultImpl) {
                args = this.cache;
            }
            if (args == null) {
                args = this.createArguments();
                resultImpl = this;
                synchronized (resultImpl) {
                    if (this.cache == null) {
                        this.cache = args;
                    } else {
                        args = this.cache;
                    }
                }
            }
            return args;
        }

        private List<String> createArguments() {
            String[] compilerArgs = PluginPropertyUtils.getPluginPropertyList(this.proj, "org.apache.maven.plugins", "maven-compiler-plugin", "compilerArgs", "arg", null);
            if (compilerArgs != null) {
                ArrayList<String> args = new ArrayList<String>();
                for (String compilerArg : compilerArgs) {
                    if (compilerArg == null || compilerArg.isEmpty()) continue;
                    args.add(compilerArg);
                }
                return args;
            }
            return EMPTY;
        }

        public void addChangeListener(@NonNull ChangeListener listener) {
            this.cs.addChangeListener(listener);
        }

        public void removeChangeListener(@NonNull ChangeListener listener) {
            this.cs.removeChangeListener(listener);
        }

        @Override
        public void propertyChange(@NonNull PropertyChangeEvent evt) {
            if ("MavenProject".equals(evt.getPropertyName())) {
                this.reset();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void reset() {
            ResultImpl resultImpl = this;
            synchronized (resultImpl) {
                this.cache = null;
            }
            this.cs.fireChange();
        }
    }
}

