/*
 * Decompiled with CFR 0.152.
 */
package org.apache.subversion.javahl.types;

import java.io.Serializable;
import java.util.Date;
import org.apache.subversion.javahl.types.Depth;
import org.apache.subversion.javahl.types.Lock;
import org.apache.subversion.javahl.types.NodeKind;
import org.apache.subversion.javahl.types.Revision;

public class Status
implements Serializable {
    private static final long serialVersionUID = 3L;
    private String url;
    private String path;
    private NodeKind nodeKind;
    private long revision;
    private long lastChangedRevision;
    private long lastChangedDate;
    private String lastCommitAuthor;
    private Kind nodeStatus;
    private Kind textStatus;
    private Kind propStatus;
    private boolean locked;
    private boolean copied;
    private boolean switched;
    private boolean fileExternal;
    private Depth depth;
    private boolean isConflicted;
    private Kind repositoryNodeStatus;
    private Kind repositoryTextStatus;
    private Kind repositoryPropStatus;
    private Lock localLock;
    private Lock reposLock;
    private long reposLastCmtRevision = -1L;
    private long reposLastCmtDate = 0L;
    private NodeKind reposKind = NodeKind.none;
    private String reposLastCmtAuthor;
    private String changelist;
    private String movedFromAbspath;
    private String movedToAbspath;

    public Status(String path, String url, NodeKind nodeKind, long revision, long lastChangedRevision, long lastChangedDate, String lastCommitAuthor, Kind nodeStatus, Kind textStatus, Kind propStatus, Kind repositoryNodeStatus, Kind repositoryTextStatus, Kind repositoryPropStatus, boolean locked, boolean copied, Depth depth, boolean isConflicted, boolean switched, boolean fileExternal, Lock localLock, Lock reposLock, long reposLastCmtRevision, long reposLastCmtDate, NodeKind reposKind, String reposLastCmtAuthor, String changelist, String movedFromAbspath, String movedToAbspath) {
        this.path = path;
        this.url = url;
        this.nodeKind = nodeKind != null ? nodeKind : NodeKind.unknown;
        this.revision = revision;
        this.lastChangedRevision = lastChangedRevision;
        this.lastChangedDate = lastChangedDate;
        this.lastCommitAuthor = lastCommitAuthor;
        this.nodeStatus = nodeStatus;
        this.textStatus = textStatus;
        this.propStatus = propStatus;
        this.repositoryNodeStatus = repositoryNodeStatus;
        this.repositoryTextStatus = repositoryTextStatus;
        this.repositoryPropStatus = repositoryPropStatus;
        this.locked = locked;
        this.copied = copied;
        this.depth = depth;
        this.isConflicted = isConflicted;
        this.switched = switched;
        this.fileExternal = fileExternal;
        this.localLock = localLock;
        this.reposLock = reposLock;
        this.reposLastCmtRevision = reposLastCmtRevision;
        this.reposLastCmtDate = reposLastCmtDate;
        this.reposKind = reposKind;
        this.reposLastCmtAuthor = reposLastCmtAuthor;
        this.changelist = changelist;
        this.movedFromAbspath = movedFromAbspath;
        this.movedToAbspath = movedToAbspath;
    }

    @Deprecated
    public Status(String path, String url, NodeKind nodeKind, long revision, long lastChangedRevision, long lastChangedDate, String lastCommitAuthor, Kind textStatus, Kind propStatus, Kind repositoryTextStatus, Kind repositoryPropStatus, boolean locked, boolean copied, boolean isConflicted, boolean switched, boolean fileExternal, Lock localLock, Lock reposLock, long reposLastCmtRevision, long reposLastCmtDate, NodeKind reposKind, String reposLastCmtAuthor, String changelist, String movedFromAbspath, String movedToAbspath) {
        this(path, url, nodeKind, revision, lastChangedRevision, lastChangedDate, lastCommitAuthor, Kind.none, textStatus, propStatus, Kind.none, repositoryTextStatus, repositoryPropStatus, locked, copied, Depth.unknown, isConflicted, switched, fileExternal, localLock, reposLock, reposLastCmtRevision, reposLastCmtDate, reposKind, reposLastCmtAuthor, changelist, movedFromAbspath, movedToAbspath);
    }

    public String getPath() {
        return this.path;
    }

    public Revision.Number getRevision() {
        return Revision.createNumber(this.revision);
    }

    public long getRevisionNumber() {
        return this.revision;
    }

    public Date getLastChangedDate() {
        return Status.microsecondsToDate(this.lastChangedDate);
    }

    public long getLastChangedDateMicros() {
        return this.lastChangedDate;
    }

    public String getLastCommitAuthor() {
        return this.lastCommitAuthor;
    }

    public Kind getNodeStatus() {
        return this.nodeStatus;
    }

    public String getNodeStatusDescription() {
        return this.nodeStatus.toString();
    }

    public Kind getRawTextStatus() {
        return this.textStatus;
    }

    public String getRawTextStatusDescription() {
        return this.textStatus.toString();
    }

    public Kind getTextStatus() {
        if (this.nodeStatus == Kind.modified || this.nodeStatus == Kind.conflicted) {
            return this.textStatus;
        }
        return this.nodeStatus;
    }

    public String getTextStatusDescription() {
        return this.getTextStatus().toString();
    }

    public Kind getPropStatus() {
        return this.propStatus;
    }

    public String getPropStatusDescription() {
        return this.propStatus.toString();
    }

    public Kind getRepositoryNodeStatus() {
        return this.repositoryNodeStatus;
    }

    public Kind getRawRepositoryTextStatus() {
        return this.repositoryTextStatus;
    }

    public Kind getRepositoryTextStatus() {
        if (this.repositoryNodeStatus == Kind.modified || this.repositoryNodeStatus == Kind.conflicted) {
            return this.repositoryTextStatus;
        }
        return this.repositoryNodeStatus;
    }

    public Kind getRepositoryPropStatus() {
        return this.repositoryPropStatus;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public boolean isCopied() {
        return this.copied;
    }

    public String getUrl() {
        return this.url;
    }

    public Revision.Number getLastChangedRevision() {
        return Revision.createNumber(this.lastChangedRevision);
    }

    public long getLastChangedRevisionNumber() {
        return this.lastChangedRevision;
    }

    public NodeKind getNodeKind() {
        return this.nodeKind;
    }

    public boolean isSwitched() {
        return this.switched;
    }

    public boolean isFileExternal() {
        return this.fileExternal;
    }

    public boolean isManaged() {
        Kind status = this.getNodeStatus();
        return status != Kind.unversioned && status != Kind.none && status != Kind.ignored;
    }

    public boolean hasRemote() {
        return this.isManaged() && !this.isAdded();
    }

    public boolean isAdded() {
        return this.getNodeStatus() == Kind.added;
    }

    public boolean isDeleted() {
        return this.getNodeStatus() == Kind.deleted;
    }

    public boolean isMerged() {
        return this.getNodeStatus() == Kind.merged;
    }

    public boolean isIgnored() {
        return this.getNodeStatus() == Kind.ignored;
    }

    public boolean isModified() {
        return this.getTextStatus() == Kind.modified;
    }

    public Lock getLocalLock() {
        return this.localLock;
    }

    public Lock getReposLock() {
        return this.reposLock;
    }

    public Revision.Number getReposLastCmtRevision() {
        return Revision.createNumber(this.reposLastCmtRevision);
    }

    public long getReposLastCmtRevisionNumber() {
        return this.reposLastCmtRevision;
    }

    public Date getReposLastCmtDate() {
        return Status.microsecondsToDate(this.reposLastCmtDate);
    }

    public long getReposLastCmtDateMicros() {
        return this.reposLastCmtDate;
    }

    public NodeKind getReposKind() {
        return this.reposKind;
    }

    public String getReposLastCmtAuthor() {
        return this.reposLastCmtAuthor;
    }

    public String getChangelist() {
        return this.changelist;
    }

    public boolean isConflicted() {
        return this.isConflicted;
    }

    public String getMovedFromAbspath() {
        return this.movedFromAbspath;
    }

    public String getMovedToAbspath() {
        return this.movedToAbspath;
    }

    public Depth getDepth() {
        return this.depth;
    }

    private static Date microsecondsToDate(long micros) {
        return micros == 0L ? null : new Date(micros / 1000L);
    }

    public static enum Kind {
        none("non-svn"),
        unversioned("unversioned"),
        normal("normal"),
        added("added"),
        missing("missing"),
        deleted("deleted"),
        replaced("replaced"),
        modified("modified"),
        merged("merged"),
        conflicted("conflicted"),
        ignored("ignored"),
        obstructed("obstructed"),
        external("external"),
        incomplete("incomplete");

        private String description;

        private Kind(String description) {
            this.description = description;
        }

        public String toString() {
            return this.description;
        }
    }
}

