/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.swing;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import org.netbeans.lib.profiler.ui.swing.ProfilerRowSorter;
import org.netbeans.lib.profiler.ui.swing.ProfilerTable;

class ProfilerColumnModel
extends DefaultTableColumnModel {
    private static final String PROP_COLUMN_WIDTH = "width";
    private int fitWidthColumn = 0;
    private int refWidth = -1;
    private Map<Integer, Integer> columnOffsets;
    private Map<Integer, Integer> columnPreferredWidths;
    private int minColumnWidth = 20;
    private int defaultColumnWidth = 60;
    private Map<Integer, Integer> defaultColumnWidths;
    private Map<Integer, Integer> hiddenColumnWidths = new HashMap<Integer, Integer>();
    private String[] toolTips;
    private Set<Listener> columnListeners;
    private static final String COLUMN_INDEX_KEY = "ProfilerColumnModel.ColumnIndex";
    private static final String COLUMN_WIDTH_KEY = "ProfilerColumnModel.ColumnWidth";

    ProfilerColumnModel() {
    }

    void setFitWidthColumn(int column) {
        this.fitWidthColumn = column;
    }

    int getFitWidthColumn() {
        return this.fitWidthColumn;
    }

    boolean hasFitWidthColumn() {
        return this.fitWidthColumn != -1;
    }

    void setResizingColumn(TableColumn column) {
        this.refWidth = -1;
    }

    TableColumn createTableColumn(int columnIndex) {
        return new TableColumn(columnIndex){

            @Override
            public void setWidth(int width) {
                if (this.getMaxWidth() == 0 && this.getWidth() == 0) {
                    TableColumn c = ProfilerColumnModel.this.getPreviousVisibleColumn(this);
                    if (ProfilerColumnModel.this.refWidth == -1) {
                        ProfilerColumnModel.this.refWidth = c.getWidth();
                    }
                    c.setWidth(ProfilerColumnModel.this.refWidth + width);
                } else {
                    super.setWidth(width);
                }
            }
        };
    }

    @Override
    public void addColumn(TableColumn column) {
        super.addColumn(column);
        final int index = column.getModelIndex();
        column.addPropertyChangeListener(new PropertyChangeListener(){
            final /* synthetic */ ProfilerColumnModel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (ProfilerColumnModel.PROP_COLUMN_WIDTH.equals(evt.getPropertyName())) {
                    int oldWidth = (Integer)evt.getOldValue();
                    int newWidth = (Integer)evt.getNewValue();
                    this.this$0.fireColumnWidthChanged(index, oldWidth, newWidth);
                }
            }
        });
    }

    boolean setColumnOffset(int column, int offset) {
        boolean change;
        Integer previousOffset;
        if (this.columnOffsets == null) {
            this.columnOffsets = new HashMap<Integer, Integer>();
        }
        int _previousOffset = (previousOffset = this.columnOffsets.put(column, offset)) == null ? 0 : previousOffset;
        boolean bl = change = _previousOffset != offset;
        if (change) {
            this.fireColumnOffsetChanged(column, _previousOffset, offset);
        }
        return change;
    }

    int getColumnOffset(int column) {
        if (this.columnOffsets == null) {
            return 0;
        }
        Integer offset = this.columnOffsets.get(column);
        return offset == null ? 0 : offset;
    }

    void clearColumnsPrefferedWidth() {
        if (this.columnPreferredWidths != null) {
            this.columnPreferredWidths.clear();
        }
    }

    boolean setColumnPreferredWidth(int column, int width) {
        boolean change;
        Integer previousWidth;
        if (this.columnPreferredWidths == null) {
            this.columnPreferredWidths = new HashMap<Integer, Integer>();
        }
        int _previousWidth = (previousWidth = this.columnPreferredWidths.put(column, width)) == null ? 0 : previousWidth;
        boolean bl = change = _previousWidth != width;
        if (change) {
            this.fireColumnPreferredWidthChanged(column, _previousWidth, width);
        }
        return change;
    }

    int getColumnPreferredWidth(int column) {
        if (this.columnPreferredWidths == null) {
            return 0;
        }
        Integer width = this.columnPreferredWidths.get(column);
        return width == null ? 0 : width;
    }

    void setDefaultColumnWidth(int width) {
        this.defaultColumnWidth = width;
        Enumeration<TableColumn> columns = this.getColumns();
        while (columns.hasMoreElements()) {
            TableColumn column = columns.nextElement();
            int index = column.getModelIndex();
            if (this.defaultColumnWidths != null && this.defaultColumnWidths.get(index) != null || index == this.fitWidthColumn) continue;
            column.setWidth(width);
        }
    }

    void setDefaultColumnWidth(int column, int width) {
        if (this.defaultColumnWidths == null) {
            this.defaultColumnWidths = new HashMap<Integer, Integer>();
        }
        this.defaultColumnWidths.put(column, width);
        if (this.isColumnVisible(column)) {
            TableColumn c = this.getModelColumn(column);
            if (c != null) {
                c.setWidth(width);
            }
        } else {
            this.hiddenColumnWidths.put(column, width);
        }
    }

    int getDefaultColumnWidth(int column) {
        Integer width = this.defaultColumnWidths == null ? null : this.defaultColumnWidths.get(column);
        return width == null ? this.defaultColumnWidth : width;
    }

    void setColumnVisibility(TableColumn column, boolean visible, ProfilerTable table) {
        if (visible) {
            this.showColumn(column, table);
        } else {
            this.hideColumn(column, table);
        }
    }

    boolean isColumnVisible(int column) {
        return this.isColumnVisible(this.getModelColumn(column));
    }

    boolean isColumnVisible(TableColumn column) {
        return column.getMaxWidth() > 0;
    }

    int getVisibleColumnCount() {
        return this.getColumnCount() - this.hiddenColumnWidths.size();
    }

    void showColumn(TableColumn column, ProfilerTable table) {
        column.setMaxWidth(Integer.MAX_VALUE);
        Integer width = this.hiddenColumnWidths.remove(column.getModelIndex());
        column.setWidth(width != null ? width.intValue() : this.getDefaultColumnWidth(column.getModelIndex()));
        column.setMinWidth(this.minColumnWidth);
        int toResizeIndex = this.getFitWidthColumn();
        if (column.getModelIndex() == toResizeIndex) {
            Enumeration<TableColumn> columns = this.getColumns();
            while (columns.hasMoreElements()) {
                TableColumn col = columns.nextElement();
                int index = col.getModelIndex();
                if (col.getModelIndex() == toResizeIndex || !this.isColumnVisible(col)) continue;
                col.setWidth(this.getDefaultColumnWidth(index));
            }
            table.doLayout();
        }
    }

    void hideColumn(TableColumn column, ProfilerTable table) {
        ProfilerRowSorter sorter;
        int sortColumn;
        this.hiddenColumnWidths.put(column.getModelIndex(), column.getWidth());
        column.setMinWidth(0);
        column.setMaxWidth(0);
        int selected = table.getSelectedColumn();
        if (selected != -1 && this.getColumn(selected).equals(column)) {
            int newSelected = this.getPreviousVisibleColumn(selected);
            this.getSelectionModel().setSelectionInterval(newSelected, newSelected);
        }
        if (table.isSortable() && (sortColumn = (sorter = table._getRowSorter()).getSortColumn()) == column.getModelIndex()) {
            int newSortColumn = table.convertColumnIndexToView(sortColumn);
            newSortColumn = this.getPreviousVisibleColumn(newSortColumn);
            sorter.setSortColumn(this.getColumn(newSortColumn).getModelIndex());
        }
    }

    int getFirstVisibleColumn() {
        int firstColumn = 0;
        return this.isColumnVisible(this.getColumn(firstColumn)) ? firstColumn : this.getNextVisibleColumn(firstColumn);
    }

    int getLastVisibleColumn() {
        int lastColumn = this.getColumnCount() - 1;
        return this.isColumnVisible(this.getColumn(lastColumn)) ? lastColumn : this.getPreviousVisibleColumn(lastColumn);
    }

    TableColumn getNextVisibleColumn(TableColumn column) {
        int columnIndex = this.tableColumns.indexOf(column);
        int nextIndex = this.getNextVisibleColumn(columnIndex);
        return this.getColumn(nextIndex);
    }

    int getNextVisibleColumn(int column) {
        while (!this.isColumnVisible(this.getColumn(column = this.getNextColumn(column)))) {
        }
        return column;
    }

    TableColumn getPreviousVisibleColumn(TableColumn column) {
        int columnIndex = this.tableColumns.indexOf(column);
        int previousIndex = this.getPreviousVisibleColumn(columnIndex);
        return this.getColumn(previousIndex);
    }

    int getPreviousVisibleColumn(int column) {
        while (!this.isColumnVisible(this.getColumn(column = this.getPreviousColumn(column)))) {
        }
        return column;
    }

    private int getNextColumn(int column) {
        return ++column == this.getColumnCount() ? 0 : column;
    }

    private int getPreviousColumn(int column) {
        return --column == -1 ? this.getColumnCount() - 1 : column;
    }

    private TableColumn getModelColumn(int modelIndex) {
        Enumeration<TableColumn> columns = this.getColumns();
        while (columns.hasMoreElements()) {
            TableColumn column = columns.nextElement();
            if (column.getModelIndex() != modelIndex) continue;
            return column;
        }
        return null;
    }

    void setColumnToolTips(String[] toolTips) {
        this.toolTips = Arrays.copyOf(toolTips, toolTips.length);
    }

    String getColumnToolTip(int column) {
        if (this.toolTips == null) {
            return null;
        }
        return column < 0 || column >= this.toolTips.length ? null : this.toolTips[column];
    }

    void addColumnChangeListener(Listener listener) {
        if (this.columnListeners == null) {
            this.columnListeners = new HashSet<Listener>();
        }
        this.columnListeners.add(listener);
    }

    void removeColumnChangeListener(Listener listener) {
        if (this.columnListeners == null) {
            return;
        }
        this.columnListeners.remove(listener);
        if (this.columnListeners.isEmpty()) {
            this.columnListeners = null;
        }
    }

    private void fireColumnOffsetChanged(int column, int oldOffset, int newOffset) {
        if (this.columnListeners == null) {
            return;
        }
        for (Listener listener : this.columnListeners) {
            listener.columnOffsetChanged(column, oldOffset, newOffset);
        }
    }

    private void fireColumnWidthChanged(int column, int oldWidth, int newWidth) {
        if (this.columnListeners == null) {
            return;
        }
        for (Listener listener : this.columnListeners) {
            listener.columnWidthChanged(column, oldWidth, newWidth);
        }
    }

    private void fireColumnPreferredWidthChanged(int column, int oldWidth, int newWidth) {
        if (this.columnListeners == null) {
            return;
        }
        for (Listener listener : this.columnListeners) {
            listener.columnPreferredWidthChanged(column, oldWidth, newWidth);
        }
    }

    void loadFromStorage(Properties properties, ProfilerTable table) {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            String indexS = properties.getProperty("ProfilerColumnModel.ColumnIndex." + i);
            if (indexS == null) continue;
            try {
                int index = Integer.parseInt(indexS);
                int width = this.getDefaultColumnWidth(index);
                String widthS = properties.getProperty("ProfilerColumnModel.ColumnWidth." + i);
                if (widthS != null) {
                    try {
                        width = Integer.parseInt(widthS);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                TableColumn column = this.getModelColumn(index);
                column.setIdentifier(i);
                if (index == this.getFitWidthColumn()) continue;
                if (width == 0) {
                    this.hideColumn(column, table);
                    continue;
                }
                column.setWidth(width);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.tableColumns.sort(new Comparator<TableColumn>(){

            @Override
            public int compare(TableColumn c1, TableColumn c2) {
                Integer index1 = (Integer)c1.getIdentifier();
                Integer index2 = (Integer)c2.getIdentifier();
                return index1.compareTo(index2);
            }
        });
    }

    void saveToStorage(Properties properties, ProfilerTable table) {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            TableColumn column = this.getColumn(i);
            properties.setProperty("ProfilerColumnModel.ColumnIndex." + i, Integer.toString(column.getModelIndex()));
            properties.setProperty("ProfilerColumnModel.ColumnWidth." + i, Integer.toString(column.getWidth()));
        }
    }

    static interface Listener {
        public void columnOffsetChanged(int var1, int var2, int var3);

        public void columnWidthChanged(int var1, int var2, int var3);

        public void columnPreferredWidthChanged(int var1, int var2, int var3);
    }
}

