/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jpa.verification.rules.entity;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import javax.lang.model.element.TypeElement;
import org.netbeans.modules.j2ee.jpa.model.ModelUtils;
import org.netbeans.modules.j2ee.jpa.verification.JPAProblemContext;
import org.netbeans.modules.j2ee.jpa.verification.common.Utilities;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Entity;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.EntityMappingsMetadata;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.openide.util.NbBundle;

public class UniqueEntityName {
    public static ErrorDescription apply(final HintContext hc) {
        if (hc.isCanceled() || hc.getPath().getLeaf().getKind() != Tree.Kind.IDENTIFIER || hc.getPath().getParentPath().getLeaf().getKind() != Tree.Kind.ANNOTATION) {
            return null;
        }
        final JPAProblemContext ctx = ModelUtils.getOrCreateCachedContext(hc);
        if (ctx == null || hc.isCanceled() || ctx.getModelElement() == null || !(ctx.getModelElement() instanceof Entity)) {
            return null;
        }
        final ErrorDescription[] ret = new ErrorDescription[]{null};
        MetadataModel<EntityMappingsMetadata> model = ModelUtils.getModel(hc.getInfo().getFileObject());
        try {
            model.runReadAction((MetadataModelAction)new MetadataModelAction<EntityMappingsMetadata, Void>(){

                public Void run(EntityMappingsMetadata metadata) {
                    String thisEntityName = ((Entity)ctx.getModelElement()).getName();
                    TypeElement subject = ctx.getJavaClass();
                    for (Entity entity : ctx.getMetaData().getRoot().getEntity()) {
                        TreePath par;
                        if (!entity.getName().contentEquals(thisEntityName) || subject.getQualifiedName().contentEquals(entity.getClass2())) continue;
                        for (par = hc.getPath(); par != null && par.getParentPath() != null && par.getLeaf().getKind() != Tree.Kind.CLASS; par = par.getParentPath()) {
                        }
                        Utilities.TextSpan underlineSpan = Utilities.getUnderlineSpan(ctx.getCompilationInfo(), par.getLeaf());
                        ret[0] = ErrorDescriptionFactory.forSpan((HintContext)hc, (int)underlineSpan.getStartOffset(), (int)underlineSpan.getEndOffset(), (String)NbBundle.getMessage(UniqueEntityName.class, (String)"MSG_NonUniqueEntityName", (Object)entity.getClass2()), (Fix[])new Fix[0]);
                        break;
                    }
                    return null;
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ret[0];
    }
}

