/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.js.parser;

import com.oracle.js.parser.Lexer;

public final class JSType {
    private static final long MAX_UINT = 0xFFFFFFFFL;
    private static final double INT32_LIMIT = 4.294967296E9;
    private static final long MAX_PRECISE_DOUBLE = 0x20000000000000L;
    private static final long MIN_PRECISE_DOUBLE = -9007199254740992L;

    private JSType() {
    }

    public static boolean isRepresentableAsInt(long number) {
        return (long)((int)number) == number;
    }

    public static boolean isRepresentableAsInt(double number) {
        return (double)((int)number) == number;
    }

    public static boolean isStrictlyRepresentableAsInt(double number) {
        return JSType.isRepresentableAsInt(number) && JSType.isNotNegativeZero(number);
    }

    public static boolean isRepresentableAsInt(Object obj) {
        if (obj instanceof Number) {
            return JSType.isRepresentableAsInt(((Number)obj).doubleValue());
        }
        return false;
    }

    public static boolean isRepresentableAsLong(double number) {
        return (double)((long)number) == number;
    }

    public static boolean isStrictlyRepresentableAsLong(double number) {
        return JSType.isRepresentableAsLong(number) && JSType.isNotNegativeZero(number);
    }

    public static boolean isRepresentableAsLong(Object obj) {
        if (obj instanceof Number) {
            return JSType.isRepresentableAsLong(((Number)obj).doubleValue());
        }
        return false;
    }

    public static boolean isNegativeZero(double number) {
        return number == 0.0 && Double.doubleToRawLongBits(number) == Long.MIN_VALUE;
    }

    private static boolean isNotNegativeZero(double number) {
        return Double.doubleToRawLongBits(number) != Long.MIN_VALUE;
    }

    public static boolean toBoolean(double num) {
        return num != 0.0 && !Double.isNaN(num);
    }

    public static boolean toBoolean(Object obj) {
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof Number) {
            double num = ((Number)obj).doubleValue();
            return num != 0.0 && !Double.isNaN(num);
        }
        if (obj instanceof String) {
            return ((String)obj).length() > 0;
        }
        return true;
    }

    public static String toString(double num, int radix) {
        assert (radix >= 2 && radix <= 36) : "invalid radix";
        if (JSType.isRepresentableAsInt(num)) {
            return Integer.toString((int)num, radix);
        }
        if (num == Double.POSITIVE_INFINITY) {
            return "Infinity";
        }
        if (num == Double.NEGATIVE_INFINITY) {
            return "-Infinity";
        }
        if (Double.isNaN(num)) {
            return "NaN";
        }
        if (num == 0.0) {
            return "0";
        }
        String chars = "0123456789abcdefghijklmnopqrstuvwxyz";
        StringBuilder sb = new StringBuilder();
        boolean negative = num < 0.0;
        double signedNum = negative ? -num : num;
        double intPart = Math.floor(signedNum);
        double decPart = signedNum - intPart;
        do {
            double remainder = intPart % (double)radix;
            sb.append("0123456789abcdefghijklmnopqrstuvwxyz".charAt((int)remainder));
            intPart -= remainder;
        } while ((intPart /= (double)radix) >= 1.0);
        if (negative) {
            sb.append('-');
        }
        sb.reverse();
        if (decPart > 0.0) {
            double d;
            int dot = sb.length();
            sb.append('.');
            do {
                d = Math.floor(decPart *= (double)radix);
                sb.append("0123456789abcdefghijklmnopqrstuvwxyz".charAt((int)d));
            } while ((decPart -= d) > 0.0 && sb.length() - dot < 1100);
        }
        return sb.toString();
    }

    public static double toNumber(Object obj) {
        if (obj instanceof Number) {
            return ((Number)obj).doubleValue();
        }
        return JSType.toNumberGeneric(obj);
    }

    public static int digit(char ch, int radix) {
        return JSType.digit(ch, radix, false);
    }

    public static int digit(char ch, int radix, boolean onlyIsoLatin1) {
        char maxInRadix = (char)(97 + (radix - 1) - 10);
        char c = Character.toLowerCase(ch);
        if (c >= 'a' && c <= maxInRadix) {
            return Character.digit(ch, radix);
        }
        if (Character.isDigit(ch) && (!onlyIsoLatin1 || ch >= '0' && ch <= '9')) {
            return Character.digit(ch, radix);
        }
        return -1;
    }

    public static double toNumber(String str) {
        double value;
        boolean negative;
        int end = str.length();
        if (end == 0) {
            return 0.0;
        }
        int start = 0;
        char f = str.charAt(0);
        while (Lexer.isJSWhitespace(f)) {
            if (++start == end) {
                return 0.0;
            }
            f = str.charAt(start);
        }
        while (Lexer.isJSWhitespace(str.charAt(end - 1))) {
            --end;
        }
        if (f == '-') {
            if (++start == end) {
                return Double.NaN;
            }
            f = str.charAt(start);
            negative = true;
        } else {
            if (f == '+') {
                if (++start == end) {
                    return Double.NaN;
                }
                f = str.charAt(start);
            }
            negative = false;
        }
        if (start + 1 < end && f == '0' && Character.toLowerCase(str.charAt(start + 1)) == 'x') {
            value = JSType.parseRadix(str.toCharArray(), start + 2, end, 16);
        } else {
            if (f == 'I' && end - start == 8 && str.regionMatches(start, "Infinity", 0, 8)) {
                return negative ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
            for (int i = start; i < end; ++i) {
                f = str.charAt(i);
                if (f >= '0' && f <= '9' || f == '.' || f == 'e' || f == 'E' || f == '+' || f == '-') continue;
                return Double.NaN;
            }
            try {
                value = Double.parseDouble(str.substring(start, end));
            }
            catch (NumberFormatException e) {
                return Double.NaN;
            }
        }
        return negative ? -value : value;
    }

    public static long toLong(Object obj) {
        return obj instanceof Long ? (Long)obj : JSType.toLong(JSType.toNumber(obj));
    }

    public static long toLong(double num) {
        return (long)num;
    }

    public static int toInt32(Object obj) {
        return JSType.toInt32(JSType.toNumber(obj));
    }

    public static int toInt32(long num) {
        return (int)(num >= -9007199254740992L && num <= 0x20000000000000L ? num : (long)((double)num % 4.294967296E9));
    }

    public static int toInt32(double num) {
        return (int)JSType.doubleToInt32(num);
    }

    public static long toUint32(Object obj) {
        return JSType.toUint32(JSType.toNumber(obj));
    }

    public static long toUint32(double num) {
        return JSType.doubleToInt32(num) & 0xFFFFFFFFL;
    }

    public static int toUint16(Object obj) {
        return JSType.toUint16(JSType.toNumber(obj));
    }

    public static int toUint16(int num) {
        return num & 0xFFFF;
    }

    public static int toUint16(long num) {
        return (int)num & 0xFFFF;
    }

    public static int toUint16(double num) {
        return (int)JSType.doubleToInt32(num) & 0xFFFF;
    }

    private static long doubleToInt32(double num) {
        int exponent = Math.getExponent(num);
        if (exponent < 31) {
            return (long)num;
        }
        if (exponent >= 84) {
            return 0L;
        }
        double d = num >= 0.0 ? Math.floor(num) : Math.ceil(num);
        return (long)(d % 4.294967296E9);
    }

    public static boolean isFinite(double num) {
        return !Double.isInfinite(num) && !Double.isNaN(num);
    }

    private static double parseRadix(char[] chars, int start, int length, int radix) {
        int pos = 0;
        for (int i = start; i < length; ++i) {
            if (JSType.digit(chars[i], radix) == -1) {
                return Double.NaN;
            }
            ++pos;
        }
        if (pos == 0) {
            return Double.NaN;
        }
        double value = 0.0;
        for (int i = start; i < start + pos; ++i) {
            value *= (double)radix;
            value += (double)JSType.digit(chars[i], radix);
        }
        return value;
    }

    private static double toNumberGeneric(Object obj) {
        if (obj == null) {
            return 0.0;
        }
        if (obj instanceof String) {
            return JSType.toNumber((String)obj);
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj != false ? 1.0 : 0.0;
        }
        return Double.NaN;
    }
}

