/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.gsf;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import org.netbeans.api.editor.fold.FoldType;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.StructureItem;
import org.netbeans.modules.csl.api.StructureScanner;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.html.editor.gsf.Bundle;
import org.netbeans.modules.html.editor.gsf.HtmlElementHandle;
import org.netbeans.modules.html.editor.gsf.HtmlStructureItem;
import org.netbeans.modules.html.editor.lib.api.elements.Element;
import org.netbeans.modules.html.editor.lib.api.elements.ElementType;
import org.netbeans.modules.html.editor.lib.api.elements.ElementUtils;
import org.netbeans.modules.html.editor.lib.api.elements.ElementVisitor;
import org.netbeans.modules.html.editor.lib.api.elements.Node;
import org.netbeans.modules.html.editor.lib.api.elements.OpenTag;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.web.common.api.Lines;
import org.openide.filesystems.FileObject;
import org.openide.util.Pair;

public class HtmlStructureScanner
implements StructureScanner {
    public static final FoldType TYPE_TAG = FoldType.TAG.override(Bundle.FT_Tag(), FoldType.TAG.getTemplate());
    public static final FoldType TYPE_COMMENT = FoldType.COMMENT;
    private static final Logger LOGGER = Logger.getLogger(HtmlStructureScanner.class.getName());
    private static final boolean LOG = LOGGER.isLoggable(Level.FINE);
    private static final long MAX_SNAPSHOT_SIZE = 0x400000L;
    private Reference<Pair<ParserResult, List<HtmlStructureItem>>> cache;

    private static boolean isOfSupportedSize(ParserResult info) {
        Snapshot snapshot = info.getSnapshot();
        int slen = snapshot.getText().length();
        return (long)slen < 0x400000L;
    }

    public List<? extends StructureItem> scan(ParserResult info) {
        Pair<ParserResult, List<HtmlStructureItem>> pair;
        if (this.cache != null && (pair = this.cache.get()) != null && info == pair.first()) {
            return (List)pair.second();
        }
        if (!HtmlStructureScanner.isOfSupportedSize(info)) {
            return Collections.emptyList();
        }
        HtmlParserResult presult = (HtmlParserResult)info;
        Node root = presult.root();
        if (LOG) {
            LOGGER.log(Level.FINE, "HTML parser tree output:");
            LOGGER.log(Level.FINE, root.toString());
        }
        Snapshot snapshot = info.getSnapshot();
        FileObject file = snapshot.getSource().getFileObject();
        ArrayList<HtmlStructureItem> elements = new ArrayList<HtmlStructureItem>();
        for (OpenTag tag : root.children(OpenTag.class)) {
            if (ElementUtils.isVirtualNode((Element)tag) && HtmlStructureItem.gatherNonVirtualChildren((Node)tag).isEmpty()) continue;
            HtmlElementHandle handle = new HtmlElementHandle(tag, file);
            HtmlStructureItem si = new HtmlStructureItem(tag, handle, snapshot);
            elements.add(si);
        }
        Pair pair2 = Pair.of((Object)info, elements);
        this.cache = new WeakReference<Pair>(pair2);
        return elements;
    }

    public Map<String, List<OffsetRange>> folds(final ParserResult info) {
        if (!HtmlStructureScanner.isOfSupportedSize(info)) {
            return Collections.emptyMap();
        }
        BaseDocument doc = (BaseDocument)info.getSnapshot().getSource().getDocument(true);
        if (doc == null) {
            return Collections.emptyMap();
        }
        final int maxLen = doc.getLength();
        HashMap<String, List<OffsetRange>> folds = new HashMap<String, List<OffsetRange>>();
        final ArrayList tags = new ArrayList();
        final Lines lines = new Lines(info.getSnapshot().getText());
        ElementVisitor foldsSearch = new ElementVisitor(){
            final /* synthetic */ HtmlStructureScanner this$0;
            {
                this.this$0 = this$0;
            }

            public void visit(Element node) {
                if (node.type() == ElementType.OPEN_TAG) {
                    try {
                        int from = node.from();
                        int to = node.type() == ElementType.OPEN_TAG ? ((OpenTag)node).semanticEnd() : node.to();
                        OffsetRange range = this.this$0.convertAndCheck(from, to, info.getSnapshot(), lines, maxLen);
                        if (range != null) {
                            tags.add(range);
                        }
                    }
                    catch (BadLocationException ex) {
                        LOGGER.log(Level.INFO, null, ex);
                    }
                }
            }
        };
        Collection<Node> roots = ((HtmlParserResult)info).roots().values();
        for (Node root : roots) {
            ElementUtils.visitChildren((Node)root, (ElementVisitor)foldsSearch);
        }
        folds.put(TYPE_TAG.code(), tags);
        ArrayList<OffsetRange> comments = new ArrayList<OffsetRange>();
        HtmlParserResult result = (HtmlParserResult)info;
        Iterator elementsIterator = result.getSyntaxAnalyzerResult().getElementsIterator();
        while (elementsIterator.hasNext()) {
            Element element = (Element)elementsIterator.next();
            if (ElementType.COMMENT != element.type()) continue;
            try {
                OffsetRange range = this.convertAndCheck(element.from(), element.to(), info.getSnapshot(), lines, maxLen);
                if (range == null) continue;
                comments.add(range);
            }
            catch (BadLocationException ex) {
                LOGGER.log(Level.INFO, null, ex);
            }
        }
        folds.put(TYPE_COMMENT.code(), comments);
        return folds;
    }

    private OffsetRange convertAndCheck(int embeddedFrom, int embeddedTo, Snapshot snapshot, Lines lines, int maxLen) throws BadLocationException {
        if (embeddedFrom == -1 || embeddedTo == -1) {
            return null;
        }
        if (lines.getLineIndex(embeddedFrom) == lines.getLineIndex(embeddedTo)) {
            return null;
        }
        int so = snapshot.getOriginalOffset(embeddedFrom);
        int eo = snapshot.getOriginalOffset(embeddedTo);
        if (so == -1 || eo == -1) {
            return null;
        }
        if (eo > maxLen) {
            eo = maxLen;
        }
        if (so > eo) {
            so = eo;
        }
        return new OffsetRange(so, eo);
    }

    private static int documentPosition(int astOffset, Snapshot snapshot) {
        return snapshot.getOriginalOffset(astOffset);
    }

    public StructureScanner.Configuration getConfiguration() {
        return new StructureScanner.Configuration(false, false, 0);
    }
}

