/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.jaxws;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.dd.api.webservices.PortComponent;
import org.netbeans.modules.j2ee.dd.api.webservices.WebserviceDescription;
import org.netbeans.modules.j2ee.dd.api.webservices.Webservices;
import org.netbeans.modules.j2ee.dd.api.webservices.WebservicesMetadata;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.jaxws.MavenJAXWSSupportImpl;
import org.netbeans.modules.maven.jaxws.MavenModelUtils;
import org.netbeans.modules.maven.jaxws.MavenWebService;
import org.netbeans.modules.maven.jaxws.WSUtils;
import org.netbeans.modules.websvc.jaxws.light.api.JAXWSLightSupport;
import org.netbeans.modules.websvc.jaxws.light.api.JaxWsService;
import org.netbeans.modules.websvc.jaxws.light.spi.JAXWSLightSupportFactory;
import org.netbeans.modules.websvc.jaxws.light.spi.JAXWSLightSupportImpl;
import org.netbeans.modules.websvc.jaxws.light.spi.JAXWSLightSupportProvider;
import org.netbeans.modules.websvc.project.api.WebService;
import org.netbeans.modules.websvc.project.spi.LookupMergerSupport;
import org.netbeans.modules.websvc.project.spi.WebServiceDataProvider;
import org.netbeans.modules.websvc.project.spi.WebServiceFactory;
import org.netbeans.modules.websvc.project.spi.WebServiceImplementation;
import org.netbeans.spi.project.LookupMerger;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.openide.filesystems.FileObject;
import org.openide.util.RequestProcessor;

public class MavenJaxWsSupportProvider
extends ProjectOpenedHook
implements JAXWSLightSupportProvider,
WebServiceDataProvider,
PropertyChangeListener {
    private static final RequestProcessor MAVEN_WS_RP = new RequestProcessor("MavenJaxWsSupportProvider.WS_REQUEST_PROCESSOR");
    private static final RequestProcessor rp = new RequestProcessor("MavenJaxWsSupportProvider-request-processor");
    private RequestProcessor.Task pomChangesTask = MAVEN_WS_RP.create(new Runnable(){

        @Override
        public void run() {
            MavenJaxWsSupportProvider.this.reactOnPomChanges();
        }
    });
    private static final Logger LOG = Logger.getLogger(MavenJaxWsSupportProvider.class.getName());
    private JAXWSLightSupport jaxWsSupport;
    private PropertyChangeListener pcl;
    private NbMavenProject mp;
    private Project prj;
    private volatile String serverInstance;
    private List<WebService> providers = new LinkedList<WebService>();
    private List<WebService> consumers = new LinkedList<WebService>();

    public MavenJaxWsSupportProvider(Project prj) {
        MavenJAXWSSupportImpl spiJAXWSSupport = new MavenJAXWSSupportImpl(prj);
        this.prj = prj;
        this.jaxWsSupport = JAXWSLightSupportFactory.createJAXWSSupport((JAXWSLightSupportImpl)spiJAXWSSupport);
        this.jaxWsSupport.addPropertyChangeListener((PropertyChangeListener)this);
    }

    protected void projectClosed() {
    }

    protected void projectOpened() {
        MAVEN_WS_RP.post(new Runnable(){

            @Override
            public void run() {
                MavenJaxWsSupportProvider.this.registerPCL();
                J2eeModuleProvider provider = (J2eeModuleProvider)MavenJaxWsSupportProvider.this.prj.getLookup().lookup(J2eeModuleProvider.class);
                MetadataModel model = MavenJaxWsSupportProvider.this.jaxWsSupport.getWebservicesMetadataModel();
                if (model != null) {
                    MavenJaxWsSupportProvider.this.registerAnnotationListener((MetadataModel<WebservicesMetadata>)model);
                }
                MavenJaxWsSupportProvider.this.serverInstance = provider == null ? null : provider.getServerInstanceID();
            }
        });
        rp.post(new Runnable(){

            @Override
            public void run() {
                WSUtils.detectWsdlClients(MavenJaxWsSupportProvider.this.prj, MavenJaxWsSupportProvider.this.jaxWsSupport);
            }
        });
    }

    public JAXWSLightSupport findJAXWSSupport() {
        return this.jaxWsSupport;
    }

    public List<WebService> getServiceProviders() {
        return this.providers;
    }

    public List<WebService> getServiceConsumers() {
        return this.consumers;
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.jaxWsSupport.addPropertyChangeListener(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.jaxWsSupport.removePropertyChangeListener(pcl);
    }

    public static LookupMerger<WebServiceDataProvider> getLookupMerger() {
        return LookupMergerSupport.createWebServiceDataProviderMerger();
    }

    void registerPCL() {
        this.unregisterPCL();
        this.mp = (NbMavenProject)this.prj.getLookup().lookup(NbMavenProject.class);
        this.mp.addPropertyChangeListener((PropertyChangeListener)this);
    }

    void registerAnnotationListener(final MetadataModel<WebservicesMetadata> wsModel) {
        try {
            wsModel.runReadActionWhenReady((MetadataModelAction)new MetadataModelAction<WebservicesMetadata, Void>(){
                final /* synthetic */ MavenJaxWsSupportProvider this$0;
                {
                    this.this$0 = this$0;
                }

                public Void run(WebservicesMetadata metadata) {
                    Webservices webServices = metadata.getRoot();
                    if (this.this$0.pcl != null) {
                        webServices.removePropertyChangeListener(this.this$0.pcl);
                    }
                    this.this$0.pcl = this.this$0.new WebservicesChangeListener(this.this$0.jaxWsSupport, (MetadataModel<WebservicesMetadata>)wsModel);
                    webServices.addPropertyChangeListener(this.this$0.pcl);
                    return null;
                }
            });
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    void unregisterPCL() {
        if (this.mp != null) {
            this.mp.removePropertyChangeListener((PropertyChangeListener)this);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        block6: {
            block8: {
                block7: {
                    if (!"MavenProject".equals(evt.getPropertyName())) break block7;
                    this.pomChangesTask.schedule(1000);
                    break block6;
                }
                if (!"service-added".equals(evt.getPropertyName())) break block8;
                MavenWebService mavenService = new MavenWebService((JaxWsService)evt.getNewValue(), this.prj);
                WebService webService = WebServiceFactory.createWebService((WebServiceImplementation)mavenService);
                if (webService.isServiceProvider()) {
                    this.providers.add(webService);
                } else {
                    this.consumers.add(webService);
                }
                break block6;
            }
            if (!"service-removed".equals(evt.getPropertyName())) break block6;
            JaxWsService jaxWsService = (JaxWsService)evt.getOldValue();
            if (jaxWsService.isServiceProvider()) {
                String implClass = jaxWsService.getImplementationClass();
                for (WebService service : this.providers) {
                    if (!implClass.equals(service.getIdentifier())) continue;
                    this.providers.remove(service);
                    break;
                }
            } else {
                String clientId = jaxWsService.getId();
                for (WebService client : this.consumers) {
                    if (clientId == null || !clientId.equals(client.getIdentifier())) continue;
                    this.consumers.remove(client);
                    break;
                }
            }
        }
    }

    private void reactOnPomChanges() {
        WSUtils.updateClients(this.prj, this.jaxWsSupport);
        List services = this.jaxWsSupport.getServices();
        if (services.size() > 0) {
            J2eeModuleProvider provider = (J2eeModuleProvider)this.prj.getLookup().lookup(J2eeModuleProvider.class);
            String serverInstanceID = provider == null ? null : provider.getServerInstanceID();
            boolean instanceChanged = false;
            if (serverInstanceID == null) {
                if (this.serverInstance != null) {
                    instanceChanged = true;
                }
            } else if (!serverInstanceID.equals(this.serverInstance)) {
                instanceChanged = true;
            }
            if (instanceChanged) {
                this.serverInstance = serverInstanceID;
                MavenModelUtils.reactOnServerChanges(this.prj);
            }
            if (WSUtils.isWeb(this.prj)) {
                for (JaxWsService s : services) {
                    if (!s.isServiceProvider()) continue;
                    WSUtils.checkNonJSR109Entries(this.prj);
                    break;
                }
            }
        }
    }

    static /* synthetic */ RequestProcessor access$600() {
        return MAVEN_WS_RP;
    }

    private static class ServiceInfo {
        private String serviceName;
        private String portName;
        private String implClass;
        private String wsdlLocation;

        public ServiceInfo(String serviceName, String portName, String implClass, String wsdlLocation) {
            this.serviceName = serviceName;
            this.portName = portName;
            this.implClass = implClass;
            this.wsdlLocation = wsdlLocation;
        }

        public String getImplClass() {
            return this.implClass;
        }

        public void setImplClass(String implClass) {
            this.implClass = implClass;
        }

        public String getPortName() {
            return this.portName;
        }

        public void setPortName(String portName) {
            this.portName = portName;
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public String getWsdlLocation() {
            return this.wsdlLocation;
        }

        public void setWsdlLocation(String wsdlLocation) {
            this.wsdlLocation = wsdlLocation;
        }
    }

    private class WebservicesChangeListener
    implements PropertyChangeListener {
        private JAXWSLightSupport jaxWsSupport;
        private MetadataModel<WebservicesMetadata> wsModel;
        private RequestProcessor.Task updateJaxWsTask = MavenJaxWsSupportProvider.access$600().create(new Runnable(){

            @Override
            public void run() {
                WebservicesChangeListener.this.updateJaxWs();
            }
        });

        WebservicesChangeListener(JAXWSLightSupport jaxWsSupport, MetadataModel<WebservicesMetadata> wsModel) {
            this.jaxWsSupport = jaxWsSupport;
            this.wsModel = wsModel;
            this.updateJaxWsTask.schedule(1000);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.updateJaxWsTask.schedule(1000);
        }

        private void updateJaxWs() {
            try {
                final Map newServices = (Map)this.wsModel.runReadAction((MetadataModelAction)new MetadataModelAction<WebservicesMetadata, Map<String, ServiceInfo>>(){

                    public Map<String, ServiceInfo> run(WebservicesMetadata metadata) {
                        HashMap<String, ServiceInfo> result = new HashMap<String, ServiceInfo>();
                        Webservices webServices = metadata.getRoot();
                        for (WebserviceDescription wsDesc : webServices.getWebserviceDescription()) {
                            PortComponent[] ports;
                            for (PortComponent port : ports = wsDesc.getPortComponent()) {
                                String implClass = port.getDisplayName();
                                if (!WSUtils.isInSourceGroup(MavenJaxWsSupportProvider.this.prj, implClass)) continue;
                                QName portName = port.getWsdlPort();
                                result.put(implClass, new ServiceInfo(wsDesc.getWebserviceDescriptionName(), portName == null ? null : portName.getLocalPart(), implClass, wsDesc.getWsdlFile()));
                            }
                        }
                        return result;
                    }
                });
                Runnable runnable = new Runnable(){
                    final /* synthetic */ WebservicesChangeListener this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public void run() {
                        this.this$1.doUpdateJaxWs(newServices);
                    }
                };
                this.jaxWsSupport.runAtomic(runnable);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }

        private void doUpdateJaxWs(Map<String, ServiceInfo> newServices) {
            List oldJaxWsServices = this.jaxWsSupport.getServices();
            HashMap<String, JaxWsService> oldServices = new HashMap<String, JaxWsService>();
            for (JaxWsService s : oldJaxWsServices) {
                if (!s.isServiceProvider()) continue;
                oldServices.put(s.getImplementationClass(), s);
            }
            HashSet<String> commonServices = new HashSet<String>();
            Set keys1 = oldServices.keySet();
            Set<String> keys2 = newServices.keySet();
            for (String key : keys1) {
                if (!keys2.contains(key)) continue;
                commonServices.add(key);
            }
            for (String key : commonServices) {
                oldServices.remove(key);
                newServices.remove(key);
            }
            boolean needToSave = false;
            for (JaxWsService jaxWsService : oldServices.values()) {
                this.jaxWsSupport.removeService(jaxWsService);
            }
            for (Map.Entry entry : newServices.entrySet()) {
                String key = (String)entry.getKey();
                ServiceInfo serviceInfo = (ServiceInfo)entry.getValue();
                String wsdlLocation = serviceInfo.getWsdlLocation();
                JaxWsService service = new JaxWsService(serviceInfo.getServiceName(), key);
                if (wsdlLocation != null && wsdlLocation.length() > 0) {
                    service.setWsdlLocation(wsdlLocation);
                    if (wsdlLocation.startsWith("WEB-INF/wsdl/")) {
                        service.setLocalWsdl(wsdlLocation.substring(13));
                    } else if (wsdlLocation.startsWith("META-INF/wsdl/")) {
                        service.setLocalWsdl(wsdlLocation.substring(14));
                    } else {
                        service.setLocalWsdl(wsdlLocation);
                    }
                    FileObject wsdlFo = WSUtils.getLocalWsdl(this.jaxWsSupport, service.getLocalWsdl());
                    if (wsdlFo != null) {
                        service.setId(WSUtils.getUniqueId(wsdlFo.getName(), oldJaxWsServices));
                    }
                    service.setWsdlUrl(WSUtils.getOriginalWsdlUrl(MavenJaxWsSupportProvider.this.prj, service.getId(), true));
                }
                service.setPortName(serviceInfo.getPortName());
                this.jaxWsSupport.addService(service);
            }
        }
    }
}

