/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javawebstart;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ant.AntBuildExtender;
import org.netbeans.modules.javawebstart.ui.customizer.JWSProjectPropertiesUtils;
import org.netbeans.spi.project.ant.GeneratedFilesInterceptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class JWSGeneratedFilesInterceptor
implements GeneratedFilesInterceptor {
    private static final Logger LOG = Logger.getLogger(JWSGeneratedFilesInterceptor.class.getName());
    private final ThreadLocal<Boolean> reenter = new ThreadLocal();

    public void fileGenerated(final Project project, String path) {
        if (this.reenter.get() == Boolean.TRUE) {
            return;
        }
        if ("nbproject/build-impl.xml".equals(path)) {
            final AntBuildExtender extender = (AntBuildExtender)project.getLookup().lookup(AntBuildExtender.class);
            if (extender == null) {
                LOG.log(Level.WARNING, "The project {0} ({1}) does not support AntBuildExtender.", new Object[]{ProjectUtils.getInformation((Project)project).getDisplayName(), FileUtil.getFileDisplayName((FileObject)project.getProjectDirectory())});
                return;
            }
            this.runDeferred(new Runnable(){
                final /* synthetic */ JWSGeneratedFilesInterceptor this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    this.this$0.updateIfNeeded(project, extender);
                }
            });
        }
    }

    private void runDeferred(final Runnable r) {
        ProjectManager.mutex().postReadRequest(new Runnable(){
            final /* synthetic */ JWSGeneratedFilesInterceptor this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                ProjectManager.mutex().postWriteRequest(r);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateIfNeeded(Project project, AntBuildExtender extender) {
        if (extender.getExtension(JWSProjectPropertiesUtils.getCurrentExtensionName()) != null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "The project {0} ({1}) already has a current version ({2}) of JWS extension.", new Object[]{ProjectUtils.getInformation((Project)project).getDisplayName(), FileUtil.getFileDisplayName((FileObject)project.getProjectDirectory()), JWSProjectPropertiesUtils.getCurrentExtensionName()});
            }
            return;
        }
        this.reenter.set(Boolean.TRUE);
        try {
            boolean needsUpdate = false;
            for (String string : JWSProjectPropertiesUtils.getOldExtensionNames()) {
                AntBuildExtender.Extension extension = extender.getExtension(string);
                if (extension == null) continue;
                extender.removeExtension(string);
                needsUpdate = true;
            }
            if (needsUpdate) {
                try {
                    JWSProjectPropertiesUtils.updateJnlpExtension(project);
                    ProjectManager.getDefault().saveProject(project);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        finally {
            this.reenter.remove();
        }
    }
}

