/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.plugins.spi.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.netbeans.modules.j2ee.deployment.plugins.spi.LookupProvider;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public final class LookupProviderSupport {
    private LookupProviderSupport() {
    }

    public static Lookup createCompositeLookup(Lookup baseLookup, String folderPath) {
        return new DelegatingLookupImpl(baseLookup, folderPath);
    }

    static class DelegatingLookupImpl
    extends ProxyLookup
    implements LookupListener {
        private Lookup baseLookup;
        private Lookup.Result<LookupProvider> providerResult;
        private LookupListener providerListener;
        private List<LookupProvider> old = Collections.emptyList();
        private List<Lookup> currentLookups;
        private List<Lookup.Result<?>> results = new ArrayList();

        public DelegatingLookupImpl(Lookup base, String path) {
            this(base, Lookups.forPath((String)path), path);
        }

        public DelegatingLookupImpl(Lookup base, Lookup providerLookup, String path) {
            assert (base != null);
            this.baseLookup = base;
            this.providerResult = providerLookup.lookup(new Lookup.Template(LookupProvider.class));
            assert (this.isAllJustLookupProviders(providerLookup)) : "Layer content at " + path + " contains other than LookupProvider instances! See messages.log file for more details.";
            this.doDelegate(this.providerResult.allInstances());
            this.providerListener = new LookupListener(){

                public void resultChanged(LookupEvent ev) {
                    this.doDelegate(providerResult.allInstances());
                }
            };
            this.providerResult.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this.providerListener, this.providerResult));
        }

        private boolean isAllJustLookupProviders(Lookup lkp) {
            Lookup.Result res = lkp.lookupResult(Object.class);
            Set set = res.allClasses();
            for (Class clzz : set) {
                if (LookupProvider.class.isAssignableFrom(clzz)) continue;
                Logger.getLogger(LookupProviderSupport.class.getName()).warning("" + clzz.getName() + " is not instance of LookupProvider.");
                return false;
            }
            return true;
        }

        public void resultChanged(LookupEvent ev) {
            this.doDelegate(this.providerResult.allInstances());
        }

        private synchronized void doDelegate(Collection<? extends LookupProvider> providers) {
            for (Lookup.Result<?> result : this.results) {
                result.removeLookupListener((LookupListener)this);
            }
            ArrayList<Lookup> newLookups = new ArrayList<Lookup>();
            for (LookupProvider lookupProvider : providers) {
                if (this.old.contains(lookupProvider)) {
                    int index = this.old.indexOf(lookupProvider);
                    newLookups.add(this.currentLookups.get(index));
                    continue;
                }
                Lookup newone = lookupProvider.createAdditionalLookup(this.baseLookup);
                assert (newone != null);
                newLookups.add(newone);
            }
            this.old = new ArrayList<LookupProvider>(providers);
            this.currentLookups = newLookups;
            newLookups.add(this.baseLookup);
            ProxyLookup proxyLookup = new ProxyLookup(newLookups.toArray(new Lookup[0]));
            this.setLookups(new Lookup[]{proxyLookup});
        }
    }
}

