/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.ui.customizer;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.web.clientproject.ClientSideProject;
import org.netbeans.modules.web.clientproject.ui.customizer.Bundle;
import org.netbeans.modules.web.clientproject.ui.customizer.ClientSideProjectProperties;
import org.netbeans.modules.web.clientproject.util.ClientSideProjectUtilities;
import org.netbeans.spi.project.ui.CustomizerProvider2;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.lookup.Lookups;
import org.openide.windows.WindowManager;

public class CustomizerProviderImpl
implements CustomizerProvider2 {
    static final Logger LOGGER = Logger.getLogger(CustomizerProviderImpl.class.getName());
    static final String CUSTOMIZER_FOLDER_PATH = "Projects/org.netbeans.modules.web.clientproject/Customizer";
    static final Map<Project, Dialog> PROJECT_2_DIALOG = new HashMap<Project, Dialog>();
    final ClientSideProject project;

    public CustomizerProviderImpl(ClientSideProject project) {
        this.project = project;
    }

    public void showCustomizer() {
        this.showCustomizer(null);
    }

    public void showCustomizer(String preselectedCategory) {
        this.showCustomizer(preselectedCategory, null);
    }

    public void showCustomizer(final String preselectedCategory, final String preselectedSubCategory) {
        Mutex.EVENT.readAccess(new Runnable(){
            final /* synthetic */ CustomizerProviderImpl this$0;
            {
                this.this$0 = this$0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                assert (EventQueue.isDispatchThread());
                Dialog dialog = PROJECT_2_DIALOG.get(this.this$0.project);
                if (dialog != null) {
                    dialog.setVisible(true);
                    return;
                }
                try {
                    WaitCursor.show();
                    ClientSideProjectProperties uiProperties = new ClientSideProjectProperties(this.this$0.project);
                    Lookup context = Lookups.fixed((Object[])new Object[]{this.this$0.project, uiProperties, new SubCategoryProvider(preselectedCategory, preselectedSubCategory)});
                    OptionListener optionListener = new OptionListener(this.this$0.project);
                    StoreListener storeListener = new StoreListener(uiProperties);
                    dialog = ProjectCustomizer.createCustomizerDialog((String)CustomizerProviderImpl.CUSTOMIZER_FOLDER_PATH, (Lookup)context, (String)preselectedCategory, (ActionListener)optionListener, (ActionListener)storeListener, null);
                    dialog.addWindowListener(optionListener);
                    dialog.setTitle(Bundle.CustomizerProviderImpl_title(ProjectUtils.getInformation((Project)this.this$0.project).getDisplayName()));
                    PROJECT_2_DIALOG.put(this.this$0.project, dialog);
                }
                finally {
                    WaitCursor.hide();
                }
                dialog.setVisible(true);
            }
        });
    }

    private static final class WaitCursor
    implements Runnable {
        private boolean show;

        private WaitCursor(boolean show) {
            assert (EventQueue.isDispatchThread());
            this.show = show;
        }

        public static void show() {
            WaitCursor.invoke(new WaitCursor(true));
        }

        public static void hide() {
            WaitCursor.invoke(new WaitCursor(false));
        }

        private static void invoke(WaitCursor wc) {
            Mutex.EVENT.readAccess((Runnable)wc);
        }

        @Override
        public void run() {
            assert (EventQueue.isDispatchThread());
            try {
                JFrame frame = (JFrame)WindowManager.getDefault().getMainWindow();
                Component component = frame.getGlassPane();
                component.setVisible(this.show);
                component.setCursor(this.show ? Cursor.getPredefinedCursor(3) : null);
            }
            catch (NullPointerException npe) {
                LOGGER.log(Level.WARNING, null, npe);
            }
        }
    }

    static final class SubCategoryProvider {
        private final String subcategory;
        private final String category;

        SubCategoryProvider(String category, String subcategory) {
            this.category = category;
            this.subcategory = subcategory;
        }

        public String getCategory() {
            return this.category;
        }

        public String getSubcategory() {
            return this.subcategory;
        }
    }

    private static class OptionListener
    extends WindowAdapter
    implements ActionListener {
        private final Project project;

        OptionListener(Project project) {
            this.project = project;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Dialog dialog = PROJECT_2_DIALOG.get(this.project);
            if (dialog != null) {
                dialog.setVisible(false);
                dialog.dispose();
            }
        }

        @Override
        public void windowClosed(WindowEvent e) {
            PROJECT_2_DIALOG.remove(this.project);
        }

        @Override
        public void windowClosing(WindowEvent e) {
            Dialog dialog = PROJECT_2_DIALOG.get(this.project);
            if (dialog != null) {
                dialog.setVisible(false);
                dialog.dispose();
            }
        }
    }

    private static final class StoreListener
    implements ActionListener {
        private final ClientSideProjectProperties uiProperties;

        StoreListener(ClientSideProjectProperties uiProperties) {
            this.uiProperties = uiProperties;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            assert (!EventQueue.isDispatchThread());
            this.uiProperties.save();
            ClientSideProjectProperties.ProjectServer server = this.uiProperties.getProjectServer();
            Object[] objectArray = new Object[3];
            objectArray[0] = "";
            Object object = objectArray[1] = ClientSideProjectProperties.ProjectServer.INTERNAL.equals((Object)server) ? "EMBEDDED" : "EXTERNAL";
            objectArray[2] = ClientSideProjectProperties.ProjectServer.INTERNAL.equals((Object)server) ? (this.uiProperties.getWebRoot().length() > 1 ? "YES" : "NO") : "";
            ClientSideProjectUtilities.logUsage(CustomizerProviderImpl.class, "USG_PROJECT_HTML5_CONFIGURE", objectArray);
        }
    }
}

