/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.completion;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.xml.lexer.XMLTokenId;
import org.netbeans.modules.web.beans.completion.DocumentContext;
import org.netbeans.modules.web.beans.completion.EditorContextFactory;
import org.netbeans.modules.xml.text.api.dom.SyntaxElement;
import org.netbeans.modules.xml.text.api.dom.XMLSyntaxSupport;
import org.openide.util.Exceptions;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class CompletionContext {
    private List<String> existingAttributes;
    private static final Logger LOGGER = Logger.getLogger(CompletionContext.class.getName());
    private CompletionType completionType = CompletionType.NONE;
    private Document doc;
    private int caretOffset;
    private DocumentContext documentContext;
    private String typedChars = "";
    private char lastTypedChar;
    private XMLSyntaxSupport support;

    public CompletionContext(Document doc, int caretOffset) {
        this.doc = doc;
        this.caretOffset = caretOffset;
        try {
            this.support = XMLSyntaxSupport.getSyntaxSupport((Document)doc);
        }
        catch (ClassCastException cce) {
            LOGGER.log(Level.FINE, cce.getMessage());
            this.support = XMLSyntaxSupport.createSyntaxSupport((Document)doc);
        }
        this.documentContext = EditorContextFactory.getDocumentContext(doc, caretOffset);
        this.lastTypedChar = this.support.lastTypedChar();
        try {
            this.initContext();
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private void initContext() throws BadLocationException {
        Token<XMLTokenId> token = this.documentContext.getCurrentToken();
        if (token == null) {
            return;
        }
        boolean tokenBoundary = this.documentContext.getCurrentTokenOffset() == this.caretOffset || this.documentContext.getCurrentTokenOffset() + token.length() == this.caretOffset;
        XMLTokenId id = (XMLTokenId)token.id();
        SyntaxElement element = this.documentContext.getCurrentElement();
        String chars = token.text().toString().trim();
        int tOffset = this.documentContext.getCurrentTokenOffset();
        switch (id) {
            case TEXT: {
                Token previousTokenItem = this.support.getPreviousToken(tOffset);
                if (previousTokenItem == null) {
                    this.completionType = CompletionType.NONE;
                    break;
                }
                String text = previousTokenItem.text().toString().trim();
                if (chars != null && chars.equals("") && text.equals("/>")) {
                    this.completionType = CompletionType.NONE;
                    break;
                }
                if (chars != null && chars.equals("") && text.equals(">")) {
                    this.completionType = CompletionType.VALUE;
                    break;
                }
                if (chars != null && !chars.startsWith("<") && text.equals(">")) {
                    this.completionType = CompletionType.VALUE;
                    this.typedChars = chars.substring(0, this.caretOffset - tOffset);
                    break;
                }
                if (chars != null && !chars.equals("<") && text.equals(">")) {
                    this.completionType = CompletionType.NONE;
                    break;
                }
                if (chars != null && chars.startsWith("<")) {
                    this.typedChars = chars.substring(1);
                }
                this.completionType = CompletionType.TAG;
                break;
            }
            case TAG: {
                String tagName = element.getNode().getNodeName();
                if (this.support.isEndTag(element)) {
                    this.completionType = CompletionType.NONE;
                    break;
                }
                if (this.support.isEmptyTag(element)) {
                    if (chars.trim().equals("/>")) {
                        this.completionType = CompletionType.NONE;
                        break;
                    }
                    if (element.getElementOffset() + 1 == this.caretOffset) {
                        this.completionType = CompletionType.TAG;
                        break;
                    }
                    if (this.caretOffset > element.getElementOffset() + 1 && this.caretOffset <= element.getElementOffset() + 1 + tagName.length()) {
                        this.completionType = CompletionType.TAG;
                        this.typedChars = tagName;
                        break;
                    }
                    this.completionType = CompletionType.ATTRIBUTE;
                    break;
                }
                if (this.support.isStartTag(element)) {
                    if (token != null && chars.equals(">")) {
                        this.completionType = CompletionType.NONE;
                        break;
                    }
                    if (token != null && chars.startsWith("</")) {
                        this.typedChars = "";
                        this.completionType = CompletionType.VALUE;
                        break;
                    }
                    if (element.getElementOffset() + 1 != this.caretOffset) {
                        this.typedChars = tagName;
                    }
                }
                if (element instanceof Text && token != null && chars.startsWith("</")) {
                    Token previous = this.support.getPreviousToken(tOffset);
                    this.typedChars = previous.text().toString().trim();
                    this.completionType = CompletionType.VALUE;
                    break;
                }
                if (this.lastTypedChar == '>') {
                    this.completionType = CompletionType.VALUE;
                    break;
                }
                this.completionType = CompletionType.TAG;
                break;
            }
            case ARGUMENT: {
                this.completionType = CompletionType.ATTRIBUTE;
                this.typedChars = chars.substring(0, this.caretOffset - tOffset);
                break;
            }
            case CHARACTER: 
            case OPERATOR: {
                this.completionType = CompletionType.NONE;
                break;
            }
            case VALUE: {
                if (!tokenBoundary) {
                    this.completionType = CompletionType.ATTRIBUTE_VALUE;
                    this.typedChars = chars.substring(1, this.caretOffset - tOffset);
                    break;
                }
                this.completionType = CompletionType.NONE;
                break;
            }
            case WS: {
                this.completionType = CompletionType.NONE;
                Token prev = this.support.skip(tOffset, false, new XMLTokenId[]{XMLTokenId.WS});
                if (prev == null) {
                    this.completionType = CompletionType.NONE;
                    break;
                }
                if (prev.id() == XMLTokenId.ARGUMENT) {
                    this.typedChars = prev.text().toString();
                    this.completionType = CompletionType.ATTRIBUTE;
                    break;
                }
                if (prev.id() != XMLTokenId.VALUE && prev.id() != XMLTokenId.TAG) break;
                this.completionType = CompletionType.ATTRIBUTE;
                break;
            }
            default: {
                this.completionType = CompletionType.NONE;
            }
        }
    }

    public CompletionType getCompletionType() {
        return this.completionType;
    }

    public String getTypedPrefix() {
        return this.typedChars;
    }

    public Document getDocument() {
        return this.doc;
    }

    public DocumentContext getDocumentContext() {
        return this.documentContext;
    }

    public int getCaretOffset() {
        return this.caretOffset;
    }

    public Node getTag() {
        SyntaxElement element = this.documentContext.getCurrentElement();
        return element.getType() == 1 ? element.getNode() : null;
    }

    public Token<XMLTokenId> getCurrentToken() {
        return this.documentContext.getCurrentToken();
    }

    public int getCurrentTokenOffset() {
        return this.documentContext.getCurrentTokenOffset();
    }

    private List<String> getExistingAttributesLocked(TokenSequence ts) {
        Token item;
        XMLTokenId tokenId;
        ArrayList<String> existingAttributes = new ArrayList<String>();
        while (ts.movePrevious() && (tokenId = (XMLTokenId)(item = ts.token()).id()) != XMLTokenId.TAG) {
            if (tokenId != XMLTokenId.ARGUMENT) continue;
            existingAttributes.add(item.text().toString());
        }
        return existingAttributes;
    }

    public List<String> getExistingAttributes() {
        if (this.existingAttributes == null) {
            try {
                this.existingAttributes = (List)this.support.runWithSequence(this.documentContext.getCurrentTokenOffset(), this::getExistingAttributesLocked);
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return this.existingAttributes;
    }

    public static enum CompletionType {
        TAG,
        VALUE,
        ATTRIBUTE,
        ATTRIBUTE_VALUE,
        NONE;

    }
}

