/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.netbeans.lib.profiler.heap.CacheDirectory;
import org.netbeans.lib.profiler.heap.File;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.HprofHeap;
import org.netbeans.lib.profiler.heap.JavaIoFile;
import org.netbeans.lib.profiler.heap.Systems;

public class HeapFactory {
    public static Heap createHeap(java.io.File heapDump) throws FileNotFoundException, IOException {
        return HeapFactory.createHeap(heapDump, 0);
    }

    public static Heap createHeap(java.io.File heapDump, int segment) throws FileNotFoundException, IOException {
        File savedDump;
        File hd = JavaIoFile.IO.newFile(heapDump);
        CacheDirectory cacheDir = CacheDirectory.getHeapDumpCacheDirectory(JavaIoFile.IO, hd, segment);
        if (!cacheDir.isTemporary() && (savedDump = cacheDir.getHeapDumpAuxFile()).exists() && savedDump.isFile() && savedDump.canRead()) {
            try {
                return HeapFactory.loadHeap(cacheDir);
            }
            catch (IOException ex) {
                Systems.printStackTrace("Loading heap dump " + heapDump + " from cache failed.", ex);
            }
        }
        return new HprofHeap(hd, segment, cacheDir);
    }

    public static Heap createHeap(ByteBuffer buffer, int segment) throws IOException {
        return new HprofHeap(buffer, segment, new CacheDirectory(JavaIoFile.IO, null));
    }

    static Heap loadHeap(CacheDirectory cacheDir) throws FileNotFoundException, IOException {
        File savedDump = cacheDir.getHeapDumpAuxFile();
        DataInputStream dis = savedDump.newDataInputStream(65536);
        HprofHeap heap = new HprofHeap(dis, cacheDir);
        dis.close();
        return heap;
    }
}

