/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.netbeans.lib.profiler.heap.GCRoot;
import org.netbeans.lib.profiler.heap.HprofGCRoot;
import org.netbeans.lib.profiler.heap.HprofHeap;
import org.netbeans.lib.profiler.heap.JavaFrameHprofGCRoot;
import org.netbeans.lib.profiler.heap.TagBounds;
import org.netbeans.lib.profiler.heap.ThreadObjectGCRoot;
import org.netbeans.lib.profiler.heap.ThreadObjectHprofGCRoot;

class HprofGCRoots {
    final HprofHeap heap;
    private Map<Integer, ThreadObjectHprofGCRoot> threadObjGC;
    private final Object lastThreadObjGCLock = new Object();
    private Map<Long, GCRoot> gcRoots;
    private final Object gcRootLock = new Object();
    private List gcRootsList;

    HprofGCRoots(HprofHeap h) {
        this.heap = h;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<GCRoot> getGCRoots() {
        Object object = this.gcRootLock;
        synchronized (object) {
            if (this.gcRoots == null) {
                ArrayList<GCRoot> rootList = new ArrayList<GCRoot>();
                this.computeGCRootsFor(this.heap.getHeapTagBound(255), rootList);
                this.computeGCRootsFor(this.heap.getHeapTagBound(1), rootList);
                this.computeGCRootsFor(this.heap.getHeapTagBound(2), rootList);
                this.computeGCRootsFor(this.heap.getHeapTagBound(3), rootList);
                this.computeGCRootsFor(this.heap.getHeapTagBound(4), rootList);
                this.computeGCRootsFor(this.heap.getHeapTagBound(5), rootList);
                this.computeGCRootsFor(this.heap.getHeapTagBound(6), rootList);
                this.computeGCRootsFor(this.heap.getHeapTagBound(7), rootList);
                this.computeGCRootsFor(this.heap.getHeapTagBound(8), rootList);
                this.computeGCRootsFor(this.heap.getHeapTagBound(137), rootList);
                this.computeGCRootsFor(this.heap.getHeapTagBound(138), rootList);
                this.computeGCRootsFor(this.heap.getHeapTagBound(139), rootList);
                this.computeGCRootsFor(this.heap.getHeapTagBound(140), rootList);
                this.computeGCRootsFor(this.heap.getHeapTagBound(141), rootList);
                this.computeGCRootsFor(this.heap.getHeapTagBound(142), rootList);
                rootList.sort(new Comparator(){

                    public int compare(Object o1, Object o2) {
                        HprofGCRoot r1 = (HprofGCRoot)o1;
                        HprofGCRoot r2 = (HprofGCRoot)o2;
                        int kind = r1.getKind().compareTo(r2.getKind());
                        if (kind != 0) {
                            return kind;
                        }
                        return Long.compare(r1.getInstanceId(), r2.getInstanceId());
                    }
                });
                this.gcRootsList = Collections.unmodifiableList(rootList);
            }
            return this.gcRootsList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GCRoot getGCRoot(Long instanceId) {
        Object object = this.gcRootLock;
        synchronized (object) {
            Map<Long, GCRoot> roots;
            if (this.gcRoots == null) {
                this.heap.getGCRoots();
                roots = new HashMap<Long, GCRoot>();
                for (GCRoot r : this.getGCRoots()) {
                    roots.put(r.getInstance().getInstanceId(), r);
                }
                this.gcRoots = roots;
            } else {
                roots = this.gcRoots;
            }
            return roots.get(instanceId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ThreadObjectGCRoot getThreadGCRoot(int threadSerialNumber) {
        Map<Integer, ThreadObjectHprofGCRoot> map;
        Object object = this.lastThreadObjGCLock;
        synchronized (object) {
            if (this.threadObjGC == null) {
                Iterator gcRootsIt = this.heap.getGCRoots().iterator();
                map = new TreeMap<Integer, ThreadObjectHprofGCRoot>();
                while (gcRootsIt.hasNext()) {
                    Object gcRoot = gcRootsIt.next();
                    if (!(gcRoot instanceof ThreadObjectHprofGCRoot)) continue;
                    ThreadObjectHprofGCRoot tohGC = (ThreadObjectHprofGCRoot)gcRoot;
                    map.put(tohGC.getThreadSerialNumber(), tohGC);
                }
                this.threadObjGC = map;
            } else {
                map = this.threadObjGC;
            }
        }
        return map.get(threadSerialNumber);
    }

    private void computeGCRootsFor(TagBounds tagBounds, Collection<GCRoot> roots) {
        if (tagBounds != null) {
            int rootTag = tagBounds.tag;
            long[] offset = new long[]{tagBounds.startOffset};
            while (offset[0] < tagBounds.endOffset) {
                long start = offset[0];
                if (this.heap.readDumpTag(offset) != rootTag) continue;
                HprofGCRoot root = rootTag == 8 ? new ThreadObjectHprofGCRoot(this, start) : (rootTag == 3 ? new JavaFrameHprofGCRoot(this, start) : new HprofGCRoot(this, start));
                roots.add(root);
            }
        }
    }
}

