/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.queries;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.apisupport.project.ApisupportAntUtils;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.ProjectXMLManager;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.netbeans.modules.apisupport.project.universe.TestModuleDependency;
import org.netbeans.spi.java.project.classpath.ProjectClassPathModifierImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class ModuleProjectClassPathExtender
extends ProjectClassPathModifierImplementation {
    private final NbModuleProject project;

    public ModuleProjectClassPathExtender(NbModuleProject project) {
        this.project = project;
    }

    protected SourceGroup[] getExtensibleSourceGroups() {
        ArrayList<SourceGroup> sgs = new ArrayList<SourceGroup>(2);
        for (SourceGroup g : ProjectUtils.getSources((Project)this.project).getSourceGroups("java")) {
            if (g.getRootFolder() != this.project.getSourceDirectory() && g.getRootFolder() != this.project.getTestSourceDirectory("unit")) continue;
            sgs.add(g);
        }
        return sgs.toArray(new SourceGroup[0]);
    }

    protected String[] getExtensibleClassPathTypes(SourceGroup sourceGroup) {
        return new String[]{"classpath/compile"};
    }

    protected boolean addLibraries(Library[] libraries, SourceGroup sourceGroup, String type) throws IOException, UnsupportedOperationException {
        boolean cpChanged = false;
        for (Library library : libraries) {
            if (library.getName().matches("junit(_4)?")) {
                ModuleEntry entry = this.project.getModuleList().getEntry("org.netbeans.libs.junit4");
                if (entry == null) continue;
                ProjectXMLManager pxm = new ProjectXMLManager(this.project);
                cpChanged |= pxm.addTestDependency("unit", new TestModuleDependency(entry, false, false, true));
                continue;
            }
            for (URL u : library.getContent("classpath")) {
                String cnb;
                URL jar = FileUtil.getArchiveFile((URL)u);
                if (jar != null && jar.getProtocol().equals("nbinst") && (cnb = jar.getHost()) != null && cnb.length() > 0) {
                    ModuleEntry entry = this.project.getModuleList().getEntry(cnb);
                    if (entry != null) {
                        if (sourceGroup.getRootFolder() == this.project.getSourceDirectory()) {
                            cpChanged |= ApisupportAntUtils.addDependency(this.project, cnb, null, null, true, null);
                            continue;
                        }
                        if (sourceGroup.getRootFolder() == this.project.getTestSourceDirectory("unit")) {
                            ProjectXMLManager pxm = new ProjectXMLManager(this.project);
                            cpChanged |= pxm.addTestDependency("unit", new TestModuleDependency(entry, false, false, true));
                            continue;
                        }
                        throw new UnsupportedOperationException("wrong source group");
                    }
                    IOException e = new IOException("no module " + cnb);
                    Exceptions.attachLocalizedMessage((Throwable)e, (String)NbBundle.getMessage(ModuleProjectClassPathExtender.class, (String)"ERR_could_not_find_module", (Object)cnb));
                    throw e;
                }
                IOException e = new IOException("unknown lib " + library.getName());
                Exceptions.attachLocalizedMessage((Throwable)e, (String)NbBundle.getMessage(ModuleProjectClassPathExtender.class, (String)"ERR_unsupported_library", (Object)library.getDisplayName()));
                throw e;
            }
        }
        if (cpChanged) {
            ProjectManager.getDefault().saveProject((Project)this.project);
        }
        return cpChanged;
    }

    protected boolean removeLibraries(Library[] libraries, SourceGroup sourceGroup, String type) throws IOException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    protected boolean addRoots(URL[] classPathRoots, SourceGroup sourceGroup, String type) throws IOException, UnsupportedOperationException {
        if (sourceGroup.getRootFolder() != this.project.getSourceDirectory()) {
            throw new UnsupportedOperationException("cannot add raw JARs to test roots");
        }
        ProjectXMLManager pxm = new ProjectXMLManager(this.project);
        Map<String, String> origCpexts = pxm.getClassPathExtensions();
        LinkedHashMap<String, String> cpexts = new LinkedHashMap<String, String>(origCpexts);
        boolean cpChanged = false;
        for (URL root : classPathRoots) {
            File jar = FileUtil.archiveOrDirForURL((URL)root);
            if (jar == null || !jar.isFile()) {
                throw new UnsupportedOperationException("cannot add: " + String.valueOf(root));
            }
            String relativePath = "ext/" + jar.getName();
            String binaryOrigin = "release/modules/ext/" + jar.getName();
            File target = this.project.getHelper().resolveFile(binaryOrigin);
            if (jar.equals(target)) {
                cpexts.put(relativePath, binaryOrigin);
                continue;
            }
            if (!target.isFile() || target.length() != jar.length()) {
                cpChanged = true;
            }
            String[] result = ApisupportAntUtils.copyClassPathExtensionJar(FileUtil.toFile((FileObject)this.project.getProjectDirectory()), jar);
            assert (result != null) : jar;
            assert (result[0].equals(relativePath)) : result[0];
            assert (result[1].equals(binaryOrigin)) : result[1];
            cpexts.put(relativePath, binaryOrigin);
        }
        if (!cpexts.equals(origCpexts)) {
            pxm.replaceClassPathExtensions(cpexts);
            ProjectManager.getDefault().saveProject((Project)this.project);
            cpChanged = true;
        }
        return cpChanged;
    }

    protected boolean removeRoots(URL[] classPathRoots, SourceGroup sourceGroup, String type) throws IOException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    protected boolean addAntArtifacts(AntArtifact[] artifacts, URI[] artifactElements, SourceGroup sourceGroup, String type) throws IOException, UnsupportedOperationException {
        String displayName;
        UnsupportedOperationException e = new UnsupportedOperationException("not implemented: " + String.valueOf(Arrays.asList(artifactElements)));
        String string = displayName = artifactElements.length > 0 ? artifactElements[0].toString() : "<nothing>";
        if (artifactElements.length > 0 && "file".equals(artifactElements[0].getScheme())) {
            displayName = Utilities.toFile((URI)artifactElements[0]).getAbsolutePath();
        }
        Exceptions.attachLocalizedMessage((Throwable)e, (String)NbBundle.getMessage(ModuleProjectClassPathExtender.class, (String)"ERR_jar", (Object)displayName));
        throw e;
    }

    protected boolean removeAntArtifacts(AntArtifact[] artifacts, URI[] artifactElements, SourceGroup sourceGroup, String type) throws IOException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }
}

