/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui;

import java.awt.EventQueue;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Collections;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.apisupport.project.ApisupportAntUtils;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.api.Util;
import org.netbeans.modules.apisupport.project.suite.SuiteProject;
import org.netbeans.modules.apisupport.project.ui.ApisupportAntUIUtils;
import org.netbeans.modules.apisupport.project.ui.ImportantFilesNodeFactory;
import org.netbeans.modules.apisupport.project.ui.SuiteLogicalView;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteUtils;
import org.netbeans.modules.apisupport.project.ui.wizard.NewNbModuleWizardIterator;
import org.netbeans.modules.project.ui.api.ProjectActionUtils;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeFactorySupport;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.CookieAction;
import org.openide.util.actions.NodeAction;
import org.openide.util.lookup.Lookups;
import org.openide.windows.WindowManager;

public class ModulesNodeFactory
implements NodeFactory {
    private static final Logger LOG = Logger.getLogger(ModulesNodeFactory.class.getName());

    public NodeList createNodes(Project p) {
        SuiteProject prj = (SuiteProject)p.getLookup().lookup(SuiteProject.class);
        assert (prj != null);
        return NodeFactorySupport.fixedNodeList((Node[])new Node[]{new ModulesNode(prj)});
    }

    private static String getMessage(String key) {
        return NbBundle.getMessage(SuiteLogicalView.class, (String)key);
    }

    static final class ModulesNode
    extends AbstractNode {
        private SuiteProject suite;

        ModulesNode(SuiteProject suite) {
            super((Children)new ModuleChildren(suite), Lookups.fixed((Object[])new Object[]{suite}));
            this.suite = suite;
            this.setName("modules");
            this.setDisplayName(ModulesNodeFactory.getMessage("CTL_Modules"));
        }

        public Action[] getActions(boolean context) {
            return new Action[]{new AddNewSuiteComponentAction(this.suite), new AddNewLibraryWrapperAction(this.suite), new AddSuiteComponentAction(this.suite)};
        }

        private Image getIcon(boolean opened) {
            Image badge = ImageUtilities.loadImage((String)"org/netbeans/modules/apisupport/project/suite/resources/module-badge.png", (boolean)true);
            return ImageUtilities.mergeImages((Image)ApisupportAntUIUtils.getTreeFolderIcon(opened), (Image)badge, (int)9, (int)9);
        }

        public Image getIcon(int type) {
            return this.getIcon(false);
        }

        public Image getOpenedIcon(int type) {
            return this.getIcon(true);
        }

        static final class ModuleChildren
        extends Children.Keys<NbModuleProject>
        implements ChangeListener {
            private final SuiteProject suite;

            public ModuleChildren(SuiteProject suite) {
                ((SubprojectProvider)suite.getLookup().lookup(SubprojectProvider.class)).addChangeListener((ChangeListener)this);
                this.suite = suite;
            }

            protected void addNotify() {
                this.updateKeys();
            }

            private void updateKeys() {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TreeSet<NbModuleProject> subModules = new TreeSet<NbModuleProject>(Util.projectDisplayNameComparator());
                        subModules.addAll(SuiteUtils.getSubProjects(suite));
                        this.setKeys(subModules);
                    }
                });
            }

            protected void removeNotify() {
                ((SubprojectProvider)this.suite.getLookup().lookup(SubprojectProvider.class)).removeChangeListener((ChangeListener)this);
                this.setKeys(Collections.emptySet());
            }

            protected Node[] createNodes(NbModuleProject p) {
                return new Node[]{new SuiteComponentNode(p)};
            }

            @Override
            public void stateChanged(ChangeEvent ev) {
                this.updateKeys();
            }
        }
    }

    private static final class OpenProjectAction
    extends CookieAction {
        private OpenProjectAction() {
        }

        protected void performAction(Node[] activatedNodes) {
            final Project[] projects = new Project[activatedNodes.length];
            for (int i = 0; i < activatedNodes.length; ++i) {
                Project project;
                projects[i] = project = (Project)activatedNodes[i].getLookup().lookup(Project.class);
            }
            StatusDisplayer.getDefault().setStatusText(ModulesNodeFactory.getMessage("MSG_OpeningProjects"));
            OpenProjects.getDefault().open(projects, false);
            if (projects.length > 0) {
                RequestProcessor.getDefault().post(new Runnable(){
                    final /* synthetic */ OpenProjectAction this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void run() {
                        ProjectActionUtils.selectAndExpandProject((Project)projects[0]);
                    }
                }, 500);
            }
        }

        public String getName() {
            return ModulesNodeFactory.getMessage("CTL_OpenProject");
        }

        public HelpCtx getHelpCtx() {
            return HelpCtx.DEFAULT_HELP;
        }

        protected boolean asynchronous() {
            return true;
        }

        protected int mode() {
            return 4;
        }

        protected Class[] cookieClasses() {
            return new Class[]{Project.class};
        }
    }

    private static final class RemoveSuiteComponentAction
    extends NodeAction {
        private RemoveSuiteComponentAction() {
        }

        protected void performAction(Node[] activatedNodes) {
            for (int i = 0; i < activatedNodes.length; ++i) {
                final NbModuleProject suiteComponent = (NbModuleProject)activatedNodes[i].getLookup().lookup(NbModuleProject.class);
                assert (suiteComponent != null) : "NbModuleProject in lookup";
                boolean remove = true;
                try {
                    NbModuleProject[] modules = SuiteUtils.getDependentModules(suiteComponent);
                    if (modules.length > 0) {
                        StringBuilder sb = new StringBuilder("<ul>");
                        for (int j = 0; j < modules.length; ++j) {
                            sb.append("<li>" + ProjectUtils.getInformation((Project)modules[j]).getDisplayName() + "</li>");
                        }
                        sb.append("</ul>");
                        String displayName = ProjectUtils.getInformation((Project)suiteComponent).getDisplayName();
                        String confirmMessage = NbBundle.getMessage(SuiteLogicalView.class, (String)"MSG_RemovingModuleMessage", (Object)displayName, (Object)sb.toString());
                        remove = ApisupportAntUIUtils.showAcceptCancelDialog(NbBundle.getMessage(SuiteLogicalView.class, (String)"CTL_RemovingModuleTitle", (Object)displayName), confirmMessage, ModulesNodeFactory.getMessage("CTL_RemoveDependency"), null, 3);
                    }
                }
                catch (IOException ex) {
                    LOG.log(Level.INFO, null, ex);
                }
                if (!remove) continue;
                RequestProcessor.getDefault().post(new Runnable(){
                    final /* synthetic */ RemoveSuiteComponentAction this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void run() {
                        try {
                            SuiteUtils.removeModuleFromSuiteWithDependencies(suiteComponent);
                        }
                        catch (IOException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                });
            }
        }

        protected boolean enable(Node[] activatedNodes) {
            return true;
        }

        public String getName() {
            return ModulesNodeFactory.getMessage("CTL_RemoveModule");
        }

        public HelpCtx getHelpCtx() {
            return HelpCtx.DEFAULT_HELP;
        }

        protected boolean asynchronous() {
            return false;
        }
    }

    private static final class SuiteComponentNode
    extends AbstractNode {
        private static final Action REMOVE_ACTION = new RemoveSuiteComponentAction();
        private static final Action OPEN_ACTION = new OpenProjectAction();

        public SuiteComponentNode(NbModuleProject suiteComponent) {
            super(Children.LEAF, Lookups.fixed((Object[])new Object[]{suiteComponent}));
            ProjectInformation info = ProjectUtils.getInformation((Project)suiteComponent);
            this.setName(info.getName());
            this.setDisplayName(info.getDisplayName());
            this.setIconBaseWithExtension("org/netbeans/modules/apisupport/project/resources/module.png");
            info.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(final PropertyChangeEvent evt) {
                    ImportantFilesNodeFactory.getNodesSyncRP().post(new Runnable(){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        @Override
                        public void run() {
                            if ("displayName".equals(evt.getPropertyName())) {
                                this.this$1.this.setDisplayName((String)evt.getNewValue());
                            } else if ("name".equals(evt.getPropertyName())) {
                                this.this$1.this.setName((String)evt.getNewValue());
                            }
                        }
                    });
                }
            });
        }

        public Action[] getActions(boolean context) {
            return new Action[]{OPEN_ACTION, REMOVE_ACTION};
        }

        public Action getPreferredAction() {
            return OPEN_ACTION;
        }
    }

    static final class AddNewLibraryWrapperAction
    extends AbstractAction {
        private final Project suiteProvider;
        private final NbModuleProject target;

        public AddNewLibraryWrapperAction(Project suiteProvider, NbModuleProject target) {
            super(ModulesNodeFactory.getMessage("CTL_AddNewLibrary"));
            this.suiteProvider = suiteProvider;
            this.target = target;
        }

        public AddNewLibraryWrapperAction(Project suiteProvider) {
            this(suiteProvider, null);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            NbModuleProject project = ApisupportAntUIUtils.runLibraryWrapperWizard(this.suiteProvider);
            if (project != null && this.target != null) {
                try {
                    ApisupportAntUtils.addDependency(this.target, project.getCodeNameBase(), null, null, true, null);
                    ProjectManager.getDefault().saveProject((Project)this.target);
                }
                catch (IOException e) {
                    LOG.log(Level.INFO, "could not add dependency on " + project.getCodeNameBase() + " to " + String.valueOf(this.target), e);
                }
            }
        }
    }

    private static final class AddNewSuiteComponentAction
    extends AbstractAction {
        private final SuiteProject suite;

        public AddNewSuiteComponentAction(SuiteProject suite) {
            super(ModulesNodeFactory.getMessage("CTL_AddNewModule"));
            this.suite = suite;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            NewNbModuleWizardIterator iterator = NewNbModuleWizardIterator.createSuiteComponentIterator(this.suite);
            ApisupportAntUIUtils.runProjectWizard(iterator, "CTL_NewModuleProject");
        }
    }

    private static final class AddSuiteComponentAction
    extends AbstractAction {
        private final SuiteProject suite;

        public AddSuiteComponentAction(SuiteProject suite) {
            super(ModulesNodeFactory.getMessage("CTL_AddModule"));
            this.suite = suite;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            NbModuleProject project = ApisupportAntUIUtils.chooseSuiteComponent(WindowManager.getDefault().getMainWindow(), this.suite);
            if (project != null) {
                if (!SuiteUtils.contains(this.suite, project)) {
                    try {
                        SuiteUtils.addModule(this.suite, project);
                        ProjectManager.getDefault().saveProject((Project)this.suite);
                    }
                    catch (IOException ex) {
                        LOG.log(Level.INFO, "could not add " + String.valueOf(project) + " to " + String.valueOf(this.suite), ex);
                    }
                } else {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(SuiteLogicalView.class, (String)"MSG_SuiteAlreadyContainsCNB", (Object)project.getCodeNameBase())));
                }
            }
        }
    }
}

