/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.devops.model.CreateDeployStageDetails;
import com.oracle.bmc.devops.model.DeployStagePredecessorCollection;
import com.oracle.bmc.devops.model.DeployStageRollbackPolicy;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="deployStageType")
@JsonFilter(value="explicitlySetFilter")
public final class CreateOkeDeployStageDetails
extends CreateDeployStageDetails {
    @JsonProperty(value="okeClusterDeployEnvironmentId")
    private final String okeClusterDeployEnvironmentId;
    @JsonProperty(value="kubernetesManifestDeployArtifactIds")
    private final List<String> kubernetesManifestDeployArtifactIds;
    @JsonProperty(value="namespace")
    private final String namespace;
    @JsonProperty(value="rollbackPolicy")
    private final DeployStageRollbackPolicy rollbackPolicy;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public CreateOkeDeployStageDetails(String description, String displayName, String deployPipelineId, DeployStagePredecessorCollection deployStagePredecessorCollection, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, String okeClusterDeployEnvironmentId, List<String> kubernetesManifestDeployArtifactIds, String namespace, DeployStageRollbackPolicy rollbackPolicy) {
        super(description, displayName, deployPipelineId, deployStagePredecessorCollection, freeformTags, definedTags);
        this.okeClusterDeployEnvironmentId = okeClusterDeployEnvironmentId;
        this.kubernetesManifestDeployArtifactIds = kubernetesManifestDeployArtifactIds;
        this.namespace = namespace;
        this.rollbackPolicy = rollbackPolicy;
    }

    public String getOkeClusterDeployEnvironmentId() {
        return this.okeClusterDeployEnvironmentId;
    }

    public List<String> getKubernetesManifestDeployArtifactIds() {
        return this.kubernetesManifestDeployArtifactIds;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public DeployStageRollbackPolicy getRollbackPolicy() {
        return this.rollbackPolicy;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateOkeDeployStageDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", okeClusterDeployEnvironmentId=").append(String.valueOf(this.okeClusterDeployEnvironmentId));
        sb.append(", kubernetesManifestDeployArtifactIds=").append(String.valueOf(this.kubernetesManifestDeployArtifactIds));
        sb.append(", namespace=").append(String.valueOf(this.namespace));
        sb.append(", rollbackPolicy=").append(String.valueOf((Object)this.rollbackPolicy));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateOkeDeployStageDetails)) {
            return false;
        }
        CreateOkeDeployStageDetails other = (CreateOkeDeployStageDetails)((Object)o);
        return Objects.equals(this.okeClusterDeployEnvironmentId, other.okeClusterDeployEnvironmentId) && Objects.equals(this.kubernetesManifestDeployArtifactIds, other.kubernetesManifestDeployArtifactIds) && Objects.equals(this.namespace, other.namespace) && Objects.equals((Object)this.rollbackPolicy, (Object)other.rollbackPolicy) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.okeClusterDeployEnvironmentId == null ? 43 : this.okeClusterDeployEnvironmentId.hashCode());
        result = result * 59 + (this.kubernetesManifestDeployArtifactIds == null ? 43 : this.kubernetesManifestDeployArtifactIds.hashCode());
        result = result * 59 + (this.namespace == null ? 43 : this.namespace.hashCode());
        result = result * 59 + (this.rollbackPolicy == null ? 43 : this.rollbackPolicy.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="deployPipelineId")
        private String deployPipelineId;
        @JsonProperty(value="deployStagePredecessorCollection")
        private DeployStagePredecessorCollection deployStagePredecessorCollection;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="okeClusterDeployEnvironmentId")
        private String okeClusterDeployEnvironmentId;
        @JsonProperty(value="kubernetesManifestDeployArtifactIds")
        private List<String> kubernetesManifestDeployArtifactIds;
        @JsonProperty(value="namespace")
        private String namespace;
        @JsonProperty(value="rollbackPolicy")
        private DeployStageRollbackPolicy rollbackPolicy;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder deployPipelineId(String deployPipelineId) {
            this.deployPipelineId = deployPipelineId;
            this.__explicitlySet__.add("deployPipelineId");
            return this;
        }

        public Builder deployStagePredecessorCollection(DeployStagePredecessorCollection deployStagePredecessorCollection) {
            this.deployStagePredecessorCollection = deployStagePredecessorCollection;
            this.__explicitlySet__.add("deployStagePredecessorCollection");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder okeClusterDeployEnvironmentId(String okeClusterDeployEnvironmentId) {
            this.okeClusterDeployEnvironmentId = okeClusterDeployEnvironmentId;
            this.__explicitlySet__.add("okeClusterDeployEnvironmentId");
            return this;
        }

        public Builder kubernetesManifestDeployArtifactIds(List<String> kubernetesManifestDeployArtifactIds) {
            this.kubernetesManifestDeployArtifactIds = kubernetesManifestDeployArtifactIds;
            this.__explicitlySet__.add("kubernetesManifestDeployArtifactIds");
            return this;
        }

        public Builder namespace(String namespace) {
            this.namespace = namespace;
            this.__explicitlySet__.add("namespace");
            return this;
        }

        public Builder rollbackPolicy(DeployStageRollbackPolicy rollbackPolicy) {
            this.rollbackPolicy = rollbackPolicy;
            this.__explicitlySet__.add("rollbackPolicy");
            return this;
        }

        public CreateOkeDeployStageDetails build() {
            CreateOkeDeployStageDetails model = new CreateOkeDeployStageDetails(this.description, this.displayName, this.deployPipelineId, this.deployStagePredecessorCollection, this.freeformTags, this.definedTags, this.okeClusterDeployEnvironmentId, this.kubernetesManifestDeployArtifactIds, this.namespace, this.rollbackPolicy);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateOkeDeployStageDetails model) {
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("deployPipelineId")) {
                this.deployPipelineId(model.getDeployPipelineId());
            }
            if (model.wasPropertyExplicitlySet("deployStagePredecessorCollection")) {
                this.deployStagePredecessorCollection(model.getDeployStagePredecessorCollection());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("okeClusterDeployEnvironmentId")) {
                this.okeClusterDeployEnvironmentId(model.getOkeClusterDeployEnvironmentId());
            }
            if (model.wasPropertyExplicitlySet("kubernetesManifestDeployArtifactIds")) {
                this.kubernetesManifestDeployArtifactIds(model.getKubernetesManifestDeployArtifactIds());
            }
            if (model.wasPropertyExplicitlySet("namespace")) {
                this.namespace(model.getNamespace());
            }
            if (model.wasPropertyExplicitlySet("rollbackPolicy")) {
                this.rollbackPolicy(model.getRollbackPolicy());
            }
            return this;
        }
    }
}

