/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.devops.model.VerificationKeySource;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="verificationKeySourceType")
@JsonFilter(value="explicitlySetFilter")
public final class InlinePublicKeyVerificationKeySource
extends VerificationKeySource {
    @JsonProperty(value="currentPublicKey")
    private final String currentPublicKey;
    @JsonProperty(value="previousPublicKey")
    private final String previousPublicKey;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public InlinePublicKeyVerificationKeySource(String currentPublicKey, String previousPublicKey) {
        this.currentPublicKey = currentPublicKey;
        this.previousPublicKey = previousPublicKey;
    }

    public String getCurrentPublicKey() {
        return this.currentPublicKey;
    }

    public String getPreviousPublicKey() {
        return this.previousPublicKey;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("InlinePublicKeyVerificationKeySource(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", currentPublicKey=").append(String.valueOf(this.currentPublicKey));
        sb.append(", previousPublicKey=").append(String.valueOf(this.previousPublicKey));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InlinePublicKeyVerificationKeySource)) {
            return false;
        }
        InlinePublicKeyVerificationKeySource other = (InlinePublicKeyVerificationKeySource)((Object)o);
        return Objects.equals(this.currentPublicKey, other.currentPublicKey) && Objects.equals(this.previousPublicKey, other.previousPublicKey) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.currentPublicKey == null ? 43 : this.currentPublicKey.hashCode());
        result = result * 59 + (this.previousPublicKey == null ? 43 : this.previousPublicKey.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="currentPublicKey")
        private String currentPublicKey;
        @JsonProperty(value="previousPublicKey")
        private String previousPublicKey;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder currentPublicKey(String currentPublicKey) {
            this.currentPublicKey = currentPublicKey;
            this.__explicitlySet__.add("currentPublicKey");
            return this;
        }

        public Builder previousPublicKey(String previousPublicKey) {
            this.previousPublicKey = previousPublicKey;
            this.__explicitlySet__.add("previousPublicKey");
            return this;
        }

        public InlinePublicKeyVerificationKeySource build() {
            InlinePublicKeyVerificationKeySource model = new InlinePublicKeyVerificationKeySource(this.currentPublicKey, this.previousPublicKey);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(InlinePublicKeyVerificationKeySource model) {
            if (model.wasPropertyExplicitlySet("currentPublicKey")) {
                this.currentPublicKey(model.getCurrentPublicKey());
            }
            if (model.wasPropertyExplicitlySet("previousPublicKey")) {
                this.previousPublicKey(model.getPreviousPublicKey());
            }
            return this;
        }
    }
}

