/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class LoadBalancerTrafficShiftRolloutPolicy
extends ExplicitlySetBmcModel {
    @JsonProperty(value="batchCount")
    private final Integer batchCount;
    @JsonProperty(value="batchDelayInSeconds")
    private final Integer batchDelayInSeconds;
    @JsonProperty(value="rampLimitPercent")
    private final Float rampLimitPercent;

    @Deprecated
    @ConstructorProperties(value={"batchCount", "batchDelayInSeconds", "rampLimitPercent"})
    public LoadBalancerTrafficShiftRolloutPolicy(Integer batchCount, Integer batchDelayInSeconds, Float rampLimitPercent) {
        this.batchCount = batchCount;
        this.batchDelayInSeconds = batchDelayInSeconds;
        this.rampLimitPercent = rampLimitPercent;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Integer getBatchCount() {
        return this.batchCount;
    }

    public Integer getBatchDelayInSeconds() {
        return this.batchDelayInSeconds;
    }

    public Float getRampLimitPercent() {
        return this.rampLimitPercent;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("LoadBalancerTrafficShiftRolloutPolicy(");
        sb.append("super=").append(super.toString());
        sb.append("batchCount=").append(String.valueOf(this.batchCount));
        sb.append(", batchDelayInSeconds=").append(String.valueOf(this.batchDelayInSeconds));
        sb.append(", rampLimitPercent=").append(String.valueOf(this.rampLimitPercent));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LoadBalancerTrafficShiftRolloutPolicy)) {
            return false;
        }
        LoadBalancerTrafficShiftRolloutPolicy other = (LoadBalancerTrafficShiftRolloutPolicy)((Object)o);
        return Objects.equals(this.batchCount, other.batchCount) && Objects.equals(this.batchDelayInSeconds, other.batchDelayInSeconds) && Objects.equals(this.rampLimitPercent, other.rampLimitPercent) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.batchCount == null ? 43 : this.batchCount.hashCode());
        result = result * 59 + (this.batchDelayInSeconds == null ? 43 : this.batchDelayInSeconds.hashCode());
        result = result * 59 + (this.rampLimitPercent == null ? 43 : this.rampLimitPercent.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="batchCount")
        private Integer batchCount;
        @JsonProperty(value="batchDelayInSeconds")
        private Integer batchDelayInSeconds;
        @JsonProperty(value="rampLimitPercent")
        private Float rampLimitPercent;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder batchCount(Integer batchCount) {
            this.batchCount = batchCount;
            this.__explicitlySet__.add("batchCount");
            return this;
        }

        public Builder batchDelayInSeconds(Integer batchDelayInSeconds) {
            this.batchDelayInSeconds = batchDelayInSeconds;
            this.__explicitlySet__.add("batchDelayInSeconds");
            return this;
        }

        public Builder rampLimitPercent(Float rampLimitPercent) {
            this.rampLimitPercent = rampLimitPercent;
            this.__explicitlySet__.add("rampLimitPercent");
            return this;
        }

        public LoadBalancerTrafficShiftRolloutPolicy build() {
            LoadBalancerTrafficShiftRolloutPolicy model = new LoadBalancerTrafficShiftRolloutPolicy(this.batchCount, this.batchDelayInSeconds, this.rampLimitPercent);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(LoadBalancerTrafficShiftRolloutPolicy model) {
            if (model.wasPropertyExplicitlySet("batchCount")) {
                this.batchCount(model.getBatchCount());
            }
            if (model.wasPropertyExplicitlySet("batchDelayInSeconds")) {
                this.batchDelayInSeconds(model.getBatchDelayInSeconds());
            }
            if (model.wasPropertyExplicitlySet("rampLimitPercent")) {
                this.rampLimitPercent(model.getRampLimitPercent());
            }
            return this;
        }
    }
}

