/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.common.parser;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.payara.common.PayaraInstance;
import org.netbeans.modules.payara.common.PayaraLogger;
import org.netbeans.modules.payara.common.PortCollection;
import org.netbeans.modules.payara.common.utils.Util;
import org.netbeans.modules.payara.tooling.utils.ServerUtils;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;

public class DomainXMLChangeListener
implements FileChangeListener {
    private static final Logger LOGGER = PayaraLogger.get(DomainXMLChangeListener.class);
    private final PayaraInstance instance;
    private final String path;

    public static void registerListener(PayaraInstance instance) {
        String domainDirPath = instance.getDomainsFolder();
        String domainName = instance.getDomainName();
        String domainXMLName = ServerUtils.getDomainConfigFile((String)domainDirPath, (String)domainName);
        File configPAth = FileUtil.normalizeFile((File)new File(domainXMLName));
        FileUtil.addFileChangeListener((FileChangeListener)instance.getDomainXMLChangeListener(), (File)configPAth);
    }

    public static void unregisterListener(PayaraInstance instance) {
        String domainDirPath = instance.getDomainsFolder();
        String domainName = instance.getDomainName();
        String domainXMLName = ServerUtils.getDomainConfigFile((String)domainDirPath, (String)domainName);
        File configPAth = FileUtil.normalizeFile((File)new File(domainXMLName));
        FileUtil.removeFileChangeListener((FileChangeListener)instance.getDomainXMLChangeListener(), (File)configPAth);
    }

    public DomainXMLChangeListener(PayaraInstance instance, String domainXML) {
        this.instance = instance;
        this.path = domainXML;
    }

    public void fileFolderCreated(FileEvent fe) {
        LOGGER.log(Level.WARNING, "Payara configuration file {0} seems to be a folder!", this.path);
    }

    public void fileDataCreated(FileEvent fe) {
        LOGGER.log(Level.WARNING, "Payara configuration file {0} seems to be a folder!", this.path);
    }

    public void fileChanged(FileEvent fe) {
        PortCollection pc;
        File domainDir = new File(this.instance.getDomainsFolder(), this.instance.getDomainName());
        if (Util.readServerConfiguration(domainDir, pc = new PortCollection())) {
            LOGGER.log(Level.INFO, "Payara configuration file {0} was modified, updating server configuration.", this.path);
            this.instance.setHttpPort(pc.getHttpPort());
            this.instance.setAdminPort(pc.getAdminPort());
        } else {
            LOGGER.log(Level.INFO, "Payara configuration file {0} was modified but configuration update failed.", this.path);
        }
    }

    public void fileDeleted(FileEvent fe) {
        LOGGER.log(Level.FINE, "Payara configuration file {0} was deleted.", this.path);
    }

    public void fileRenamed(FileRenameEvent fe) {
        LOGGER.log(Level.FINE, "Payara configuration file {0} was renamed.", this.path);
    }

    public void fileAttributeChanged(FileAttributeEvent fe) {
        LOGGER.log(Level.FINE, "Payara configuration file {0} attributes were changed.", this.path);
    }
}

